/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.handlers;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.federation.model.handlers.HandlerAddHandler;
import org.wildfly.extension.picketlink.federation.model.handlers.HandlerParameterResourceDefinition;
import org.wildfly.extension.picketlink.federation.service.SAMLHandlerService;

public class HandlerParameterAddHandler
extends RestartParentResourceAddHandler {
    static final HandlerParameterAddHandler INSTANCE = new HandlerParameterAddHandler();

    private HandlerParameterAddHandler() {
        super(ModelElement.COMMON_HANDLER.getName());
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition attribute : HandlerParameterResourceDefinition.INSTANCE.getAttributes()) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        HandlerAddHandler.launchServices(context, parentAddress, parentModel, verificationHandler, null);
    }

    protected ServiceName getParentServiceName(PathAddress parentAddress) {
        String providerAlias = parentAddress.subAddress(0, parentAddress.size() - 1).getLastElement().getValue();
        String className = parentAddress.getLastElement().getValue();
        return SAMLHandlerService.createServiceName(providerAlias, className);
    }
}

