/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.idp;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.picketlink.identity.federation.bindings.wildfly.idp.UndertowAttributeManager;
import org.picketlink.identity.federation.bindings.wildfly.idp.UndertowRoleGenerator;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.federation.config.IDPConfiguration;
import org.wildfly.extension.picketlink.federation.model.idp.AttributeManagerResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.idp.AttributeManagerTypeEnum;
import org.wildfly.extension.picketlink.federation.model.idp.IdentityProviderResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.idp.RoleGeneratorResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.idp.RoleGeneratorTypeEnum;
import org.wildfly.extension.picketlink.federation.service.FederationService;
import org.wildfly.extension.picketlink.federation.service.IdentityProviderService;
import org.wildfly.extension.picketlink.logging.PicketLinkLogger;

public class IdentityProviderAddHandler
extends AbstractAddStepHandler {
    static final IdentityProviderAddHandler INSTANCE = new IdentityProviderAddHandler();

    private IdentityProviderAddHandler() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition attribute : IdentityProviderResourceDefinition.ATTRIBUTE_DEFINITIONS) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        ModelNode identityProviderNode = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        IdentityProviderAddHandler.launchServices(context, identityProviderNode, verificationHandler, newControllers, pathAddress);
    }

    static void launchServices(OperationContext context, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, PathAddress pathAddress) throws OperationFailedException {
        String alias = pathAddress.getLastElement().getValue();
        IdentityProviderService service = new IdentityProviderService(IdentityProviderAddHandler.toIDPConfig(context, model, alias));
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(IdentityProviderService.createServiceName(alias), (Service)service);
        String federationAlias = pathAddress.subAddress(0, pathAddress.size() - 1).getLastElement().getValue();
        serviceBuilder.addDependency(FederationService.createServiceName(federationAlias), FederationService.class, service.getFederationService());
        ServiceController controller = serviceBuilder.addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.PASSIVE).install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IDPConfiguration toIDPConfig(OperationContext context, ModelNode fromModel, String alias) throws OperationFailedException {
        String attributeManagerType;
        String roleGeneratorType;
        IDPConfiguration idpType = new IDPConfiguration(alias);
        boolean external = IdentityProviderResourceDefinition.EXTERNAL.resolveModelAttribute(context, fromModel).asBoolean();
        idpType.setExternal(external);
        String url = IdentityProviderResourceDefinition.URL.resolveModelAttribute(context, fromModel).asString();
        idpType.setIdentityURL(url);
        if (idpType.isExternal()) return idpType;
        ModelNode securityDomain = IdentityProviderResourceDefinition.SECURITY_DOMAIN.resolveModelAttribute(context, fromModel);
        if (!securityDomain.isDefined()) {
            throw PicketLinkLogger.ROOT_LOGGER.federationRequiredAttribute(ModelElement.COMMON_SECURITY_DOMAIN.getName(), alias);
        }
        idpType.setSecurityDomain(securityDomain.asString());
        boolean supportsSignatures = IdentityProviderResourceDefinition.SUPPORT_SIGNATURES.resolveModelAttribute(context, fromModel).asBoolean();
        idpType.setSupportsSignature(supportsSignatures);
        boolean supportsMetadata = IdentityProviderResourceDefinition.SUPPORT_METADATA.resolveModelAttribute(context, fromModel).asBoolean();
        idpType.setSupportMetadata(supportsMetadata);
        boolean encrypt = IdentityProviderResourceDefinition.ENCRYPT.resolveModelAttribute(context, fromModel).asBoolean();
        idpType.setEncrypt(encrypt);
        boolean sslAuthentication = IdentityProviderResourceDefinition.SSL_AUTHENTICATION.resolveModelAttribute(context, fromModel).asBoolean();
        idpType.setSSLClientAuthentication(sslAuthentication);
        boolean strictPostBinding = IdentityProviderResourceDefinition.STRICT_POST_BINDING.resolveModelAttribute(context, fromModel).asBoolean();
        idpType.setStrictPostBinding(strictPostBinding);
        ModelNode roleGenerator = fromModel.get(ModelElement.IDENTITY_PROVIDER_ROLE_GENERATOR.getName());
        if (roleGenerator.isDefined()) {
            ModelNode roleGeneratorValue = roleGenerator.asProperty().getValue();
            ModelNode classNameNode = RoleGeneratorResourceDefinition.CLASS_NAME.resolveModelAttribute(context, roleGeneratorValue);
            ModelNode codeNode = RoleGeneratorResourceDefinition.CODE.resolveModelAttribute(context, roleGeneratorValue);
            if (classNameNode.isDefined()) {
                roleGeneratorType = classNameNode.asString();
            } else {
                if (!codeNode.isDefined()) throw PicketLinkLogger.ROOT_LOGGER.typeNotProvided(ModelElement.IDENTITY_PROVIDER_ROLE_GENERATOR.getName());
                roleGeneratorType = RoleGeneratorTypeEnum.forType(codeNode.asString());
            }
        } else {
            roleGeneratorType = UndertowRoleGenerator.class.getName();
        }
        idpType.setRoleGenerator(roleGeneratorType);
        ModelNode attributeManager = fromModel.get(ModelElement.IDENTITY_PROVIDER_ATTRIBUTE_MANAGER.getName());
        if (attributeManager.isDefined()) {
            ModelNode attributeManagerValue = attributeManager.asProperty().getValue();
            ModelNode classNameNode = AttributeManagerResourceDefinition.CLASS_NAME.resolveModelAttribute(context, attributeManagerValue);
            ModelNode codeNode = AttributeManagerResourceDefinition.CODE.resolveModelAttribute(context, attributeManagerValue);
            if (classNameNode.isDefined()) {
                attributeManagerType = classNameNode.asString();
            } else {
                if (!codeNode.isDefined()) throw PicketLinkLogger.ROOT_LOGGER.typeNotProvided(ModelElement.IDENTITY_PROVIDER_ATTRIBUTE_MANAGER.getName());
                attributeManagerType = AttributeManagerTypeEnum.forType(codeNode.asString());
            }
        } else {
            attributeManagerType = UndertowAttributeManager.class.getName();
        }
        idpType.setAttributeManager(attributeManagerType);
        return idpType;
    }
}

