/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.parser;

import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.common.model.XMLElement;
import org.wildfly.extension.picketlink.federation.Namespace;
import org.wildfly.extension.picketlink.federation.model.FederationResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.KeyStoreProviderResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.handlers.HandlerParameterResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.handlers.HandlerResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.idp.AttributeManagerResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.idp.IdentityProviderResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.idp.RoleGeneratorResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.idp.TrustDomainResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.saml.SAMLResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.sp.ServiceProviderResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.CredentialHandlerResourceDefinition;

public class FederationSubsystemReader_1_0
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> addOperations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        Namespace nameSpace = Namespace.forUri(reader.getNamespaceURI());
        ModelNode subsystemNode = this.createSubsystemRoot();
        addOperations.add(subsystemNode);
        switch (nameSpace) {
            case PICKETLINK_FEDERATION_1_0: {
                this.readElement_1_0(reader, subsystemNode, addOperations);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void readElement_1_0(XMLExtendedStreamReader reader, ModelNode subsystemNode, List<ModelNode> addOperations) throws XMLStreamException {
        if (Namespace.PICKETLINK_FEDERATION_1_0 != Namespace.forUri(reader.getNamespaceURI())) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        block3: while (reader.hasNext() && reader.nextTag() != 8) {
            if (!reader.isStartElement() || XMLElement.forName(reader.getLocalName()) != null) continue;
            ModelElement modelKey = ModelElement.forName(reader.getLocalName());
            if (modelKey == null) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (modelKey) {
                case FEDERATION: {
                    this.parseFederation(reader, subsystemNode, addOperations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseFederation(XMLExtendedStreamReader reader, ModelNode subsystemNode, List<ModelNode> addOperations) throws XMLStreamException {
        ModelNode federationNode = this.parseConfig(reader, ModelElement.FEDERATION, ModelElement.COMMON_NAME.getName(), subsystemNode, Arrays.asList(FederationResourceDefinition.ATTRIBUTE_DEFINITIONS), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                switch (element) {
                    case KEY_STORE: {
                        FederationSubsystemReader_1_0.this.parseConfig(reader, ModelElement.KEY_STORE, null, parentNode, KeyStoreProviderResourceDefinition.INSTANCE.getAttributes(), addOperations);
                        break;
                    }
                    case SAML: {
                        FederationSubsystemReader_1_0.this.parseConfig(reader, ModelElement.SAML, null, parentNode, SAMLResourceDefinition.INSTANCE.getAttributes(), addOperations);
                        break;
                    }
                    case IDENTITY_PROVIDER: {
                        FederationSubsystemReader_1_0.this.parseIdentityProviderConfig(reader, parentNode, addOperations);
                        break;
                    }
                    case SERVICE_PROVIDER: {
                        FederationSubsystemReader_1_0.this.parseServiceProviderConfig(reader, parentNode, addOperations);
                        break;
                    }
                    default: {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
            }
        }, ModelElement.FEDERATION, federationNode, reader, addOperations);
    }

    private void parseServiceProviderConfig(XMLExtendedStreamReader reader, ModelNode federationNode, List<ModelNode> addOperations) throws XMLStreamException {
        ModelNode serviceProviderNode = this.parseConfig(reader, ModelElement.SERVICE_PROVIDER, ModelElement.COMMON_NAME.getName(), federationNode, Arrays.asList(ServiceProviderResourceDefinition.ATTRIBUTE_DEFINITIONS), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                switch (element) {
                    case COMMON_HANDLER: {
                        FederationSubsystemReader_1_0.this.parseHandlerConfig(reader, parentNode, addOperations);
                    }
                }
            }
        }, ModelElement.SERVICE_PROVIDER, serviceProviderNode, reader, addOperations);
    }

    private void parseHandlerConfig(XMLExtendedStreamReader reader, ModelNode entityProviderNode, List<ModelNode> addOperations) throws XMLStreamException {
        String name = this.resolveNodeName(reader, CredentialHandlerResourceDefinition.CLASS_NAME, CredentialHandlerResourceDefinition.CODE);
        ModelNode handlerNode = this.parseConfig(reader, ModelElement.COMMON_HANDLER, name, entityProviderNode, HandlerResourceDefinition.INSTANCE.getAttributes(), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                switch (element) {
                    case COMMON_HANDLER_PARAMETER: {
                        FederationSubsystemReader_1_0.this.parseConfig(reader, ModelElement.COMMON_HANDLER_PARAMETER, ModelElement.COMMON_NAME.getName(), parentNode, HandlerParameterResourceDefinition.INSTANCE.getAttributes(), addOperations);
                        break;
                    }
                    default: {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
            }
        }, ModelElement.COMMON_HANDLER, handlerNode, reader, addOperations);
    }

    private void parseIdentityProviderConfig(XMLExtendedStreamReader reader, ModelNode federationNode, List<ModelNode> addOperations) throws XMLStreamException {
        ModelNode identityProviderNode = this.parseConfig(reader, ModelElement.IDENTITY_PROVIDER, ModelElement.COMMON_NAME.getName(), federationNode, Arrays.asList(IdentityProviderResourceDefinition.ATTRIBUTE_DEFINITIONS), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                switch (element) {
                    case IDENTITY_PROVIDER_TRUST_DOMAIN: {
                        FederationSubsystemReader_1_0.this.parseConfig(reader, ModelElement.IDENTITY_PROVIDER_TRUST_DOMAIN, ModelElement.COMMON_NAME.getName(), parentNode, TrustDomainResourceDefinition.INSTANCE.getAttributes(), addOperations);
                        break;
                    }
                    case IDENTITY_PROVIDER_ROLE_GENERATOR: {
                        String roleGeneratorName = FederationSubsystemReader_1_0.this.resolveNodeName(reader, RoleGeneratorResourceDefinition.CLASS_NAME, RoleGeneratorResourceDefinition.CODE);
                        FederationSubsystemReader_1_0.this.parseConfig(reader, ModelElement.IDENTITY_PROVIDER_ROLE_GENERATOR, roleGeneratorName, parentNode, RoleGeneratorResourceDefinition.INSTANCE.getAttributes(), addOperations);
                        break;
                    }
                    case IDENTITY_PROVIDER_ATTRIBUTE_MANAGER: {
                        String attributeManagerName = FederationSubsystemReader_1_0.this.resolveNodeName(reader, AttributeManagerResourceDefinition.CLASS_NAME, AttributeManagerResourceDefinition.CODE);
                        FederationSubsystemReader_1_0.this.parseConfig(reader, ModelElement.IDENTITY_PROVIDER_ATTRIBUTE_MANAGER, attributeManagerName, parentNode, AttributeManagerResourceDefinition.INSTANCE.getAttributes(), addOperations);
                        break;
                    }
                    case COMMON_HANDLER: {
                        FederationSubsystemReader_1_0.this.parseHandlerConfig(reader, parentNode, addOperations);
                        break;
                    }
                    default: {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
            }
        }, ModelElement.IDENTITY_PROVIDER, identityProviderNode, reader, addOperations);
    }

    private ModelNode createSubsystemRoot() {
        ModelNode subsystemAddress = new ModelNode();
        subsystemAddress.add("subsystem", "picketlink-federation");
        subsystemAddress.protect();
        return Util.getEmptyOperation((String)"add", (ModelNode)subsystemAddress);
    }

    private ModelNode parseConfig(XMLExtendedStreamReader reader, ModelElement xmlElement, String key, ModelNode lastNode, List<SimpleAttributeDefinition> attributes, List<ModelNode> addOperations) throws XMLStreamException {
        if (!reader.getLocalName().equals(xmlElement.getName())) {
            return null;
        }
        ModelNode modelNode = Util.getEmptyOperation((String)"add", null);
        for (SimpleAttributeDefinition simpleAttributeDefinition : attributes) {
            simpleAttributeDefinition.parseAndSetParameter(reader.getAttributeValue("", simpleAttributeDefinition.getXmlName()), modelNode, (XMLStreamReader)reader);
        }
        String name = xmlElement.getName();
        if (key != null) {
            name = key;
            if (modelNode.hasDefined(key)) {
                name = modelNode.get(key).asString();
            } else {
                String attributeValue = reader.getAttributeValue("", key);
                if (attributeValue != null) {
                    name = attributeValue;
                }
            }
        }
        modelNode.get("address").set(lastNode.clone().get("address").add(xmlElement.getName(), name));
        addOperations.add(modelNode);
        return modelNode;
    }

    private void parseElement(ElementParser parser, ModelElement parentElement, ModelNode parentNode, XMLExtendedStreamReader reader, List<ModelNode> addOperations) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 8) {
            if (!reader.isStartElement()) {
                if (!reader.isEndElement() || !reader.getLocalName().equals(parentElement.getName())) continue;
                break;
            }
            if (reader.getLocalName().equals(parentElement.getName())) continue;
            ModelElement element = ModelElement.forName(reader.getLocalName());
            if (element == null) {
                if (XMLElement.forName(reader.getLocalName()) != null) continue;
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            parser.parse(reader, element, parentNode, addOperations);
        }
    }

    private String resolveNodeName(XMLExtendedStreamReader reader, SimpleAttributeDefinition primaryAttribute, SimpleAttributeDefinition alternativeAttribute) {
        String name = reader.getAttributeValue("", primaryAttribute.getName());
        if (name == null) {
            name = reader.getAttributeValue("", alternativeAttribute.getName());
        }
        return name;
    }

    private static interface ElementParser {
        public void parse(XMLExtendedStreamReader var1, ModelElement var2, ModelNode var3, List<ModelNode> var4) throws XMLStreamException;
    }
}

