/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.config.federation.KeyValueType;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.federation.ProviderType;
import org.picketlink.config.federation.STSType;
import org.picketlink.config.federation.TokenProviderType;
import org.picketlink.config.federation.handler.Handler;
import org.picketlink.config.federation.handler.Handlers;
import org.picketlink.config.federation.parsers.STSConfigParser;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.web.handlers.saml2.RolesGenerationHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2AuthenticationHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2EncryptionHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2LogOutHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2SignatureValidationHandler;
import org.wildfly.extension.picketlink.federation.config.ProviderConfiguration;
import org.wildfly.extension.picketlink.federation.metrics.PicketLinkSubsystemMetrics;
import org.wildfly.extension.picketlink.federation.service.FederationService;
import org.wildfly.extension.picketlink.federation.service.PicketLinkFederationService;
import org.wildfly.extension.picketlink.logging.PicketLinkLogger;

public abstract class EntityProviderService<T extends PicketLinkFederationService<T>, C extends ProviderConfiguration>
implements PicketLinkFederationService<T> {
    private final InjectedValue<FederationService> federationService = new InjectedValue();
    private final PicketLinkType picketLinkType;
    private volatile PicketLinkSubsystemMetrics metrics;

    public EntityProviderService(C configuration) {
        this.picketLinkType = this.createPicketLinkType(configuration);
    }

    public void start(StartContext context) throws StartException {
        PicketLinkLogger.ROOT_LOGGER.debugf("Starting service for %s.", this.getConfiguration().getAlias());
    }

    public void stop(StopContext context) {
        PicketLinkLogger.ROOT_LOGGER.debugf("Stopping service for %s.", this.getConfiguration().getAlias());
    }

    @Override
    public void configure(DeploymentUnit deploymentUnit) {
        this.configureHandlers();
        this.configureWarMetadata(deploymentUnit);
        this.configureWebComponents(deploymentUnit);
        this.doConfigureDeployment(deploymentUnit);
        this.configureTokenProviders();
        this.configureKeyProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PicketLinkSubsystemMetrics getMetrics() {
        if (this.metrics == null) {
            EntityProviderService entityProviderService = this;
            synchronized (entityProviderService) {
                if (this.metrics == null) {
                    try {
                        this.metrics = new PicketLinkSubsystemMetrics(((ProviderConfiguration)this.getPicketLinkType().getIdpOrSP()).getSecurityDomain());
                    }
                    catch (ConfigurationException e) {
                        PicketLinkLogger.ROOT_LOGGER.federationErrorCollectingMetric(e);
                    }
                }
            }
        }
        return this.metrics;
    }

    protected List<Class<? extends SAML2Handler>> getDefaultHandlers() {
        ArrayList<Class<? extends SAML2Handler>> defaultHandlers = new ArrayList<Class<? extends SAML2Handler>>();
        defaultHandlers.add(SAML2LogOutHandler.class);
        defaultHandlers.add(SAML2AuthenticationHandler.class);
        defaultHandlers.add(RolesGenerationHandler.class);
        defaultHandlers.add(SAML2EncryptionHandler.class);
        defaultHandlers.add(SAML2SignatureValidationHandler.class);
        return defaultHandlers;
    }

    private void configureKeyProvider() {
        this.getConfiguration().setKeyProvider(((FederationService)this.getFederationService().getValue()).getKeyProviderType());
    }

    private void configureTokenProviders() {
        STSType stsType = ((FederationService)this.getFederationService().getValue()).getStsType();
        if (stsType != null) {
            int tokenTimeout = stsType.getTokenTimeout();
            int clockSkew = stsType.getClockSkew();
            STSType providerStsType = this.getPicketLinkType().getStsType();
            providerStsType.setTokenTimeout(Integer.valueOf(tokenTimeout));
            providerStsType.setClockSkew(Integer.valueOf(clockSkew));
            List tokenProviders = providerStsType.getTokenProviders().getTokenProvider();
            for (TokenProviderType tokenProviderType : tokenProviders) {
                if (!tokenProviderType.getTokenType().equals(JBossSAMLURIConstants.ASSERTION_NSURI.get())) continue;
                KeyValueType keyValueTypeTokenTimeout = new KeyValueType();
                keyValueTypeTokenTimeout.setKey("ASSERTIONS_VALIDITY");
                keyValueTypeTokenTimeout.setValue(String.valueOf(tokenTimeout));
                KeyValueType keyValueTypeClockSkew = new KeyValueType();
                keyValueTypeClockSkew.setKey("CLOCK_SKEW");
                keyValueTypeClockSkew.setValue(String.valueOf(clockSkew));
                tokenProviderType.add(keyValueTypeTokenTimeout);
                tokenProviderType.add(keyValueTypeClockSkew);
            }
        }
    }

    private void configureHandlers() {
        if (this.getPicketLinkType().getHandlers().getHandler().isEmpty()) {
            this.getPicketLinkType().setHandlers(new Handlers());
            for (Class<SAML2Handler> commonHandlerClass : this.getDefaultHandlers()) {
                this.addHandler(commonHandlerClass, this.getPicketLinkType().getHandlers());
            }
        }
    }

    protected void doAddHandlers() {
    }

    private void configureWarMetadata(DeploymentUnit deploymentUnit) {
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        warMetaData.getMergedJBossWebMetaData().setSecurityDomain(this.getConfiguration().getSecurityDomain());
    }

    protected abstract void configureWebComponents(DeploymentUnit var1);

    protected abstract void doConfigureDeployment(DeploymentUnit var1);

    public T getValue() throws IllegalStateException, IllegalArgumentException {
        return (T)this;
    }

    private PicketLinkType createPicketLinkType(C configuration) {
        PicketLinkType picketLinkType = new PicketLinkType();
        picketLinkType.setStsType(this.createSTSType());
        picketLinkType.setHandlers(new Handlers());
        picketLinkType.setEnableAudit(true);
        picketLinkType.setIdpOrSP((ProviderType)configuration);
        return picketLinkType;
    }

    void addHandler(Handler handler) {
        Handlers handlers = this.getPicketLinkType().getHandlers();
        for (Handler actualHandler : handlers.getHandler()) {
            if (!actualHandler.getClazz().equals(handler.getClazz())) continue;
            return;
        }
        handlers.add(handler);
    }

    void addHandler(Class<? extends SAML2Handler> handlerClassName, Handlers handlers) {
        for (Handler handler : handlers.getHandler()) {
            if (!handler.getClazz().equals(handlerClassName.getName())) continue;
            return;
        }
        Handler handler = new Handler();
        handler.setClazz(handlerClassName.getName());
        handlers.add(handler);
    }

    void removeHandler(Handler handler) {
        this.getPicketLinkType().getHandlers().remove(handler);
    }

    public C getConfiguration() {
        return (C)((ProviderConfiguration)this.getPicketLinkType().getIdpOrSP());
    }

    private STSType createSTSType() {
        STSType stsType = null;
        InputStream stream = null;
        try {
            URL url = this.getClass().getClassLoader().getResource("core-sts.xml");
            if (url == null) {
                url = Thread.currentThread().getContextClassLoader().getResource("core-sts");
            }
            if (url != null) {
                stream = url.openStream();
                stsType = (STSType)new STSConfigParser().parse(stream);
            }
        }
        catch (Exception e) {
            throw PicketLinkLogger.ROOT_LOGGER.federationCouldNotParseSTSConfig(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException ignored) {}
        }
        return stsType;
    }

    public InjectedValue<FederationService> getFederationService() {
        return this.federationService;
    }

    PicketLinkType getPicketLinkType() {
        return this.picketLinkType;
    }
}

