/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.service;

import org.jboss.as.controller.services.path.PathManager;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.picketlink.config.federation.AuthPropertyType;
import org.picketlink.config.federation.KeyProviderType;
import org.wildfly.extension.picketlink.federation.service.FederationService;

public class KeyStoreProviderService
implements Service<KeyStoreProviderService> {
    private static final String SERVICE_NAME = "KeyStoreProviderService";
    private final KeyProviderType keyProviderType;
    private final InjectedValue<FederationService> federationService = new InjectedValue();
    private final String relativeTo;
    private final String filePath;
    private final InjectedValue<PathManager> pathManager = new InjectedValue();

    public KeyStoreProviderService(KeyProviderType keyProviderType, String workingDir, String relativeTo) {
        this.keyProviderType = keyProviderType;
        this.filePath = workingDir;
        this.relativeTo = relativeTo;
    }

    public static ServiceName createServiceName(String alias) {
        return ServiceName.JBOSS.append(new String[]{"picketlink-federation", SERVICE_NAME, alias});
    }

    public KeyStoreProviderService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
        this.configureKeyStoreFilePath();
        ((FederationService)this.getFederationService().getValue()).setKeyProviderType(this.keyProviderType);
    }

    public void stop(StopContext context) {
        ((FederationService)this.getFederationService().getValue()).setKeyProviderType(null);
    }

    public InjectedValue<FederationService> getFederationService() {
        return this.federationService;
    }

    public InjectedValue<PathManager> getPathManager() {
        return this.pathManager;
    }

    private void configureKeyStoreFilePath() {
        String resolvedPath = this.relativeTo != null ? ((PathManager)this.getPathManager().getValue()).resolveRelativePathEntry(this.filePath, this.relativeTo) : this.filePath;
        AuthPropertyType keyStoreURL = new AuthPropertyType();
        keyStoreURL.setKey("KeyStoreURL");
        keyStoreURL.setValue(resolvedPath);
        this.keyProviderType.add(keyStoreURL);
    }
}

