/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl;

import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.cl.internal.OptionInt;
import org.jboss.aesh.cl.internal.ParameterInt;

public class ParameterBuilder {
    private String name;
    private String usage;
    private Class<?> argumentType = String.class;
    private List<OptionInt> options = new ArrayList<OptionInt>();

    public ParameterBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ParameterBuilder usage(String usage) {
        this.usage = usage;
        return this;
    }

    public ParameterBuilder argumentType(Class<?> type) {
        this.argumentType = type;
        return this;
    }

    public ParameterBuilder addOption(OptionInt option) {
        this.options.add(option);
        return this;
    }

    public ParameterBuilder addOptions(List<OptionInt> options) {
        this.options.addAll(options);
        return this;
    }

    public ParameterInt generateParameter() throws IllegalArgumentException {
        if (this.name == null || this.name.length() < 1) {
            throw new RuntimeException("The parameter name must be defined");
        }
        return new ParameterInt(this.name, this.usage, this.argumentType, this.options);
    }
}

