/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jboss.as.clustering.controller.OperationFactory;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.dmr.ModelNode;

public class ChainedOperationTransformer
implements OperationTransformer {
    private final List<OperationTransformer> transformers;

    public ChainedOperationTransformer(List<OperationTransformer> transformers) {
        this.transformers = transformers;
    }

    public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode originalOperation) throws OperationFailedException {
        String originalName = originalOperation.get("operation").asString();
        ModelNode originalAddress = originalOperation.get("address");
        LinkedList<ModelNode> preSteps = new LinkedList<ModelNode>();
        LinkedList<ModelNode> postSteps = new LinkedList<ModelNode>();
        ModelNode operation = originalOperation;
        block0: for (OperationTransformer transformer : this.transformers) {
            ModelNode operationAddress;
            String operationName;
            ModelNode step;
            operation = transformer.transformOperation(context, address, operation).getTransformedOperation();
            if (!operation.get("operation").asString().equals("composite")) continue;
            List stepList = operation.get("steps").asList();
            ListIterator steps = stepList.listIterator();
            while (steps.hasNext()) {
                step = (ModelNode)steps.next();
                operationName = step.get("operation").asString();
                operationAddress = step.get("address");
                if (operationName.equals(originalName) && operationAddress.equals(originalAddress)) {
                    operation = step;
                    break;
                }
                preSteps.addLast(step);
            }
            steps = stepList.listIterator(stepList.size());
            while (steps.hasPrevious()) {
                step = (ModelNode)steps.previous();
                operationName = step.get("operation").asString();
                operationAddress = step.get("address");
                if (operationName.equals(originalName) && operationAddress.equals(originalAddress)) continue block0;
                postSteps.addFirst(step);
            }
        }
        int count = preSteps.size() + postSteps.size() + 1;
        if (count > 1) {
            ArrayList<ModelNode> steps = new ArrayList<ModelNode>(count);
            steps.addAll(preSteps);
            steps.add(operation);
            steps.addAll(postSteps);
            operation = OperationFactory.createCompositeOperation(steps);
        }
        return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
    }
}

