/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public final class OperationFactory {
    public static ModelNode createCompositeOperation(List<ModelNode> operations) {
        ModelNode operation = Util.createEmptyOperation((String)"composite", (PathAddress)PathAddress.EMPTY_ADDRESS);
        ModelNode steps = operation.get("steps");
        for (ModelNode step : operations) {
            steps.add(step);
        }
        return operation;
    }

    public static ModelNode createCompositeOperation(ModelNode ... operations) {
        return OperationFactory.createCompositeOperation(Arrays.asList(operations));
    }

    public static ModelNode createReadAttributeOperation(PathAddress address, String name) {
        ModelNode operation = Util.createEmptyOperation((String)"read-attribute", (PathAddress)address);
        operation.get("name").set(name);
        return operation;
    }

    public static ModelNode createWriteAttributeOperation(PathAddress address, String name, ModelNode value) {
        ModelNode operation = Util.createEmptyOperation((String)"write-attribute", (PathAddress)address);
        operation.get("name").set(name);
        operation.get("value").set(value);
        return operation;
    }

    public static ModelNode createUndefineAttributeOperation(PathAddress address, String name) {
        ModelNode operation = Util.createEmptyOperation((String)"undefine-attribute", (PathAddress)address);
        operation.get("name").set(name);
        return operation;
    }

    private OperationFactory() {
    }
}

