/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.mail.extension.MailExtension;
import org.jboss.as.mail.extension.MailServerAdd;
import org.jboss.as.mail.extension.MailServerWriteAttributeHandler;
import org.jboss.as.mail.extension.MailSessionAdd;
import org.jboss.as.mail.extension.MailSubsystemModel;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;

class MailServerDefinition
extends PersistentResourceDefinition {
    static final SensitivityClassification MAIL_SERVER_SECURITY = new SensitivityClassification("mail", "mail-server-security", false, false, true);
    static final SensitiveTargetAccessConstraintDefinition MAIL_SERVER_SECURITY_DEF = new SensitiveTargetAccessConstraintDefinition(MAIL_SERVER_SECURITY);
    protected static final SimpleAttributeDefinition OUTBOUND_SOCKET_BINDING_REF = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("outbound-socket-binding-ref", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).build();
    protected static final SimpleAttributeDefinition OUTBOUND_SOCKET_BINDING_REF_OPTIONAL = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)OUTBOUND_SOCKET_BINDING_REF).setAllowNull(true)).build();
    protected static final SimpleAttributeDefinition SSL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ssl", ModelType.BOOLEAN, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(false))).addAccessConstraint((AccessConstraintDefinition)MAIL_SERVER_SECURITY_DEF)).build();
    protected static final SimpleAttributeDefinition TLS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("tls", ModelType.BOOLEAN, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(false))).addAccessConstraint((AccessConstraintDefinition)MAIL_SERVER_SECURITY_DEF)).build();
    protected static final SimpleAttributeDefinition USERNAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("username", ModelType.STRING, true).setAllowExpression(true)).setXmlName("username")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MAIL_SERVER_SECURITY_DEF)).build();
    protected static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MAIL_SERVER_SECURITY_DEF)).build();
    protected static final PropertiesAttributeDefinition PROPERTIES = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("properties", true).setXmlName("property")).setWrapXmlElement(false).setAllowExpression(true)).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{OUTBOUND_SOCKET_BINDING_REF, SSL, TLS, USERNAME, PASSWORD};
    static final AttributeDefinition[] ATTRIBUTES_CUSTOM = new AttributeDefinition[]{OUTBOUND_SOCKET_BINDING_REF_OPTIONAL, SSL, TLS, USERNAME, PASSWORD, PROPERTIES};
    public static final MailServerDefinition INSTANCE_SMTP = new MailServerDefinition(MailSubsystemModel.SMTP_SERVER_PATH, ATTRIBUTES);
    public static final MailServerDefinition INSTANCE_IMAP = new MailServerDefinition(MailSubsystemModel.IMAP_SERVER_PATH, ATTRIBUTES);
    public static final MailServerDefinition INSTANCE_POP3 = new MailServerDefinition(MailSubsystemModel.POP3_SERVER_PATH, ATTRIBUTES);
    public static final MailServerDefinition INSTANCE_CUSTOM = new MailServerDefinition(MailSubsystemModel.CUSTOM_SERVER_PATH, ATTRIBUTES_CUSTOM);
    private final List<AttributeDefinition> attributes;

    private MailServerDefinition(PathElement path, AttributeDefinition[] attributes) {
        super(path, (ResourceDescriptionResolver)MailExtension.getResourceDescriptionResolver("mail-session", "server"), (OperationStepHandler)new MailServerAdd(attributes), (OperationStepHandler)new MailServerRemove());
        this.attributes = Arrays.asList(attributes);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        MailServerWriteAttributeHandler handler = new MailServerWriteAttributeHandler(this.getAttributes());
        for (AttributeDefinition attr : this.getAttributes()) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)handler);
        }
    }

    private static final class MailServerRemove
    extends RestartParentResourceRemoveHandler {
        private MailServerRemove() {
            super("mail-session");
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
            MailSessionAdd.installRuntimeServices(context, parentAddress, parentModel, verificationHandler, new ArrayList());
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return MailSessionAdd.MAIL_SESSION_SERVICE_NAME.append(new String[]{parentAddress.getLastElement().getValue()});
        }

        protected void removeServices(OperationContext context, ServiceName parentService, ModelNode parentModel) throws OperationFailedException {
            super.removeServices(context, parentService, parentModel);
            String jndiName = MailSessionAdd.getJndiName(parentModel, context);
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
            context.removeService(bindInfo.getBinderServiceName());
        }
    }
}

