/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import org.jboss.as.mail.extension.Credentials;
import org.jboss.as.mail.extension.CustomServerConfig;
import org.jboss.as.mail.extension.MailLogger;
import org.jboss.as.mail.extension.MailSessionConfig;
import org.jboss.as.mail.extension.ServerConfig;
import org.jboss.as.mail.extension.SessionProvider;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.metadata.javaee.spec.MailSessionMetaData;
import org.jboss.metadata.javaee.spec.PropertyMetaData;
import org.jboss.msc.service.StartException;

class SessionProviderFactory {
    SessionProviderFactory() {
    }

    static SessionProvider create(MailSessionConfig config, Map<String, OutboundSocketBinding> socketBindings) throws StartException {
        return new ManagedSession(config, socketBindings);
    }

    static SessionProvider create(MailSessionMetaData mailSessionMetaData) {
        return new DirectSessionProvider(mailSessionMetaData);
    }

    private static String getHostKey(String protocol) {
        return "mail." + protocol + ".host";
    }

    private static String getPortKey(String protocol) {
        return "mail." + protocol + ".port";
    }

    private static String getPropKey(String protocol, String name) {
        return "mail." + protocol + "." + name;
    }

    private static class DirectSessionProvider
    implements SessionProvider {
        private final MailSessionMetaData metaData;
        private final Properties properties = new Properties();
        private PasswordAuthentication authenticator = null;

        private DirectSessionProvider(MailSessionMetaData metaData) {
            this.metaData = metaData;
            this.configure();
        }

        private void configure() {
            String protocol = this.metaData.getTransportProtocol();
            if (protocol == null) {
                protocol = this.metaData.getStoreProtocol();
            }
            if (protocol == null) {
                protocol = "smtp";
            }
            this.properties.put(SessionProviderFactory.getHostKey(protocol), this.metaData.getHost());
            if (this.metaData.getFrom() != null) {
                this.properties.put(SessionProviderFactory.getPropKey(protocol, "from"), this.metaData.getFrom());
            }
            if (this.metaData.getProperties() != null) {
                for (PropertyMetaData prop : this.metaData.getProperties()) {
                    this.properties.put(prop.getKey(), prop.getValue());
                }
            }
            if (this.metaData.getUser() != null) {
                this.authenticator = new PasswordAuthentication(this.metaData.getUser(), this.metaData.getPassword());
            }
        }

        @Override
        public Session getSession() {
            return Session.getInstance((Properties)this.properties, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return DirectSessionProvider.this.authenticator;
                }
            });
        }
    }

    protected static class ManagedPasswordAuthenticator
    extends Authenticator {
        private MailSessionConfig config;

        public ManagedPasswordAuthenticator(MailSessionConfig sessionConfig) {
            this.config = sessionConfig;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            String protocol = this.getRequestingProtocol();
            Credentials c = null;
            if ("smtp".equals(protocol) && this.config.getSmtpServer() != null) {
                c = this.config.getSmtpServer().getCredentials();
            } else if ("pop3".equals(protocol) && this.config.getPop3Server() != null) {
                c = this.config.getPop3Server().getCredentials();
            } else if ("imap".equals(protocol) && this.config.getImapServer() != null) {
                c = this.config.getImapServer().getCredentials();
            }
            if (c == null) {
                for (CustomServerConfig ssc : this.config.getCustomServers()) {
                    if (!ssc.getProtocol().equals(protocol)) continue;
                    c = ssc.getCredentials();
                    break;
                }
            }
            if (c != null) {
                return new PasswordAuthentication(c.getUsername(), c.getPassword());
            }
            return null;
        }
    }

    private static class ManagedSession
    implements SessionProvider {
        private final Map<String, OutboundSocketBinding> socketBindings;
        private final MailSessionConfig sessionConfig;
        private final Properties properties = new Properties();

        private ManagedSession(MailSessionConfig sessionConfig, Map<String, OutboundSocketBinding> socketBindings) throws StartException {
            this.socketBindings = socketBindings;
            this.sessionConfig = sessionConfig;
            this.configure();
        }

        private void configure() throws StartException {
            if (this.sessionConfig.getSmtpServer() != null) {
                this.properties.setProperty("mail.transport.protocol", "smtp");
                this.setServerProps(this.properties, this.sessionConfig.getSmtpServer(), "smtp");
            }
            if (this.sessionConfig.getImapServer() != null) {
                this.properties.setProperty("mail.store.protocol", "imap");
                this.setServerProps(this.properties, this.sessionConfig.getImapServer(), "imap");
            }
            if (this.sessionConfig.getPop3Server() != null) {
                this.setServerProps(this.properties, this.sessionConfig.getPop3Server(), "pop3");
            }
            if (this.sessionConfig.getCustomServers() != null) {
                this.configureCustomServers(this.properties, this.sessionConfig.getCustomServers());
            }
            if (this.sessionConfig.getFrom() != null) {
                this.properties.setProperty("mail.from", this.sessionConfig.getFrom());
            }
            this.properties.setProperty("mail.debug", String.valueOf(this.sessionConfig.isDebug()));
            MailLogger.ROOT_LOGGER.tracef("props: %s", this.properties);
        }

        private void configureCustomServers(Properties props, CustomServerConfig ... serverConfigs) throws StartException {
            for (CustomServerConfig serverConfig : serverConfigs) {
                this.setServerProps(props, serverConfig, serverConfig.getProtocol());
            }
        }

        private void setServerProps(Properties props, ServerConfig server, String protocol) throws StartException {
            if (server.isSslEnabled()) {
                props.setProperty(SessionProviderFactory.getPropKey(protocol, "ssl.enable"), "true");
            } else if (server.isTlsEnabled()) {
                props.setProperty(SessionProviderFactory.getPropKey(protocol, "starttls.enable"), "true");
            }
            if (server.getCredentials() != null) {
                props.setProperty(SessionProviderFactory.getPropKey(protocol, "auth"), "true");
                props.setProperty(SessionProviderFactory.getPropKey(protocol, "user"), server.getCredentials().getUsername());
            }
            props.setProperty(SessionProviderFactory.getPropKey(protocol, "debug"), String.valueOf(this.sessionConfig.isDebug()));
            Map<String, String> customProps = server.getProperties();
            if (server.getOutgoingSocketBinding() != null) {
                InetSocketAddress socketAddress = this.getServerSocketAddress(server);
                if (socketAddress.getAddress() == null) {
                    MailLogger.ROOT_LOGGER.hostUnknown(socketAddress.getHostName());
                    props.setProperty(SessionProviderFactory.getHostKey(protocol), NetworkUtils.canonize((String)socketAddress.getHostName()));
                } else {
                    props.setProperty(SessionProviderFactory.getHostKey(protocol), NetworkUtils.canonize((String)socketAddress.getAddress().getHostName()));
                }
                props.setProperty(SessionProviderFactory.getPortKey(protocol), String.valueOf(socketAddress.getPort()));
            } else {
                String port;
                String host = customProps.get("host");
                if (host != null && !"".equals(host.trim())) {
                    props.setProperty(SessionProviderFactory.getHostKey(protocol), host);
                }
                if ((port = customProps.get("port")) != null && !"".equals(port.trim())) {
                    props.setProperty(SessionProviderFactory.getPortKey(protocol), port);
                }
            }
            if (customProps != null && !customProps.isEmpty()) {
                for (Map.Entry<String, String> prop : customProps.entrySet()) {
                    if (props.contains(prop.getKey())) continue;
                    if (prop.getKey().contains(".")) {
                        props.put(prop.getKey(), prop.getValue());
                        continue;
                    }
                    props.put(SessionProviderFactory.getPropKey(protocol, prop.getKey()), prop.getValue());
                }
            }
        }

        private InetSocketAddress getServerSocketAddress(ServerConfig server) throws StartException {
            String ref = server.getOutgoingSocketBinding();
            OutboundSocketBinding binding = this.socketBindings.get(ref);
            if (binding == null) {
                throw MailLogger.ROOT_LOGGER.outboundSocketBindingNotAvailable(ref);
            }
            return new InetSocketAddress(binding.getUnresolvedDestinationAddress(), binding.getDestinationPort());
        }

        @Override
        public Session getSession() {
            Session session = Session.getInstance((Properties)this.properties, (Authenticator)new ManagedPasswordAuthenticator(this.sessionConfig));
            return session;
        }
    }
}

