/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.infinispan.subsystem.AbstractCacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

public class SessionCacheConfigurationService
extends AbstractCacheConfigurationService {
    private final InjectedValue<EmbeddedCacheManager> container = new InjectedValue();
    private final InjectedValue<Configuration> configuration = new InjectedValue();

    public static ServiceBuilder<Configuration> build(ServiceTarget target, String containerName, String cacheName, String templateCacheName) {
        SessionCacheConfigurationService service = new SessionCacheConfigurationService(cacheName);
        return target.addService(CacheConfigurationService.getServiceName((String)containerName, (String)cacheName), (Service)service).addDependency(EmbeddedCacheManagerService.getServiceName((String)containerName), EmbeddedCacheManager.class, service.container).addDependency(CacheConfigurationService.getServiceName((String)containerName, (String)templateCacheName), Configuration.class, service.configuration);
    }

    private SessionCacheConfigurationService(String name) {
        super(name);
    }

    protected ConfigurationBuilder getConfigurationBuilder() {
        Configuration config = (Configuration)this.configuration.getValue();
        ConfigurationBuilder builder = new ConfigurationBuilder().read(config);
        builder.storeAsBinary().disable().storeKeysAsBinary(false).storeValuesAsBinary(false);
        builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        return builder;
    }

    protected EmbeddedCacheManager getCacheContainer() {
        return (EmbeddedCacheManager)this.container.getValue();
    }
}

