/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.fine;

import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.web.infinispan.session.MutableDetector;
import org.wildfly.clustering.web.infinispan.session.SessionAttributeMarshaller;
import org.wildfly.clustering.web.infinispan.session.fine.FineImmutableSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeCacheKey;
import org.wildfly.clustering.web.session.SessionAttributes;

public class FineSessionAttributes<V>
extends FineImmutableSessionAttributes<V>
implements SessionAttributes {
    private final Set<String> attributes;
    private final Cache<SessionAttributeCacheKey, V> cache;
    private final SessionAttributeMarshaller<Object, V> marshaller;

    public FineSessionAttributes(String id, Set<String> attributes, Cache<SessionAttributeCacheKey, V> attributeCache, SessionAttributeMarshaller<Object, V> marshaller) {
        super(id, attributes, attributeCache, marshaller);
        this.attributes = attributes;
        this.cache = attributeCache;
        this.marshaller = marshaller;
    }

    public Object removeAttribute(String name) {
        return this.attributes.remove(name) ? this.marshaller.read(this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).remove((Object)this.createKey(name))) : null;
    }

    public Object setAttribute(String name, Object attribute) {
        if (attribute == null) {
            return this.removeAttribute(name);
        }
        SessionAttributeCacheKey key = this.createKey(name);
        V value = this.marshaller.write(attribute);
        return this.marshaller.read(this.cache.getAdvancedCache().withFlags(new Flag[]{this.attributes.add(name) ? Flag.IGNORE_RETURN_VALUES : Flag.FORCE_SYNCHRONOUS}).put((Object)key, value));
    }

    @Override
    public Object getAttribute(String name) {
        SessionAttributeCacheKey key = this.createKey(name);
        Object value = this.getAttributeValue(key);
        if (value == null) {
            return null;
        }
        Object attribute = this.marshaller.read(value);
        if (MutableDetector.isMutable(attribute)) {
            new CacheEntryMutator(this.cache, (Object)key, value).mutate();
        }
        return attribute;
    }
}

