/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.fine;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.transaction.LockingMode;
import org.jboss.as.clustering.marshalling.MarshalledValue;
import org.jboss.as.clustering.marshalling.MarshallingContext;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.Mutator;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.InfinispanImmutableSession;
import org.wildfly.clustering.web.infinispan.session.InfinispanSession;
import org.wildfly.clustering.web.infinispan.session.SessionAttributeMarshaller;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionMetaData;
import org.wildfly.clustering.web.infinispan.session.fine.FineImmutableSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionCacheEntry;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeCacheKey;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionContext;
import org.wildfly.clustering.web.session.SessionMetaData;

public class FineSessionFactory<L>
implements SessionFactory<FineSessionCacheEntry<L>, L> {
    private final Cache<String, FineSessionCacheEntry<L>> sessionCache;
    private final Cache<SessionAttributeCacheKey, MarshalledValue<Object, MarshallingContext>> attributeCache;
    private final SessionContext context;
    private final SessionAttributeMarshaller<Object, MarshalledValue<Object, MarshallingContext>> marshaller;
    private final LocalContextFactory<L> localContextFactory;

    public FineSessionFactory(Cache<String, FineSessionCacheEntry<L>> sessionCache, Cache<SessionAttributeCacheKey, MarshalledValue<Object, MarshallingContext>> attributeCache, SessionContext context, SessionAttributeMarshaller<Object, MarshalledValue<Object, MarshallingContext>> marshaller, LocalContextFactory<L> localContextFactory) {
        this.sessionCache = sessionCache;
        this.attributeCache = attributeCache;
        this.context = context;
        this.marshaller = marshaller;
        this.localContextFactory = localContextFactory;
    }

    @Override
    public Session<L> createSession(String id, FineSessionCacheEntry<L> entry) {
        SessionMetaData metaData = entry.getMetaData();
        Mutator mutator = metaData.isNew() ? Mutator.PASSIVE : new CacheEntryMutator(this.sessionCache, (Object)id, entry);
        FineSessionAttributes<MarshalledValue<Object, MarshallingContext>> attributes = new FineSessionAttributes<MarshalledValue<Object, MarshallingContext>>(id, entry.getAttributes(), this.attributeCache, this.marshaller);
        return new InfinispanSession<L>(id, entry.getMetaData(), attributes, entry.getLocalContext(), this.localContextFactory, this.context, mutator, this);
    }

    @Override
    public ImmutableSession createImmutableSession(String id, FineSessionCacheEntry<L> entry) {
        FineImmutableSessionAttributes<MarshalledValue<Object, MarshallingContext>> attributes = new FineImmutableSessionAttributes<MarshalledValue<Object, MarshallingContext>>(id, entry.getAttributes(), this.attributeCache, this.marshaller);
        return new InfinispanImmutableSession(id, (ImmutableSessionMetaData)entry.getMetaData(), attributes, this.context);
    }

    public FineSessionCacheEntry<L> findValue(String id) {
        TransactionConfiguration transaction = this.sessionCache.getCacheConfiguration().transaction();
        boolean pessimistic = transaction.transactionMode().isTransactional() && transaction.lockingMode() == LockingMode.PESSIMISTIC;
        AdvancedCache cache = pessimistic ? this.sessionCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}) : this.sessionCache;
        return (FineSessionCacheEntry)cache.get((Object)id);
    }

    public FineSessionCacheEntry<L> createValue(String id) {
        FineSessionCacheEntry entry = new FineSessionCacheEntry(new SimpleSessionMetaData());
        FineSessionCacheEntry existing = (FineSessionCacheEntry)this.sessionCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent((Object)id, entry);
        return existing != null ? existing : entry;
    }

    public void remove(String id) {
        FineSessionCacheEntry entry = (FineSessionCacheEntry)this.sessionCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).remove((Object)id);
        AdvancedCache cache = this.attributeCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES});
        for (String attribute : entry.getAttributes()) {
            cache.remove((Object)new SessionAttributeCacheKey(id, attribute));
        }
    }

    public void evict(String id) {
        FineSessionCacheEntry<L> entry = this.findValue(id);
        if (entry != null) {
            for (String attribute : entry.getAttributes()) {
                try {
                    this.attributeCache.evict((Object)new SessionAttributeCacheKey(id, attribute));
                }
                catch (Throwable e) {
                    InfinispanWebLogger.ROOT_LOGGER.failedToPassivateSessionAttribute(e, id, attribute);
                }
            }
            try {
                this.sessionCache.evict((Object)id);
            }
            catch (Throwable e) {
                InfinispanWebLogger.ROOT_LOGGER.failedToPassivateSession(e, id);
            }
        }
    }
}

