/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso;

import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.infinispan.sso.Authenticator;
import org.wildfly.clustering.web.infinispan.sso.SSOFactory;
import org.wildfly.clustering.web.sso.SSO;
import org.wildfly.clustering.web.sso.SSOManager;

public class InfinispanSSOManager<V extends Authenticator<A>, A, D, L>
implements SSOManager<A, D, L, TransactionBatch> {
    private final SSOFactory<V, A, D, L> factory;
    private final Batcher<TransactionBatch> batcher;
    private final IdentifierFactory<String> identifierFactory;

    public InfinispanSSOManager(SSOFactory<V, A, D, L> factory, IdentifierFactory<String> identifierFactory, Batcher<TransactionBatch> batcher) {
        this.factory = factory;
        this.batcher = batcher;
        this.identifierFactory = identifierFactory;
    }

    public SSO<A, D, L> createSSO(String ssoId, A authentication) {
        Authenticator value = (Authenticator)this.factory.createValue(ssoId);
        value.setAuthentication(authentication);
        return this.factory.createSSO(ssoId, value);
    }

    public SSO<A, D, L> findSSO(String ssoId) {
        Authenticator value = (Authenticator)this.factory.findValue(ssoId);
        return value != null ? this.factory.createSSO(ssoId, value) : null;
    }

    public Batcher<TransactionBatch> getBatcher() {
        return this.batcher;
    }

    public String createIdentifier() {
        return (String)this.identifierFactory.createIdentifier();
    }

    public void start() {
        this.identifierFactory.start();
    }

    public void stop() {
        this.identifierFactory.stop();
    }
}

