/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso.coarse;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.Mutator;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSO;
import org.wildfly.clustering.web.infinispan.sso.SSOFactory;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseAuthenticationEntry;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSSOEntry;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSessions;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSessionsKey;
import org.wildfly.clustering.web.sso.SSO;

public class CoarseSSOFactory<I, D, L>
implements SSOFactory<CoarseSSOEntry<I, D, L>, I, D, L> {
    private final Cache<String, CoarseAuthenticationEntry<I, D, L>> authenticationCache;
    private final Cache<CoarseSessionsKey, Map<D, String>> sessionsCache;
    private final LocalContextFactory<L> localContextFactory;

    public CoarseSSOFactory(Cache<String, CoarseAuthenticationEntry<I, D, L>> authenticationCache, Cache<CoarseSessionsKey, Map<D, String>> sessionsCache, LocalContextFactory<L> localContextFactory) {
        this.authenticationCache = authenticationCache;
        this.sessionsCache = sessionsCache;
        this.localContextFactory = localContextFactory;
    }

    @Override
    public SSO<I, D, L> createSSO(String id, CoarseSSOEntry<I, D, L> entry) {
        CoarseAuthenticationEntry<I, D, L> authenticationEntry = entry.getAuthenticationEntry();
        CoarseSessionsKey sessionsKey = new CoarseSessionsKey(id);
        Map<D, String> sessionsValue = entry.getSessions();
        CacheEntryMutator sessionsMutator = new CacheEntryMutator(this.sessionsCache, (Object)sessionsKey, sessionsValue);
        CoarseSessions<D> sessions = new CoarseSessions<D>(sessionsValue, (Mutator)sessionsMutator);
        return new InfinispanSSO<I, D, L>(id, authenticationEntry.getAuthentication(), sessions, authenticationEntry.getLocalContext(), this.localContextFactory, this);
    }

    public CoarseSSOEntry<I, D, L> createValue(String id) {
        CoarseAuthenticationEntry entry = new CoarseAuthenticationEntry();
        CoarseAuthenticationEntry existingEntry = (CoarseAuthenticationEntry)this.authenticationCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent((Object)id, entry);
        if (existingEntry != null) {
            Map value = (Map)this.sessionsCache.get((Object)new CoarseSessionsKey(id));
            return new CoarseSSOEntry(existingEntry, value);
        }
        HashMap map = new HashMap();
        HashMap existingMap = (HashMap)this.sessionsCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent((Object)new CoarseSessionsKey(id), map);
        return new CoarseSSOEntry(entry, existingMap != null ? existingMap : map);
    }

    public CoarseSSOEntry<I, D, L> findValue(String id) {
        CoarseAuthenticationEntry entry = (CoarseAuthenticationEntry)this.authenticationCache.get((Object)id);
        if (entry == null) {
            return null;
        }
        Map map = (Map)this.sessionsCache.get((Object)new CoarseSessionsKey(id));
        return new CoarseSSOEntry(entry, map);
    }

    public void remove(String id) {
        this.authenticationCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)id);
        this.sessionsCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)new CoarseSessionsKey(id));
    }
}

