/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.jboss.as.core.security.ServerSecurityManager;
import org.jboss.as.ee.component.BasicComponentCreateService;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBUtilities;
import org.jboss.as.ejb3.component.EJBViewConfiguration;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.EjbHomeViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.MethodTransactionAttributeKey;
import org.jboss.as.ejb3.deployment.ApplicationExceptions;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.as.ejb3.security.EJBSecurityMetaData;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.Interceptors;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.requestcontroller.ControlPoint;

public class EJBComponentCreateService
extends BasicComponentCreateService {
    private final Map<MethodTransactionAttributeKey, TransactionAttributeType> txAttrs;
    private final Map<MethodTransactionAttributeKey, Integer> txTimeouts;
    private final TransactionManagementType transactionManagementType;
    private final ApplicationExceptions applicationExceptions;
    private final Map<String, ServiceName> viewServices;
    private final EJBSecurityMetaData securityMetaData;
    private final TimerService timerService;
    private final Map<Method, InterceptorFactory> timeoutInterceptors;
    private final Method timeoutMethod;
    private final ServiceName ejbLocalHome;
    private final ServiceName ejbHome;
    private final ServiceName ejbObject;
    private final ServiceName ejbLocalObject;
    private final String applicationName;
    private final String earApplicationName;
    private final String moduleName;
    private final String distinctName;
    private final String policyContextID;
    private final InjectedValue<EJBRemoteTransactionsRepository> ejbRemoteTransactionsRepository = new InjectedValue();
    private final InjectedValue<TransactionManager> transactionManagerInjectedValue = new InjectedValue();
    private final InjectedValue<UserTransaction> userTransactionInjectedValue = new InjectedValue();
    private final InjectedValue<TransactionSynchronizationRegistry> transactionSynchronizationRegistryValue = new InjectedValue();
    private final InjectedValue<ServerSecurityManager> serverSecurityManagerInjectedValue = new InjectedValue();
    private final InjectedValue<ControlPoint> controlPoint = new InjectedValue();

    public EJBComponentCreateService(ComponentConfiguration componentConfiguration, ApplicationExceptions applicationExceptions) {
        super(componentConfiguration);
        this.applicationExceptions = applicationExceptions;
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
        this.transactionManagementType = ejbComponentDescription.getTransactionManagementType();
        this.timerService = ejbComponentDescription.getTimerService();
        this.policyContextID = ejbComponentDescription.getPolicyContextID();
        if (this.transactionManagementType.equals((Object)TransactionManagementType.CONTAINER)) {
            this.txAttrs = new HashMap<MethodTransactionAttributeKey, TransactionAttributeType>();
            this.txTimeouts = new HashMap<MethodTransactionAttributeKey, Integer>();
        } else {
            this.txAttrs = null;
            this.txTimeouts = null;
        }
        this.securityMetaData = new EJBSecurityMetaData(componentConfiguration);
        if (ejbComponentDescription.isTimerServiceRequired()) {
            IdentityHashMap<Method, InterceptorFactory> timeoutInterceptors = new IdentityHashMap<Method, InterceptorFactory>();
            for (Method method : componentConfiguration.getDefinedComponentMethods()) {
                if ((ejbComponentDescription.getTimeoutMethod() == null || !ejbComponentDescription.getTimeoutMethod().equals(method)) && !ejbComponentDescription.getScheduleMethods().containsKey(method)) continue;
                InterceptorFactory interceptorFactory = Interceptors.getChainedInterceptorFactory((Collection)componentConfiguration.getAroundTimeoutInterceptors(method));
                timeoutInterceptors.put(method, interceptorFactory);
            }
            this.timeoutInterceptors = timeoutInterceptors;
        } else {
            this.timeoutInterceptors = Collections.emptyMap();
        }
        List views = componentConfiguration.getViews();
        if (views != null) {
            for (ViewConfiguration view : views) {
                EJBViewConfiguration ejbView = (EJBViewConfiguration)view;
                MethodIntf viewType = ejbView.getMethodIntf();
                for (Method method : view.getProxyFactory().getCachedMethods()) {
                    if (!Modifier.isPublic(method.getModifiers())) continue;
                    Method componentMethod = EJBComponentCreateService.getComponentMethod(componentConfiguration, method.getName(), method.getParameterTypes());
                    if (componentMethod != null) {
                        this.processTxAttr(ejbComponentDescription, viewType, componentMethod);
                        continue;
                    }
                    this.processTxAttr(ejbComponentDescription, viewType, method);
                }
            }
        }
        this.timeoutMethod = ejbComponentDescription.getTimeoutMethod();
        for (Method method : componentConfiguration.getComponentClass().getMethods()) {
            this.processTxAttr(ejbComponentDescription, MethodIntf.BEAN, method);
        }
        HashMap<String, ServiceName> viewServices = new HashMap<String, ServiceName>();
        for (ViewDescription view : componentConfiguration.getComponentDescription().getViews()) {
            viewServices.put(view.getViewClassName(), view.getServiceName());
        }
        this.viewServices = viewServices;
        EjbHomeViewDescription localHome = ejbComponentDescription.getEjbLocalHomeView();
        this.ejbLocalHome = localHome == null ? null : ejbComponentDescription.getEjbLocalHomeView().getServiceName();
        EjbHomeViewDescription home = ejbComponentDescription.getEjbHomeView();
        this.ejbHome = home == null ? null : home.getServiceName();
        EJBViewDescription ejbObject = ejbComponentDescription.getEjbRemoteView();
        this.ejbObject = ejbObject == null ? null : ejbObject.getServiceName();
        EJBViewDescription ejbLocalObject = ejbComponentDescription.getEjbLocalView();
        this.ejbLocalObject = ejbLocalObject == null ? null : ejbLocalObject.getServiceName();
        this.applicationName = componentConfiguration.getApplicationName();
        this.earApplicationName = componentConfiguration.getComponentDescription().getModuleDescription().getEarApplicationName();
        this.moduleName = componentConfiguration.getModuleName();
        this.distinctName = componentConfiguration.getComponentDescription().getModuleDescription().getDistinctName();
    }

    protected boolean requiresInterceptors(Method method, ComponentConfiguration componentConfiguration) {
        if (super.requiresInterceptors(method, componentConfiguration)) {
            return true;
        }
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
        return ejbComponentDescription.getTimeoutMethod() != null && ejbComponentDescription.getTimeoutMethod().equals(method) || ejbComponentDescription.getScheduleMethods().containsKey(method);
    }

    private static Method getComponentMethod(ComponentConfiguration componentConfiguration, String name, Class<?>[] parameterTypes) {
        try {
            return componentConfiguration.getComponentClass().getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Deprecated
    protected EJBUtilities getEJBUtilities() {
        DeploymentUnit deploymentUnit = (DeploymentUnit)this.getDeploymentUnitInjector().getValue();
        ServiceController serviceController = deploymentUnit.getServiceRegistry().getRequiredService(EJBUtilities.SERVICE_NAME);
        return (EJBUtilities)serviceController.getValue();
    }

    Map<MethodTransactionAttributeKey, TransactionAttributeType> getTxAttrs() {
        return this.txAttrs;
    }

    Map<MethodTransactionAttributeKey, Integer> getTxTimeouts() {
        return this.txTimeouts;
    }

    TransactionManagementType getTransactionManagementType() {
        return this.transactionManagementType;
    }

    ApplicationExceptions getApplicationExceptions() {
        return this.applicationExceptions;
    }

    protected void processTxAttr(EJBComponentDescription ejbComponentDescription, MethodIntf methodIntf, Method method) {
        if (this.getTransactionManagementType().equals((Object)TransactionManagementType.BEAN)) {
            return;
        }
        TransactionAttributeType txAttr = ejbComponentDescription.getTransactionAttributes().getAttribute(methodIntf, method);
        this.txAttrs.put(new MethodTransactionAttributeKey(methodIntf, MethodIdentifier.getIdentifierForMethod((Method)method)), txAttr);
        Integer txTimeout = ejbComponentDescription.getTransactionTimeouts().getAttribute(methodIntf, method);
        if (txTimeout != null) {
            this.txTimeouts.put(new MethodTransactionAttributeKey(methodIntf, MethodIdentifier.getIdentifierForMethod((Method)method)), txTimeout);
        }
    }

    public Map<String, ServiceName> getViewServices() {
        return this.viewServices;
    }

    public EJBSecurityMetaData getSecurityMetaData() {
        return this.securityMetaData;
    }

    public Map<Method, InterceptorFactory> getTimeoutInterceptors() {
        return this.timeoutInterceptors;
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    public Method getTimeoutMethod() {
        return this.timeoutMethod;
    }

    public ServiceName getEjbHome() {
        return this.ejbHome;
    }

    public ServiceName getEjbLocalHome() {
        return this.ejbLocalHome;
    }

    public ServiceName getEjbObject() {
        return this.ejbObject;
    }

    public ServiceName getEjbLocalObject() {
        return this.ejbLocalObject;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getEarApplicationName() {
        return this.earApplicationName;
    }

    public String getDistinctName() {
        return this.distinctName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public Injector<EJBRemoteTransactionsRepository> getEJBRemoteTransactionsRepositoryInjector() {
        return this.ejbRemoteTransactionsRepository;
    }

    EJBRemoteTransactionsRepository getEJBRemoteTransactionsRepository() {
        return (EJBRemoteTransactionsRepository)this.ejbRemoteTransactionsRepository.getOptionalValue();
    }

    Injector<TransactionManager> getTransactionManagerInjector() {
        return this.transactionManagerInjectedValue;
    }

    TransactionManager getTransactionManager() {
        return (TransactionManager)this.transactionManagerInjectedValue.getValue();
    }

    Injector<UserTransaction> getUserTransactionInjector() {
        return this.userTransactionInjectedValue;
    }

    UserTransaction getUserTransaction() {
        return (UserTransaction)this.userTransactionInjectedValue.getValue();
    }

    Injector<TransactionSynchronizationRegistry> getTransactionSynchronizationRegistryInjector() {
        return this.transactionSynchronizationRegistryValue;
    }

    TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return (TransactionSynchronizationRegistry)this.transactionSynchronizationRegistryValue.getOptionalValue();
    }

    ServerSecurityManager getServerSecurityManager() {
        return (ServerSecurityManager)this.serverSecurityManagerInjectedValue.getValue();
    }

    Injector<ServerSecurityManager> getServerSecurityManagerInjector() {
        return this.serverSecurityManagerInjectedValue;
    }

    public ControlPoint getControlPoint() {
        return (ControlPoint)this.controlPoint.getOptionalValue();
    }

    public Injector<ControlPoint> getControlPointInjector() {
        return this.controlPoint;
    }

    public String getPolicyContextID() {
        return this.policyContextID;
    }
}

