/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.ViewInstanceFactory;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentInstance;
import org.jboss.as.ejb3.component.entity.interceptors.EntityBeanHomeCreateInterceptorFactory;
import org.jboss.as.ejb3.context.CurrentInvocationContext;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EntityEJBLocator;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.Interceptors;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class EntityBeanRemoteViewInstanceFactory
implements ViewInstanceFactory {
    private final String applicationName;
    private final String moduleName;
    private final String distinctName;
    private final String beanName;

    public EntityBeanRemoteViewInstanceFactory(String applicationName, String moduleName, String distinctName, String beanName) {
        this.applicationName = applicationName;
        this.moduleName = moduleName;
        this.distinctName = distinctName;
        this.beanName = beanName;
    }

    public ManagedReference createViewInstance(ComponentView componentView, Map<Object, Object> contextData) throws Exception {
        Object primaryKey = contextData.get(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY);
        if (primaryKey == null) {
            primaryKey = this.invokeCreate(componentView.getComponent(), contextData);
        }
        Object value = EJBClient.createProxy((EJBLocator)new EntityEJBLocator(componentView.getViewClass(), this.applicationName, this.moduleName, this.beanName, this.distinctName, primaryKey));
        return new ValueManagedReference((Value)new ImmediateValue(value));
    }

    private Object invokeCreate(Component component, Map<Object, Object> contextData) throws Exception {
        Method ejbCreate = (Method)contextData.get(EntityBeanHomeCreateInterceptorFactory.EJB_CREATE_METHOD_KEY);
        if (ejbCreate == null) {
            throw EjbLogger.ROOT_LOGGER.entityCannotBeCreatedDueToMissingCreateMethod(this.beanName);
        }
        Method ejbPostCreate = (Method)contextData.get(EntityBeanHomeCreateInterceptorFactory.EJB_POST_CREATE_METHOD_KEY);
        Object[] params = (Object[])contextData.get(EntityBeanHomeCreateInterceptorFactory.PARAMETERS_KEY);
        if (!(component instanceof EntityBeanComponent)) {
            throw EjbLogger.ROOT_LOGGER.notAnEntityBean(component);
        }
        final EntityBeanComponent entityBeanComponent = (EntityBeanComponent)component;
        final EntityBeanComponentInstance instance = entityBeanComponent.acquireUnAssociatedInstance();
        Object primaryKey = this.invokeEjbCreate(contextData, ejbCreate, instance, params);
        instance.associate(primaryKey);
        entityBeanComponent.getCache().create(instance);
        boolean synchronizationRegistered = false;
        boolean exception = false;
        try {
            this.invokeEjbPostCreate(contextData, ejbPostCreate, instance, params);
            TransactionSynchronizationRegistry transactionSynchronizationRegistry = entityBeanComponent.getTransactionSynchronizationRegistry();
            if (transactionSynchronizationRegistry.getTransactionKey() != null) {
                transactionSynchronizationRegistry.registerInterposedSynchronization(new Synchronization(){

                    public void beforeCompletion() {
                    }

                    public void afterCompletion(int status) {
                        entityBeanComponent.getCache().release(instance, status == 3);
                    }
                });
                synchronizationRegistered = true;
            }
        }
        catch (Exception e) {
            entityBeanComponent.getCache().release(instance, false);
            exception = true;
            throw e;
        }
        finally {
            if (!synchronizationRegistered && !exception) {
                entityBeanComponent.getCache().release(instance, true);
            }
        }
        return primaryKey;
    }

    protected void invokeEjbPostCreate(Map<Object, Object> contextData, Method ejbPostCreate, EntityBeanComponentInstance instance, Object[] params) throws Exception {
        try {
            ejbPostCreate.invoke((Object)instance.getInstance(), params);
        }
        catch (InvocationTargetException e) {
            throw Interceptors.rethrow((Throwable)e.getCause());
        }
    }

    protected Object invokeEjbCreate(Map<Object, Object> contextData, Method ejbCreate, EntityBeanComponentInstance instance, Object[] params) throws Exception {
        InterceptorContext context = CurrentInvocationContext.get();
        InvocationType invocationType = (InvocationType)context.getPrivateData(InvocationType.class);
        try {
            context.putPrivateData(InvocationType.class, (Object)InvocationType.ENTITY_EJB_CREATE);
            Object object = ejbCreate.invoke((Object)instance.getInstance(), params);
            return object;
        }
        catch (InvocationTargetException e) {
            throw Interceptors.rethrow((Throwable)e.getCause());
        }
        finally {
            context.putPrivateData(InvocationType.class, (Object)invocationType);
        }
    }
}

