/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.interceptors;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.ejb3.component.interceptors.CancellationFlag;
import org.jboss.as.ejb3.logging.EjbLogger;

public abstract class AsyncInvocationTask
implements Runnable,
Future {
    private final CancellationFlag cancelledFlag;
    private volatile boolean running = false;
    private boolean done = false;
    private Object result;
    private Exception failed;

    public AsyncInvocationTask(CancellationFlag cancelledFlag) {
        this.cancelledFlag = cancelledFlag;
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (!mayInterruptIfRunning && this.running) {
            return false;
        }
        this.cancelledFlag.set(true);
        if (!this.running) {
            this.done();
            return true;
        }
        return false;
    }

    protected abstract Object runInvocation() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object result;
        AsyncInvocationTask asyncInvocationTask = this;
        synchronized (asyncInvocationTask) {
            this.running = true;
            if (this.cancelledFlag.get()) {
                return;
            }
        }
        try {
            result = this.runInvocation();
        }
        catch (Exception e) {
            this.setFailed(e);
            return;
        }
        Future asyncResult = (Future)result;
        try {
            if (asyncResult != null) {
                result = asyncResult.get();
            }
        }
        catch (InterruptedException e) {
            this.setFailed(new IllegalStateException(e));
            return;
        }
        catch (ExecutionException e) {
            try {
                throw e.getCause();
            }
            catch (Exception ex) {
                this.setFailed(ex);
                return;
            }
            catch (Throwable throwable) {
                this.setFailed(new UndeclaredThrowableException(throwable));
                return;
            }
        }
        this.setResult(result);
    }

    private synchronized void setResult(Object result) {
        this.result = result;
        this.done();
    }

    private synchronized void setFailed(Exception e) {
        this.failed = e;
        this.done();
    }

    private void done() {
        this.done = true;
        this.notifyAll();
    }

    @Override
    public boolean isCancelled() {
        return this.done && this.cancelledFlag.get();
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    public synchronized Object get() throws InterruptedException, ExecutionException {
        while (!this.isDone()) {
            this.wait();
        }
        if (this.failed != null) {
            throw new ExecutionException(this.failed);
        }
        return this.result;
    }

    public synchronized Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.isDone()) {
            this.wait(unit.toMillis(timeout));
            if (!this.isDone()) {
                throw EjbLogger.ROOT_LOGGER.failToCompleteTaskBeforeTimeOut(timeout, unit);
            }
        }
        if (this.cancelledFlag.get()) {
            throw EjbLogger.ROOT_LOGGER.taskWasCancelled();
        }
        if (this.failed != null) {
            throw new ExecutionException(this.failed);
        }
        return this.result;
    }
}

