/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.List;
import java.util.Timer;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.ejb3.deployment.processors.TimerServiceDeploymentProcessor;
import org.jboss.as.ejb3.subsystem.DatabaseDataStoreResourceDefinition;
import org.jboss.as.ejb3.timerservice.persistence.TimerPersistence;
import org.jboss.as.ejb3.timerservice.persistence.database.DatabaseTimerPersistence;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public class DatabaseDataStoreAdd
extends AbstractAddStepHandler {
    public static final DatabaseDataStoreAdd INSTANCE = new DatabaseDataStoreAdd();

    protected void populateModel(ModelNode operation, ModelNode timerServiceModel) throws OperationFailedException {
        for (AttributeDefinition attr : DatabaseDataStoreResourceDefinition.ATTRIBUTES.values()) {
            attr.validateAndSet(operation, timerServiceModel);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceController<DatabaseTimerPersistence> controller = this.installRuntimeServices(context, operation, model, verificationHandler);
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }

    public ServiceController<DatabaseTimerPersistence> installRuntimeServices(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        String jndiName = DatabaseDataStoreResourceDefinition.DATASOURCE_JNDI_NAME.resolveModelAttribute(context, model).asString();
        ModelNode dataBaseValue = DatabaseDataStoreResourceDefinition.DATABASE.resolveModelAttribute(context, model);
        String database = dataBaseValue.isDefined() ? dataBaseValue.asString() : null;
        String partition = DatabaseDataStoreResourceDefinition.PARTITION.resolveModelAttribute(context, model).asString();
        String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        int refreshInterval = DatabaseDataStoreResourceDefinition.REFRESH_INTERVAL.resolveModelAttribute(context, model).asInt();
        boolean allowExecution = DatabaseDataStoreResourceDefinition.ALLOW_EXECUTION.resolveModelAttribute(context, model).asBoolean();
        DatabaseTimerPersistence databaseTimerPersistence = new DatabaseTimerPersistence(name, database, partition, refreshInterval, allowExecution);
        ServiceName serviceName = TimerPersistence.SERVICE_NAME.append(new String[]{name});
        ServiceBuilder builder = context.getServiceTarget().addService(serviceName, (Service)databaseTimerPersistence);
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        return builder.addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, databaseTimerPersistence.getModuleLoader()).addDependency(ContextNames.bindInfoFor((String)jndiName).getBinderServiceName(), ManagedReferenceFactory.class, databaseTimerPersistence.getDataSourceInjectedValue()).addDependency(TimerServiceDeploymentProcessor.TIMER_SERVICE_NAME, Timer.class, databaseTimerPersistence.getTimerInjectedValue()).install();
    }
}

