/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import java.io.Closeable;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.ejb.EJBException;
import javax.ejb.ScheduleExpression;
import javax.ejb.TimerConfig;
import javax.ejb.TimerHandle;
import javax.ejb.TimerService;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.TimerServiceRegistry;
import org.jboss.as.ejb3.component.allowedmethods.AllowedMethodsInformation;
import org.jboss.as.ejb3.component.allowedmethods.MethodType;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.singleton.SingletonComponent;
import org.jboss.as.ejb3.component.stateful.CurrentSynchronizationCallback;
import org.jboss.as.ejb3.context.CurrentInvocationContext;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.subsystem.deployment.TimerServiceResource;
import org.jboss.as.ejb3.timerservice.AutoTimer;
import org.jboss.as.ejb3.timerservice.CalendarTimer;
import org.jboss.as.ejb3.timerservice.TimerHandleImpl;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.timerservice.TimerState;
import org.jboss.as.ejb3.timerservice.persistence.TimerPersistence;
import org.jboss.as.ejb3.timerservice.spi.ScheduleTimer;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.ejb3.timerservice.task.TimerTask;
import org.jboss.invocation.InterceptorContext;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.xnio.IoUtils;

public class TimerServiceImpl
implements TimerService,
Service<TimerService> {
    private static final Set<TimerState> ineligibleTimerStates;
    private static final Logger logger;
    public static final ServiceName SERVICE_NAME;
    private final ServiceName serviceName;
    private final InjectedValue<EJBComponent> ejbComponentInjectedValue = new InjectedValue();
    private final InjectedValue<ExecutorService> executorServiceInjectedValue = new InjectedValue();
    private final InjectedValue<Timer> timerInjectedValue = new InjectedValue();
    private final InjectedValue<TimedObjectInvoker> timedObjectInvoker = new InjectedValue();
    private final Map<Method, List<AutoTimer>> autoTimers;
    private final InjectedValue<TimerPersistence> timerPersistence = new InjectedValue();
    private final Map<String, TimerImpl> timers = Collections.synchronizedMap(new HashMap());
    private final Map<String, java.util.TimerTask> scheduledTimerFutures = new HashMap<String, java.util.TimerTask>();
    private static final Object waitingOnTxCompletionKey;
    private TransactionManager transactionManager;
    private TransactionSynchronizationRegistry tsr;
    private final TimerServiceRegistry timerServiceRegistry;
    private TimerServiceResource resource = new TimerServiceResource();
    private Closeable listenerHandle;
    private volatile boolean started = false;

    @Deprecated
    public TimerServiceImpl(Map<Method, List<AutoTimer>> autoTimers, ServiceName serviceName) {
        this(autoTimers, serviceName, null);
    }

    public TimerServiceImpl(Map<Method, List<AutoTimer>> autoTimers, ServiceName serviceName, TimerServiceRegistry registry) {
        this.autoTimers = autoTimers;
        this.serviceName = serviceName;
        this.timerServiceRegistry = registry;
    }

    public synchronized void start(StartContext context) throws StartException {
        logger.debug((Object)("Starting timerservice for timedObjectId: " + this.getInvoker().getTimedObjectId()));
        EJBComponent component = (EJBComponent)((Object)this.ejbComponentInjectedValue.getValue());
        this.transactionManager = component.getTransactionManager();
        this.tsr = component.getTransactionSynchronizationRegistry();
        TimedObjectInvoker invoker = (TimedObjectInvoker)this.timedObjectInvoker.getValue();
        if (invoker == null) {
            throw EjbLogger.ROOT_LOGGER.invokerIsNull();
        }
        ArrayList<ScheduleTimer> timers = new ArrayList<ScheduleTimer>();
        for (Map.Entry<Method, List<AutoTimer>> entry : this.autoTimers.entrySet()) {
            for (AutoTimer timer : entry.getValue()) {
                timers.add(new ScheduleTimer(entry.getKey(), timer.getScheduleExpression(), timer.getTimerConfig()));
            }
        }
        this.started = true;
        this.restoreTimers(timers);
        if (this.timerServiceRegistry != null) {
            this.timerServiceRegistry.registerTimerService(this);
        }
        this.listenerHandle = ((TimerPersistence)this.timerPersistence.getValue()).registerChangeListener(this.getInvoker().getTimedObjectId(), new TimerRefreshListener());
    }

    public synchronized void stop(StopContext context) {
        if (this.timerServiceRegistry != null) {
            this.timerServiceRegistry.unRegisterTimerService(this);
        }
        this.suspendTimers();
        ((TimerPersistence)this.timerPersistence.getValue()).timerUndeployed(((TimedObjectInvoker)this.timedObjectInvoker.getValue()).getTimedObjectId());
        this.started = false;
        this.transactionManager = null;
        IoUtils.safeClose((Closeable)this.listenerHandle);
        this.listenerHandle = null;
        ((Timer)this.timerInjectedValue.getValue()).purge();
    }

    public synchronized TimerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public javax.ejb.Timer createCalendarTimer(ScheduleExpression schedule) throws IllegalArgumentException, IllegalStateException, EJBException {
        return this.createCalendarTimer(schedule, null);
    }

    public javax.ejb.Timer createCalendarTimer(ScheduleExpression schedule, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertTimerServiceState();
        Serializable info = timerConfig == null ? null : timerConfig.getInfo();
        boolean persistent = timerConfig == null || timerConfig.isPersistent();
        return this.createCalendarTimer(schedule, info, persistent, null);
    }

    public javax.ejb.Timer createIntervalTimer(Date initialExpiration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertTimerServiceState();
        if (initialExpiration == null) {
            throw EjbLogger.ROOT_LOGGER.initialExpirationIsNullCreatingTimer();
        }
        if (initialExpiration.getTime() < 0L) {
            throw EjbLogger.ROOT_LOGGER.invalidInitialExpiration("initialExpiration.getTime()");
        }
        if (intervalDuration < 0L) {
            throw EjbLogger.ROOT_LOGGER.invalidInitialExpiration("intervalDuration");
        }
        return this.createTimer(initialExpiration, intervalDuration, timerConfig.getInfo(), timerConfig.isPersistent());
    }

    public javax.ejb.Timer createIntervalTimer(long initialDuration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertTimerServiceState();
        if (initialDuration < 0L) {
            throw EjbLogger.ROOT_LOGGER.invalidInitialExpiration("intervalDuration");
        }
        if (intervalDuration < 0L) {
            throw EjbLogger.ROOT_LOGGER.invalidInitialExpiration("intervalDuration");
        }
        return this.createIntervalTimer(new Date(System.currentTimeMillis() + initialDuration), intervalDuration, timerConfig);
    }

    public javax.ejb.Timer createSingleActionTimer(Date expiration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertTimerServiceState();
        if (expiration == null) {
            throw EjbLogger.ROOT_LOGGER.expirationIsNull();
        }
        if (expiration.getTime() < 0L) {
            throw EjbLogger.ROOT_LOGGER.invalidExpirationActionTimer();
        }
        return this.createTimer(expiration, 0L, timerConfig.getInfo(), timerConfig.isPersistent());
    }

    public javax.ejb.Timer createSingleActionTimer(long duration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertTimerServiceState();
        if (duration < 0L) {
            throw EjbLogger.ROOT_LOGGER.invalidDurationActionTimer();
        }
        return this.createTimer(new Date(System.currentTimeMillis() + duration), 0L, timerConfig.getInfo(), timerConfig.isPersistent());
    }

    public javax.ejb.Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertTimerServiceState();
        if (duration < 0L) {
            throw EjbLogger.ROOT_LOGGER.invalidDurationTimer();
        }
        return this.createTimer(new Date(System.currentTimeMillis() + duration), 0L, info, true);
    }

    public javax.ejb.Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertTimerServiceState();
        if (expiration == null) {
            throw EjbLogger.ROOT_LOGGER.expirationDateIsNull();
        }
        if (expiration.getTime() < 0L) {
            throw EjbLogger.ROOT_LOGGER.invalidExpirationTimer();
        }
        return this.createTimer(expiration, 0L, info, true);
    }

    public javax.ejb.Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertTimerServiceState();
        if (initialDuration < 0L) {
            throw EjbLogger.ROOT_LOGGER.invalidInitialDurationTimer();
        }
        if (intervalDuration < 0L) {
            throw EjbLogger.ROOT_LOGGER.invalidIntervalTimer();
        }
        return this.createTimer(new Date(System.currentTimeMillis() + initialDuration), intervalDuration, info, true);
    }

    public javax.ejb.Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.assertTimerServiceState();
        if (initialExpiration == null) {
            throw EjbLogger.ROOT_LOGGER.initialExpirationDateIsNull();
        }
        if (initialExpiration.getTime() < 0L) {
            throw EjbLogger.ROOT_LOGGER.invalidExpirationTimer();
        }
        if (intervalDuration < 0L) {
            throw EjbLogger.ROOT_LOGGER.invalidIntervalDurationTimer();
        }
        return this.createTimer(initialExpiration, intervalDuration, info, true);
    }

    public TimerImpl loadAutoTimer(ScheduleExpression schedule, TimerConfig timerConfig, Method timeoutMethod) {
        return this.createCalendarTimer(schedule, timerConfig.getInfo(), timerConfig.isPersistent(), timeoutMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<javax.ejb.Timer> getTimers() throws IllegalStateException, EJBException {
        this.assertTimerServiceState();
        Object pk = this.currentPrimaryKey();
        HashSet<javax.ejb.Timer> activeTimers = new HashSet<javax.ejb.Timer>();
        Map<String, TimerImpl> map = this.timers;
        synchronized (map) {
            for (TimerImpl timer : this.timers.values()) {
                if (!timer.isActive() || timer.getPrimaryKey() != null && !timer.getPrimaryKey().equals(pk)) continue;
                activeTimers.add(timer);
            }
        }
        for (TimerImpl timer : this.getWaitingOnTxCompletionTimers().values()) {
            if (!timer.isActive() || timer.getPrimaryKey() != null && !timer.getPrimaryKey().equals(pk)) continue;
            activeTimers.add(timer);
        }
        return activeTimers;
    }

    public Collection<javax.ejb.Timer> getAllTimers() throws IllegalStateException, EJBException {
        if (this.timerServiceRegistry != null) {
            return this.timerServiceRegistry.getAllActiveTimers();
        }
        return this.getTimers();
    }

    private javax.ejb.Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info, boolean persistent) {
        if (this.isLifecycleCallbackInvocation() && !this.isSingletonBeanInvocation()) {
            throw EjbLogger.ROOT_LOGGER.failToCreateTimerDoLifecycle();
        }
        if (initialExpiration == null) {
            throw EjbLogger.ROOT_LOGGER.initialExpirationIsNull();
        }
        if (intervalDuration < 0L) {
            throw EjbLogger.ROOT_LOGGER.invalidIntervalDuration();
        }
        UUID uuid = UUID.randomUUID();
        TimerImpl timer = TimerImpl.builder().setNewTimer(true).setId(uuid.toString()).setInitialDate(initialExpiration).setRepeatInterval(intervalDuration).setInfo(info).setPersistent(persistent).setPrimaryKey(this.currentPrimaryKey()).setTimerState(TimerState.CREATED).setTimedObjectId(this.getInvoker().getTimedObjectId()).build(this);
        this.persistTimer(timer, true);
        this.startTimer(timer);
        return timer;
    }

    private Object currentPrimaryKey() {
        InterceptorContext context = CurrentInvocationContext.get();
        if (context == null) {
            return null;
        }
        return context.getPrivateData(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY);
    }

    private TimerImpl createCalendarTimer(ScheduleExpression schedule, Serializable info, boolean persistent, Method timeoutMethod) {
        if (this.isLifecycleCallbackInvocation() && !this.isSingletonBeanInvocation()) {
            throw EjbLogger.ROOT_LOGGER.failToCreateTimerDoLifecycle();
        }
        if (schedule == null) {
            throw EjbLogger.ROOT_LOGGER.scheduleIsNull();
        }
        UUID uuid = UUID.randomUUID();
        TimerImpl timer = CalendarTimer.builder().setAutoTimer(timeoutMethod != null).setScheduleExprSecond(schedule.getSecond()).setScheduleExprMinute(schedule.getMinute()).setScheduleExprHour(schedule.getHour()).setScheduleExprDayOfWeek(schedule.getDayOfWeek()).setScheduleExprDayOfMonth(schedule.getDayOfMonth()).setScheduleExprMonth(schedule.getMonth()).setScheduleExprYear(schedule.getYear()).setScheduleExprStartDate(schedule.getStart()).setScheduleExprEndDate(schedule.getEnd()).setScheduleExprTimezone(schedule.getTimezone()).setTimeoutMethod(timeoutMethod).setTimerState(TimerState.CREATED).setId(uuid.toString()).setPersistent(persistent).setPrimaryKey(this.currentPrimaryKey()).setTimedObjectId(this.getInvoker().getTimedObjectId()).setInfo(info).setNewTimer(true).build(this);
        this.persistTimer(timer, true);
        this.startTimer(timer);
        return timer;
    }

    public TimerImpl getTimer(String timerId) {
        return this.timers.get(timerId);
    }

    public TimedObjectInvoker getInvoker() {
        return (TimedObjectInvoker)this.timedObjectInvoker.getValue();
    }

    public TimerImpl getTimer(TimerHandle handle) {
        TimerHandleImpl timerHandle = (TimerHandleImpl)handle;
        TimerImpl timer = this.timers.get(timerHandle.getId());
        if (timer != null) {
            return timer;
        }
        return this.getWaitingOnTxCompletionTimers().get(timerHandle.getId());
    }

    protected Transaction getTransaction() {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void persistTimer(TimerImpl timer, boolean newTimer) {
        if (timer == null) {
            return;
        }
        if (timer.isTimerPersistent()) {
            try {
                if (this.timerPersistence.getOptionalValue() == null) {
                    EjbLogger.ROOT_LOGGER.timerPersistenceNotEnable();
                    return;
                }
                if (newTimer) {
                    ((TimerPersistence)this.timerPersistence.getValue()).addTimer(timer);
                } else {
                    ((TimerPersistence)this.timerPersistence.getValue()).persistTimer(timer);
                }
            }
            catch (Throwable t) {
                this.setRollbackOnly();
                throw new RuntimeException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTimer(TimerImpl timer) {
        timer.lock();
        boolean release = true;
        try {
            timer.assertTimerState();
            boolean startedInTx = this.getWaitingOnTxCompletionTimers().containsKey(timer.getId());
            if (timer.getState() != TimerState.EXPIRED) {
                timer.setTimerState(TimerState.CANCELED);
            }
            if (this.transactionActive() && !startedInTx) {
                this.registerSynchronization(new TimerRemoveSynchronization(timer));
                release = false;
            } else {
                this.cancelTimeout(timer);
                this.unregisterTimerResource(timer.getId());
                this.timers.remove(timer.getId());
            }
            this.persistTimer(timer, false);
        }
        finally {
            if (release) {
                timer.unlock();
            }
        }
    }

    public void expireTimer(TimerImpl timer) {
        this.cancelTimeout(timer);
        timer.setTimerState(TimerState.EXPIRED);
        this.unregisterTimerResource(timer.getId());
        this.timers.remove(timer.getId());
    }

    public void suspendTimers() {
        Collection<javax.ejb.Timer> timers = this.getTimers();
        for (javax.ejb.Timer timer : timers) {
            if (!(timer instanceof TimerImpl)) continue;
            ((TimerImpl)timer).suspend();
        }
    }

    public void restoreTimers(List<ScheduleTimer> autoTimers) {
        List<TimerImpl> restorableTimers = this.getActivePersistentTimers();
        LinkedList<ScheduleTimer> newAutoTimers = new LinkedList<ScheduleTimer>(autoTimers);
        EjbLogger.ROOT_LOGGER.debug("Found " + restorableTimers.size() + " active persistentTimers for timedObjectId: " + this.getInvoker().getTimedObjectId());
        for (TimerImpl activeTimer : restorableTimers) {
            if (activeTimer.isAutoTimer()) {
                CalendarTimer calendarTimer = (CalendarTimer)activeTimer;
                boolean found = false;
                ListIterator it = newAutoTimers.listIterator();
                while (it.hasNext()) {
                    ScheduleTimer timer = (ScheduleTimer)it.next();
                    String methodName = timer.getMethod().getName();
                    String[] params = new String[timer.getMethod().getParameterTypes().length];
                    for (int i = 0; i < timer.getMethod().getParameterTypes().length; ++i) {
                        params[i] = timer.getMethod().getParameterTypes()[i].getName();
                    }
                    if (!this.doesTimeoutMethodMatch(calendarTimer.getTimeoutMethod(), methodName, params) || !this.doesScheduleMatch(calendarTimer.getScheduleExpression(), timer.getScheduleExpression()) || !timer.getTimerConfig().isPersistent()) continue;
                    it.remove();
                    found = true;
                    break;
                }
                if (!found) {
                    activeTimer.setTimerState(TimerState.CANCELED);
                } else {
                    this.startTimer(activeTimer);
                    EjbLogger.ROOT_LOGGER.debug("Started timer: " + activeTimer);
                }
                this.persistTimer(activeTimer, false);
            } else if (!ineligibleTimerStates.contains((Object)activeTimer.getState())) {
                this.startTimer(activeTimer);
            }
            EjbLogger.ROOT_LOGGER.debug("Started timer: " + activeTimer);
        }
        for (ScheduleTimer timer : newAutoTimers) {
            this.loadAutoTimer(timer.getScheduleExpression(), timer.getTimerConfig(), timer.getMethod());
        }
    }

    protected void startTimer(TimerImpl timer) {
        if (!this.transactionActive()) {
            this.timers.put(timer.getId(), timer);
            timer.setTimerState(TimerState.ACTIVE);
            this.registerTimerResource(timer.getId());
            timer.scheduleTimeout(true);
        } else {
            this.addWaitingOnTxCompletionTimer(timer);
            this.registerSynchronization(new TimerCreationTransactionSynchronization(timer));
        }
    }

    private void registerSynchronization(Synchronization synchronization) {
        try {
            Transaction tx = this.getTransaction();
            tx.registerSynchronization(synchronization);
        }
        catch (RollbackException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (SystemException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    boolean transactionActive() {
        Transaction currentTx = this.getTransaction();
        if (currentTx != null) {
            try {
                int status = currentTx.getStatus();
                return status != 1 && status != 4 && status != 9 && status != 6 && status != 5 && status != 3 && !this.isBeforeCompletion();
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private boolean isBeforeCompletion() {
        CurrentSynchronizationCallback.CallbackType type = CurrentSynchronizationCallback.get();
        if (type != null) {
            return type == CurrentSynchronizationCallback.CallbackType.BEFORE_COMPLETION;
        }
        return false;
    }

    protected boolean isLifecycleCallbackInvocation() {
        InterceptorContext currentInvocationContext = CurrentInvocationContext.get();
        if (currentInvocationContext == null) {
            return false;
        }
        Method invokedMethod = currentInvocationContext.getMethod();
        return invokedMethod == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleTimeout(TimerImpl timer, boolean newTimer) {
        Map<String, java.util.TimerTask> map = this.scheduledTimerFutures;
        synchronized (map) {
            if (!newTimer && !this.scheduledTimerFutures.containsKey(timer.getId())) {
                return;
            }
            Date nextExpiration = timer.getNextExpiration();
            if (nextExpiration == null) {
                EjbLogger.ROOT_LOGGER.nextExpirationIsNull(timer);
                return;
            }
            TimerTask<?> timerTask = timer.getTimerTask();
            long delay = nextExpiration.getTime() - System.currentTimeMillis();
            if (delay < 0L) {
                delay = 0L;
            }
            long intervalDuration = timer.getInterval();
            Task task = new Task(timerTask, ((EJBComponent)((Object)this.ejbComponentInjectedValue.getValue())).getControlPoint());
            if (intervalDuration > 0L) {
                EjbLogger.ROOT_LOGGER.debug("Scheduling timer " + timer + " at fixed rate, starting at " + delay + " milliseconds from now with repeated interval=" + intervalDuration);
                ((Timer)this.timerInjectedValue.getValue()).scheduleAtFixedRate((java.util.TimerTask)task, delay, intervalDuration);
                this.scheduledTimerFutures.put(timer.getId(), task);
            } else {
                EjbLogger.ROOT_LOGGER.debug("Scheduling a single action timer " + timer + " starting at " + delay + " milliseconds from now");
                ((Timer)this.timerInjectedValue.getValue()).schedule((java.util.TimerTask)task, delay);
                this.scheduledTimerFutures.put(timer.getId(), task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelTimeout(TimerImpl timer) {
        Map<String, java.util.TimerTask> map = this.scheduledTimerFutures;
        synchronized (map) {
            java.util.TimerTask timerTask = this.scheduledTimerFutures.remove(timer.getId());
            if (timerTask != null) {
                timerTask.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeTimeout(TimerImpl timer) {
        Map<String, java.util.TimerTask> map = this.scheduledTimerFutures;
        synchronized (map) {
            if (this.scheduledTimerFutures.containsKey(timer.getId())) {
                timer.getTimerTask().run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isScheduled(String tid) {
        Map<String, java.util.TimerTask> map = this.scheduledTimerFutures;
        synchronized (map) {
            return this.scheduledTimerFutures.containsKey(tid);
        }
    }

    private Map<String, TimerImpl> getWaitingOnTxCompletionTimers() {
        Map timers = null;
        if (this.getTransaction() != null) {
            timers = (Map)this.tsr.getResource(waitingOnTxCompletionKey);
        }
        return timers == null ? Collections.emptyMap() : timers;
    }

    private void addWaitingOnTxCompletionTimer(TimerImpl timer) {
        HashMap<String, TimerImpl> timers = (HashMap<String, TimerImpl>)this.tsr.getResource(waitingOnTxCompletionKey);
        if (timers == null) {
            timers = new HashMap<String, TimerImpl>();
            this.tsr.putResource(waitingOnTxCompletionKey, timers);
        }
        timers.put(timer.getId(), timer);
    }

    private boolean isSingletonBeanInvocation() {
        return this.ejbComponentInjectedValue.getValue() instanceof SingletonComponent;
    }

    private List<TimerImpl> getActivePersistentTimers() {
        String timedObjectId = this.getInvoker().getTimedObjectId();
        if (this.timerPersistence.getOptionalValue() == null) {
            return Collections.emptyList();
        }
        List<TimerImpl> persistedTimers = ((TimerPersistence)this.timerPersistence.getValue()).loadActiveTimers(timedObjectId, this);
        ArrayList<TimerImpl> activeTimers = new ArrayList<TimerImpl>();
        for (TimerImpl persistedTimer : persistedTimers) {
            if (ineligibleTimerStates.contains((Object)persistedTimer.getState())) continue;
            activeTimers.add(persistedTimer);
        }
        return activeTimers;
    }

    private boolean doesTimeoutMethodMatch(Method timeoutMethod, String timeoutMethodName, String[] methodParams) {
        if (!timeoutMethod.getName().equals(timeoutMethodName)) {
            return false;
        }
        Class<?>[] timeoutMethodParams = timeoutMethod.getParameterTypes();
        return this.methodParamsMatch(timeoutMethodParams, methodParams);
    }

    private boolean doesScheduleMatch(ScheduleExpression expression1, ScheduleExpression expression2) {
        if (!this.same(expression1.getDayOfMonth(), expression2.getDayOfMonth())) {
            return false;
        }
        if (!this.same(expression1.getDayOfWeek(), expression2.getDayOfWeek())) {
            return false;
        }
        if (!this.same(expression1.getEnd(), expression2.getEnd())) {
            return false;
        }
        if (!this.same(expression1.getHour(), expression2.getHour())) {
            return false;
        }
        if (!this.same(expression1.getMinute(), expression2.getMinute())) {
            return false;
        }
        if (!this.same(expression1.getMonth(), expression2.getMonth())) {
            return false;
        }
        if (!this.same(expression1.getSecond(), expression2.getSecond())) {
            return false;
        }
        if (!this.same(expression1.getStart(), expression2.getStart())) {
            return false;
        }
        if (!this.same(expression1.getTimezone(), expression2.getTimezone())) {
            return false;
        }
        return this.same(expression1.getYear(), expression2.getYear());
    }

    private boolean same(Object i1, Object i2) {
        if (i1 == null && i2 != null) {
            return false;
        }
        if (i2 == null && i1 != null) {
            return false;
        }
        if (i1 == null && i2 == null) {
            return true;
        }
        return i1.equals(i2);
    }

    private boolean methodParamsMatch(Class<?>[] methodParams, String[] otherMethodParams) {
        if (otherMethodParams == null) {
            otherMethodParams = new String[]{};
        }
        if (methodParams.length != otherMethodParams.length) {
            return false;
        }
        for (int i = 0; i < methodParams.length; ++i) {
            if (methodParams[i].getName().equals(otherMethodParams[i])) continue;
            return false;
        }
        return true;
    }

    private void setRollbackOnly() {
        try {
            Transaction tx = this.transactionManager.getTransaction();
            if (tx != null) {
                tx.setRollbackOnly();
            }
        }
        catch (IllegalStateException ise) {
            EjbLogger.ROOT_LOGGER.ignoringException(ise);
        }
        catch (SystemException se) {
            EjbLogger.ROOT_LOGGER.ignoringException(se);
        }
    }

    private void startNewTx() {
        try {
            this.transactionManager.begin();
        }
        catch (Throwable t) {
            throw EjbLogger.ROOT_LOGGER.failToStartTransaction(t);
        }
    }

    private void assertTimerServiceState() {
        AllowedMethodsInformation.checkAllowed(MethodType.TIMER_SERVICE_METHOD);
        if (this.isLifecycleCallbackInvocation() && !this.isSingletonBeanInvocation()) {
            throw EjbLogger.ROOT_LOGGER.failToInvokeTimerServiceDoLifecycle();
        }
    }

    public InjectedValue<EJBComponent> getEjbComponentInjectedValue() {
        return this.ejbComponentInjectedValue;
    }

    public InjectedValue<ExecutorService> getExecutorServiceInjectedValue() {
        return this.executorServiceInjectedValue;
    }

    public InjectedValue<Timer> getTimerInjectedValue() {
        return this.timerInjectedValue;
    }

    public InjectedValue<TimerPersistence> getTimerPersistence() {
        return this.timerPersistence;
    }

    public ServiceName getServiceName() {
        return this.serviceName;
    }

    public boolean isStarted() {
        return this.started;
    }

    public InjectedValue<TimedObjectInvoker> getTimedObjectInvoker() {
        return this.timedObjectInvoker;
    }

    public TimerServiceResource getResource() {
        return this.resource;
    }

    private void registerTimerResource(String timerId) {
        this.resource.timerCreated(timerId);
    }

    private void unregisterTimerResource(String timerId) {
        this.resource.timerRemoved(timerId);
    }

    public boolean shouldRun(TimerImpl timer) {
        return !timer.isPersistent() || ((TimerPersistence)this.timerPersistence.getValue()).shouldRun(timer, this.transactionManager);
    }

    static {
        logger = Logger.getLogger(TimerServiceImpl.class);
        SERVICE_NAME = ServiceName.of((String[])new String[]{"ejb3", "timerService"});
        waitingOnTxCompletionKey = new Object();
        HashSet<TimerState> states = new HashSet<TimerState>();
        states.add(TimerState.CANCELED);
        states.add(TimerState.EXPIRED);
        ineligibleTimerStates = Collections.unmodifiableSet(states);
    }

    private final class TimerRefreshListener
    implements TimerPersistence.TimerChangeListener {
        private TimerRefreshListener() {
        }

        @Override
        public void timerAdded(TimerImpl timer) {
            TimerServiceImpl.this.startTimer(timer);
        }

        @Override
        public void timerRemoved(String timerId) {
            TimerImpl timer = TimerServiceImpl.this.getTimer(timerId);
            if (timer != null) {
                TimerServiceImpl.this.cancelTimeout(timer);
            }
        }

        @Override
        public TimerServiceImpl getTimerService() {
            return TimerServiceImpl.this;
        }
    }

    private class Task
    extends java.util.TimerTask {
        private final TimerTask<?> delegate;
        private final ControlPoint controlPoint;
        private volatile boolean queued = false;

        public Task(TimerTask<?> delegate, ControlPoint controlPoint) {
            this.delegate = delegate;
            this.controlPoint = controlPoint;
        }

        @Override
        public void run() {
            ExecutorService executor = (ExecutorService)TimerServiceImpl.this.executorServiceInjectedValue.getOptionalValue();
            if (executor != null) {
                if (this.controlPoint == null) {
                    executor.submit(this.delegate);
                } else if (!this.queued) {
                    this.queued = true;
                    this.controlPoint.queueTask(new Runnable(){

                        @Override
                        public void run() {
                            Task.this.queued = false;
                            Task.this.delegate.run();
                        }
                    }, (Executor)executor, -1L, null, false);
                } else {
                    EjbLogger.EJB3_INVOCATION_LOGGER.debug("Skipping timer invocation as existing request is already queued.");
                }
            }
        }

        @Override
        public boolean cancel() {
            this.delegate.cancel();
            return super.cancel();
        }
    }

    private class TimerRemoveSynchronization
    implements Synchronization {
        private final TimerImpl timer;

        private TimerRemoveSynchronization(TimerImpl timer) {
            this.timer = timer;
        }

        public void beforeCompletion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            try {
                if (status == 3) {
                    TimerServiceImpl.this.cancelTimeout(this.timer);
                    TimerServiceImpl.this.unregisterTimerResource(this.timer.getId());
                    TimerServiceImpl.this.timers.remove(this.timer.getId());
                } else {
                    this.timer.setTimerState(TimerState.ACTIVE);
                }
            }
            finally {
                this.timer.unlock();
            }
        }
    }

    private class TimerCreationTransactionSynchronization
    implements Synchronization {
        private final TimerImpl timer;

        public TimerCreationTransactionSynchronization(TimerImpl timer) {
            if (timer == null) {
                throw EjbLogger.ROOT_LOGGER.timerIsNull();
            }
            this.timer = timer;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (status == 3) {
                EjbLogger.ROOT_LOGGER.debug("commit timer creation: " + this.timer);
                TimerServiceImpl.this.timers.put(this.timer.getId(), this.timer);
                TimerServiceImpl.this.registerTimerResource(this.timer.getId());
                TimerState timerState = this.timer.getState();
                switch (timerState) {
                    case CREATED: {
                        this.timer.setTimerState(TimerState.ACTIVE);
                        this.timer.scheduleTimeout(true);
                        break;
                    }
                    case ACTIVE: {
                        this.timer.scheduleTimeout(true);
                    }
                }
            } else if (status == 4) {
                EjbLogger.ROOT_LOGGER.debug("Rolling back timer creation: " + this.timer);
                this.timer.setTimerState(TimerState.CANCELED);
            }
        }
    }
}

