/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.ext;

import javax.xml.namespace.QName;
import org.apache.xml.security.exceptions.XMLSecurityException;

public class WSSecurityException
extends XMLSecurityException {
    private static final long serialVersionUID = 4703352039717763655L;
    public static final String NS_WSSE10 = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final QName UNSUPPORTED_SECURITY_TOKEN = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UnsupportedSecurityToken");
    public static final QName UNSUPPORTED_ALGORITHM = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UnsupportedAlgorithm");
    public static final QName INVALID_SECURITY = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "InvalidSecurity");
    public static final QName INVALID_SECURITY_TOKEN = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "InvalidSecurityToken");
    public static final QName FAILED_AUTHENTICATION = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "FailedAuthentication");
    public static final QName FAILED_CHECK = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "FailedCheck");
    public static final QName SECURITY_TOKEN_UNAVAILABLE = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenUnavailable");
    public static final QName MESSAGE_EXPIRED = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "MessageExpired");
    public static final String UNSUPPORTED_TOKEN_ERR = "An unsupported token was provided";
    public static final String UNSUPPORTED_ALGORITHM_ERR = "An unsupported signature or encryption algorithm was used";
    public static final String INVALID_SECURITY_ERR = "An error was discovered processing the <wsse:Security> header.";
    public static final String INVALID_SECURITY_TOKEN_ERR = "An invalid security token was provided";
    public static final String FAILED_AUTHENTICATION_ERR = "The security token could not be authenticated or authorized";
    public static final String FAILED_CHECK_ERR = "The signature or decryption was invalid";
    public static final String SECURITY_TOKEN_UNAVAILABLE_ERR = "Referenced security token could not be retrieved";
    public static final String MESSAGE_EXPIRED_ERR = "The message has expired";
    private ErrorCode errorCode;

    public WSSecurityException(ErrorCode errorCode, String msgId, Exception exception, Object ... arguments) {
        super(msgId, arguments, exception);
        this.errorCode = errorCode;
    }

    public WSSecurityException(ErrorCode errorCode, String msgId, Exception exception) {
        super(msgId, exception);
        this.errorCode = errorCode;
    }

    public WSSecurityException(ErrorCode errorCode, Exception exception) {
        super(exception);
        this.errorCode = errorCode;
    }

    public WSSecurityException(ErrorCode errorCode, String msgId, Object ... arguments) {
        super(msgId, arguments);
        this.errorCode = errorCode;
    }

    public WSSecurityException(ErrorCode errorCode) {
        this(errorCode, errorCode.name(), new Object[0]);
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public QName getFaultCode() {
        return this.errorCode.getQName();
    }

    public String getSafeExceptionMessage() {
        if (this.getMessage() != null && this.getMessage().contains("replay attack")) {
            return this.getMessage();
        }
        String errorMessage = null;
        QName faultCode = this.getFaultCode();
        errorMessage = UNSUPPORTED_SECURITY_TOKEN.equals(faultCode) ? UNSUPPORTED_TOKEN_ERR : (UNSUPPORTED_ALGORITHM.equals(faultCode) ? UNSUPPORTED_ALGORITHM_ERR : (INVALID_SECURITY.equals(faultCode) ? INVALID_SECURITY_ERR : (INVALID_SECURITY_TOKEN.equals(faultCode) ? INVALID_SECURITY_TOKEN_ERR : (FAILED_AUTHENTICATION.equals(faultCode) ? FAILED_AUTHENTICATION_ERR : (FAILED_CHECK.equals(faultCode) ? FAILED_CHECK_ERR : (SECURITY_TOKEN_UNAVAILABLE.equals(faultCode) ? SECURITY_TOKEN_UNAVAILABLE_ERR : (MESSAGE_EXPIRED.equals(faultCode) ? MESSAGE_EXPIRED_ERR : INVALID_SECURITY_ERR)))))));
        return errorMessage;
    }

    public static enum ErrorCode {
        FAILURE(null),
        UNSUPPORTED_SECURITY_TOKEN(UNSUPPORTED_SECURITY_TOKEN),
        UNSUPPORTED_ALGORITHM(UNSUPPORTED_ALGORITHM),
        INVALID_SECURITY(INVALID_SECURITY),
        INVALID_SECURITY_TOKEN(INVALID_SECURITY_TOKEN),
        FAILED_AUTHENTICATION(FAILED_AUTHENTICATION),
        FAILED_CHECK(FAILED_CHECK),
        SECURITY_TOKEN_UNAVAILABLE(SECURITY_TOKEN_UNAVAILABLE),
        MESSAGE_EXPIRED(MESSAGE_EXPIRED),
        FAILED_ENCRYPTION(null),
        FAILED_SIGNATURE(null);

        private QName qName;

        private ErrorCode(QName qName) {
            this.qName = qName;
        }

        public QName getQName() {
            return this.qName;
        }
    }
}

