/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.resources.arjunacore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.jta.recovery.arjunacore.CommitMarkableResourceRecordRecoveryModule;
import com.arjuna.ats.internal.jta.resources.XAResourceErrorHandler;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionSynchronizationRegistryImple;
import com.arjuna.ats.internal.jta.xa.XID;
import com.arjuna.ats.jta.common.JTAEnvironmentBean;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.utils.XAHelper;
import com.arjuna.ats.jta.xa.XidImple;
import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.tm.ConnectableResource;
import org.jboss.tm.XAResourceWrapper;

public class CommitMarkableResourceRecord
extends AbstractRecord {
    private final String tableName;
    private Xid xid;
    private ConnectableResource connectableResource;
    private boolean onePhase = false;
    private String commitMarkableJndiName;
    private boolean committed;
    private BasicAction basicAction;
    private String productName;
    private String productVersion;
    private boolean hasCompleted;
    private static CommitMarkableResourceRecordRecoveryModule commitMarkableResourceRecoveryModule;
    private static final JTAEnvironmentBean jtaEnvironmentBean;
    private static final Map<String, String> commitMarkableResourceTableNameMap;
    private static final String defaultTableName;
    private boolean isPerformImmediateCleanupOfBranches = jtaEnvironmentBean.isPerformImmediateCleanupOfCommitMarkableResourceBranches();
    private Connection preparedConnection;
    private static final boolean isNotifyRecoveryModuleOfCompletedBranches;
    private static final Map<String, Boolean> isPerformImmediateCleanupOfCommitMarkableResourceBranchesMap;

    public CommitMarkableResourceRecord() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("CommitMarkableResourceRecord.CommitMarkableResourceRecord (), record id=" + this.order()));
        }
        this.tableName = null;
    }

    public CommitMarkableResourceRecord(TransactionImple tx2, ConnectableResource xaResource, final Xid xid, BasicAction basicAction) throws IllegalStateException, RollbackException, SystemException {
        super(new Uid(), null, 1);
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("CommitMarkableResourceRecord.CommitMarkableResourceRecord ( " + tx2 + ", " + xaResource + ", " + xid + ", " + basicAction + " ), record id=" + this.order()));
        }
        this.connectableResource = xaResource;
        XAResourceWrapper xaResourceWrapper = (XAResourceWrapper)xaResource;
        this.commitMarkableJndiName = xaResourceWrapper.getJndiName();
        this.productName = xaResourceWrapper.getProductName();
        this.productVersion = xaResourceWrapper.getProductVersion();
        this.xid = xid;
        this.basicAction = basicAction;
        String tableName = commitMarkableResourceTableNameMap.get(this.commitMarkableJndiName);
        this.tableName = tableName != null ? tableName : defaultTableName;
        Boolean boolean1 = isPerformImmediateCleanupOfCommitMarkableResourceBranchesMap.get(this.commitMarkableJndiName);
        if (boolean1 != null) {
            this.isPerformImmediateCleanupOfBranches = boolean1;
        }
        if (this.isPerformImmediateCleanupOfBranches) {
            new TransactionSynchronizationRegistryImple().registerInterposedSynchronization(new Synchronization(){

                public void beforeCompletion() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterCompletion(int status) {
                    if (!CommitMarkableResourceRecord.this.onePhase && status == 3) {
                        Connection connection = null;
                        try {
                            connection = (Connection)CommitMarkableResourceRecord.this.connectableResource.getConnection();
                            connection.setAutoCommit(false);
                            String sql = "DELETE from " + CommitMarkableResourceRecord.this.tableName + " where xid in (?)";
                            PreparedStatement prepareStatement = connection.prepareStatement(sql);
                            try {
                                XID toSave = ((XidImple)xid).getXID();
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                DataOutputStream dos = new DataOutputStream(baos);
                                dos.writeInt(toSave.formatID);
                                dos.writeInt(toSave.gtrid_length);
                                dos.writeInt(toSave.bqual_length);
                                dos.writeInt(toSave.data.length);
                                dos.write(toSave.data);
                                dos.flush();
                                prepareStatement.setBytes(1, baos.toByteArray());
                                if (prepareStatement.executeUpdate() != 1) {
                                    tsLogger.logger.error((Object)"Update was not successfull");
                                    connection.rollback();
                                } else {
                                    connection.commit();
                                }
                            }
                            catch (IOException e) {
                                tsLogger.logger.warn((Object)"Could not generate prepareStatement paramaters", (Throwable)e);
                            }
                            finally {
                                try {
                                    prepareStatement.close();
                                }
                                catch (SQLException e) {
                                    tsLogger.logger.warn((Object)"Could not close the prepared statement", (Throwable)e);
                                }
                            }
                        }
                        catch (Throwable e1) {
                            tsLogger.logger.warn((Object)"Could not delete CommitMarkableResourceRecord entry, will rely on RecoveryModule", e1);
                        }
                        finally {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (SQLException e) {
                                    tsLogger.logger.warn((Object)"Could not close the preparedConnection", (Throwable)e);
                                }
                            }
                        }
                    }
                }
            });
        } else if (isNotifyRecoveryModuleOfCompletedBranches) {
            new TransactionSynchronizationRegistryImple().registerInterposedSynchronization(new Synchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int status) {
                    if (!CommitMarkableResourceRecord.this.onePhase && status == 3) {
                        commitMarkableResourceRecoveryModule.notifyOfCompletedBranch(CommitMarkableResourceRecord.this.commitMarkableJndiName, xid);
                    }
                }
            });
        }
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getJndiName() {
        return this.commitMarkableJndiName;
    }

    public void updateOutcome(boolean committed) {
        this.hasCompleted = true;
        this.committed = committed;
    }

    @Override
    public boolean doSave() {
        return true;
    }

    @Override
    public boolean save_state(OutputObjectState os, int t) {
        boolean res = false;
        try {
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("pack: " + this.commitMarkableJndiName));
            }
            os.packString(this.commitMarkableJndiName);
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("pack: " + this.xid));
            }
            XidImple.pack(os, this.xid);
            os.packBoolean(this.hasCompleted);
            if (this.hasCompleted) {
                os.packBoolean(this.committed);
            }
            os.packString(this.productName);
            os.packString(this.productVersion);
            res = super.save_state(os, t);
        }
        catch (Exception e) {
            jtaLogger.logger.warn((Object)("Could not save_state: " + XAHelper.xidToString(this.xid)), (Throwable)e);
        }
        return res;
    }

    @Override
    public boolean restore_state(InputObjectState os, int t) {
        boolean res = false;
        try {
            this.commitMarkableJndiName = os.unpackString();
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("unpack: " + this.commitMarkableJndiName));
            }
            this.xid = XidImple.unpack(os);
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("unpack: " + this.xid));
            }
            this.committed = os.unpackBoolean() ? os.unpackBoolean() : commitMarkableResourceRecoveryModule.wasCommitted(this.commitMarkableJndiName, this.xid);
            this.productName = os.unpackString();
            this.productVersion = os.unpackString();
            res = super.restore_state(os, t);
        }
        catch (Exception e) {
            jtaLogger.logger.warn((Object)("Could not restore_state" + XAHelper.xidToString(this.xid)), (Throwable)e);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int topLevelPrepare() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("CommitMarkableResourceRecord.topLevelPrepare for " + this + ", record id=" + this.order()));
        }
        try {
            this.preparedConnection = (Connection)this.connectableResource.getConnection();
            try (Statement prepareStatement = null;){
                prepareStatement = this.preparedConnection.prepareStatement("insert into " + this.tableName + " (xid, transactionManagerID, actionuid) values (?,?,?)");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                XID toSave = ((XidImple)this.xid).getXID();
                dos.writeInt(toSave.formatID);
                dos.writeInt(toSave.gtrid_length);
                dos.writeInt(toSave.bqual_length);
                dos.writeInt(toSave.data.length);
                dos.write(toSave.data);
                dos.flush();
                prepareStatement.setBytes(1, baos.toByteArray());
                prepareStatement.setString(2, TxControl.getXANodeName());
                prepareStatement.setBytes(3, this.basicAction.get_uid().getBytes());
                if (prepareStatement.executeUpdate() == 1) return 0;
                tsLogger.logger.warn((Object)"Update was not successful");
                this.removeConnection();
                int n = 1;
                return n;
            }
        }
        catch (Throwable t) {
            tsLogger.logger.error((Object)"Could not add recovery data to the 1PC resource", t);
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int topLevelAbort() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("CommitMarkableResourceRecord.topLevelAbort for " + this + ", record id=" + this.order()));
        }
        try {
            ((XAResource)this.connectableResource).rollback(this.xid);
            this.hasCompleted = true;
            this.committed = false;
            int n = 7;
            return n;
        }
        catch (XAException e) {
            XAResourceErrorHandler handler = new XAResourceErrorHandler(e, (XAResource)this.connectableResource, this.xid);
            int n = handler.handleCMRRollbackError();
            return n;
        }
        catch (Throwable e) {
            jtaLogger.i18NLogger.warn_resources_arjunacore_rollbackerror(XAHelper.xidToString(this.xid), this.connectableResource.toString(), "-", e);
            int n = 8;
            return n;
        }
        finally {
            this.removeConnection();
        }
    }

    @Override
    public int topLevelCommit() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("CommitMarkableResourceRecord.topLevelCommit for " + this + ", record id=" + this.order()));
        }
        return this.commit(false);
    }

    @Override
    public int topLevelOnePhaseCommit() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("CommitMarkableResourceRecord.topLevelOnePhaseCommit for " + this + ", record id=" + this.order()));
        }
        return this.commit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int commit(boolean onePhase) {
        this.onePhase = onePhase;
        if (this.connectableResource != null) {
            try {
                ((XAResource)this.connectableResource).commit(this.xid, false);
                this.hasCompleted = true;
                this.committed = true;
                int n = 7;
                return n;
            }
            catch (XAException e) {
                XAResourceErrorHandler handler = new XAResourceErrorHandler(e, (XAResource)this.connectableResource, this.xid);
                int res = handler.handleCMRCommitError(onePhase);
                this.committed = handler.isCommitted();
                int n = res;
                return n;
            }
            catch (Throwable e) {
                jtaLogger.i18NLogger.warn_resources_arjunacore_commitxaerror(XAHelper.xidToString(this.xid), this.connectableResource.toString(), "-", e);
                int n = 8;
                return n;
            }
            finally {
                if (!this.isPerformImmediateCleanupOfBranches) {
                    this.removeConnection();
                }
            }
        }
        if (this.committed) {
            return 7;
        }
        return 3;
    }

    private final void removeConnection() {
        if (this.preparedConnection != null) {
            try {
                this.preparedConnection.close();
                this.preparedConnection = null;
            }
            catch (SQLException e) {
                tsLogger.logger.warn((Object)"Could not close the preparedConnection", (Throwable)e);
            }
        }
    }

    @Override
    public Uid order() {
        return Uid.minUid();
    }

    @Override
    public boolean propagateOnCommit() {
        return false;
    }

    @Override
    public int typeIs() {
        return 50;
    }

    @Override
    public String type() {
        return "/StateManager/AbstractRecord/CommitMarkableResourceRecord";
    }

    @Override
    public Object value() {
        return this.connectableResource;
    }

    @Override
    public void setValue(Object o) {
    }

    @Override
    public int nestedAbort() {
        return 7;
    }

    @Override
    public int nestedCommit() {
        return 8;
    }

    @Override
    public int nestedPrepare() {
        return 1;
    }

    @Override
    public void merge(AbstractRecord a) {
    }

    @Override
    public void alter(AbstractRecord a) {
    }

    @Override
    public boolean shouldAdd(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldAlter(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldMerge(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldReplace(AbstractRecord a) {
        return false;
    }

    static {
        jtaEnvironmentBean = BeanPopulator.getDefaultInstance(JTAEnvironmentBean.class);
        commitMarkableResourceTableNameMap = jtaEnvironmentBean.getCommitMarkableResourceTableNameMap();
        defaultTableName = jtaEnvironmentBean.getDefaultCommitMarkableTableName();
        isNotifyRecoveryModuleOfCompletedBranches = jtaEnvironmentBean.isNotifyCommitMarkableResourceRecoveryModuleOfCompleteBranches();
        isPerformImmediateCleanupOfCommitMarkableResourceBranchesMap = jtaEnvironmentBean.getPerformImmediateCleanupOfCommitMarkableResourceBranchesMap();
        commitMarkableResourceRecoveryModule = null;
        RecoveryManager recMan = RecoveryManager.manager();
        Vector<RecoveryModule> recoveryModules = recMan.getModules();
        if (recoveryModules != null) {
            Enumeration<RecoveryModule> modules = recoveryModules.elements();
            while (modules.hasMoreElements()) {
                RecoveryModule m = modules.nextElement();
                if (!(m instanceof CommitMarkableResourceRecordRecoveryModule)) continue;
                commitMarkableResourceRecoveryModule = (CommitMarkableResourceRecordRecoveryModule)m;
                break;
            }
        }
    }
}

