/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.util;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.connector.deployers.ra.processors.AbstractResourceAdapterDeploymentServiceListener;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.services.mdr.AS7MetadataRepository;
import org.jboss.as.connector.services.resourceadapters.deployment.ResourceAdapterXmlDeploymentService;
import org.jboss.as.connector.services.resourceadapters.deployment.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.SubjectFactory;

public class RaServicesFactory {
    public static void createDeploymentService(ManagementResourceRegistration registration, ConnectorXmlDescriptor connectorXmlDescriptor, Module module, ServiceTarget serviceTarget, String deploymentUnitName, ServiceName deploymentUnitServiceName, String deployment, Activation raxml, Resource deploymentResource, ServiceVerificationHandler serviceVerificationHandler) {
        ServiceName serviceName = ConnectorServices.getDeploymentServiceName(deploymentUnitName, raxml);
        ResourceAdapterXmlDeploymentService service = new ResourceAdapterXmlDeploymentService(connectorXmlDescriptor, raxml, module, deployment, serviceName, deploymentUnitServiceName);
        String bootStrapCtxName = "default";
        if (raxml.getBootstrapContext() != null && !raxml.getBootstrapContext().equals("undefined")) {
            bootStrapCtxName = raxml.getBootstrapContext();
        }
        ServiceBuilder builder = Services.addServerExecutorDependency((ServiceBuilder)serviceTarget.addService(serviceName, (Service)service), service.getExecutorServiceInjector(), (boolean)false).addDependency(ConnectorServices.IRONJACAMAR_MDR, AS7MetadataRepository.class, service.getMdrInjector()).addDependency(ConnectorServices.RA_REPOSITORY_SERVICE, ResourceAdapterRepository.class, service.getRaRepositoryInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSITORY_SERVICE, ManagementRepository.class, service.getManagementRepositoryInjector()).addDependency(ConnectorServices.RESOURCE_ADAPTER_REGISTRY_SERVICE, ResourceAdapterDeploymentRegistry.class, service.getRegistryInjector()).addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, service.getTxIntegrationInjector()).addDependency(ConnectorServices.CONNECTOR_CONFIG_SERVICE, JcaSubsystemConfiguration.class, service.getConfigInjector()).addDependency(SubjectFactoryService.SERVICE_NAME, SubjectFactory.class, service.getSubjectFactoryInjector()).addDependency(ConnectorServices.CCM_SERVICE, CachedConnectionManager.class, service.getCcmInjector()).addDependency(ConnectorServices.IDLE_REMOVER_SERVICE).addDependency(ConnectorServices.CONNECTION_VALIDATOR_SERVICE).addDependency(NamingService.SERVICE_NAME).addDependency(ConnectorServices.BOOTSTRAP_CONTEXT_SERVICE.append(new String[]{bootStrapCtxName})).addDependency(ConnectorServices.RESOURCE_ADAPTER_DEPLOYER_SERVICE_PREFIX.append(new String[]{connectorXmlDescriptor.getDeploymentName()}));
        if (serviceVerificationHandler != null) {
            builder.addListener((ServiceListener)serviceVerificationHandler);
        }
        if (registration != null && deploymentResource != null) {
            String bootstrapCtxName;
            String string = bootstrapCtxName = raxml.getBootstrapContext() != null ? raxml.getBootstrapContext() : "default";
            if (registration.isAllowsOverride() && registration.getOverrideModel(deploymentUnitName) == null) {
                registration.registerOverrideModel(deploymentUnitName, new OverrideDescriptionProvider(){

                    public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
                        return Collections.emptyMap();
                    }

                    public Map<String, ModelNode> getChildTypeOverrideDescriptions(Locale locale) {
                        return Collections.emptyMap();
                    }
                });
            }
            builder.addListener((ServiceListener)new AbstractResourceAdapterDeploymentServiceListener(registration, deploymentUnitName, deploymentResource, bootstrapCtxName, raxml.getId()){

                @Override
                protected void registerIronjacamar(ServiceController<? extends Object> controller, ManagementResourceRegistration subRegistration, Resource subsystemResource) {
                }

                @Override
                protected CommonDeployment getDeploymentMetadata(ServiceController<? extends Object> controller) {
                    return ((ResourceAdapterXmlDeploymentService)controller.getService()).getRaxmlDeployment();
                }
            });
        }
        builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }
}

