/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.as.clustering.infinispan.subsystem.GlobalComponentRegistryService;
import org.jboss.as.clustering.jgroups.subsystem.ChannelService;
import org.jboss.as.clustering.marshalling.DynamicClassTable;
import org.jboss.as.clustering.marshalling.MarshallingConfigurationFactory;
import org.jboss.as.clustering.marshalling.MarshallingContext;
import org.jboss.as.clustering.marshalling.SimpleMarshallingContextFactory;
import org.jboss.as.clustering.marshalling.VersionedMarshallingConfiguration;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.as.server.Services;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.server.dispatcher.ChannelCommandDispatcherFactory;
import org.wildfly.clustering.server.dispatcher.ChannelCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.group.ChannelNodeFactory;
import org.wildfly.clustering.spi.ChannelServiceNames;

public class ChannelCommandDispatcherFactoryService
implements Service<CommandDispatcherFactory>,
ChannelCommandDispatcherFactoryConfiguration,
VersionedMarshallingConfiguration {
    private static final int CURRENT_VERSION = 1;
    private final Map<Integer, MarshallingConfiguration> configurations = new HashMap<Integer, MarshallingConfiguration>();
    private final InjectedValue<Channel> channel = new InjectedValue();
    private final InjectedValue<Group> group = new InjectedValue();
    private final InjectedValue<ChannelNodeFactory> nodeFactory = new InjectedValue();
    private final InjectedValue<ModuleLoader> loader = new InjectedValue();
    private final ModuleIdentifier identifier;
    private final long timeout = TimeUnit.MINUTES.toMillis(1L);
    private volatile MarshallingContext marshallingContext = null;
    private volatile ChannelCommandDispatcherFactory factory = null;

    public static ServiceBuilder<CommandDispatcherFactory> build(ServiceTarget target, ServiceName name, String cluster, ModuleIdentifier identifier) {
        ChannelCommandDispatcherFactoryService service = new ChannelCommandDispatcherFactoryService(identifier);
        return AsynchronousService.addService((ServiceTarget)target, (ServiceName)name, (Service)service).addDependency(GlobalComponentRegistryService.getServiceName((String)cluster)).addDependency(ChannelServiceNames.GROUP.getServiceName(cluster), Group.class, service.group).addDependency(ChannelServiceNames.NODE_FACTORY.getServiceName(cluster), ChannelNodeFactory.class, service.nodeFactory).addDependency(ChannelService.getServiceName((String)cluster), Channel.class, service.channel).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, service.loader);
    }

    private ChannelCommandDispatcherFactoryService(ModuleIdentifier identifier) {
        this.identifier = identifier;
    }

    public void start(StartContext context) throws StartException {
        ModuleLoader loader = (ModuleLoader)this.loader.getValue();
        MarshallingConfiguration config = MarshallingConfigurationFactory.createMarshallingConfiguration((ModuleLoader)loader);
        try {
            Module module = loader.loadModule(this.identifier);
            config.setClassTable((ClassTable)new DynamicClassTable((ClassLoader)module.getClassLoader()));
            this.configurations.put(1, config);
            this.marshallingContext = new SimpleMarshallingContextFactory().createMarshallingContext((VersionedMarshallingConfiguration)this, (ClassLoader)module.getClassLoader());
        }
        catch (ModuleLoadException e) {
            throw new StartException((Throwable)e);
        }
        this.factory = new ChannelCommandDispatcherFactory(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        try {
            this.factory.close();
            this.factory = null;
            this.marshallingContext = null;
        }
        finally {
            this.configurations.clear();
        }
    }

    public CommandDispatcherFactory getValue() {
        return this.factory;
    }

    @Override
    public Group getGroup() {
        return (Group)this.group.getValue();
    }

    @Override
    public Channel getChannel() {
        return (Channel)this.channel.getValue();
    }

    @Override
    public NodeFactory<Address> getNodeFactory() {
        return (NodeFactory)this.nodeFactory.getValue();
    }

    @Override
    public MarshallingContext getMarshallingContext() {
        return this.marshallingContext;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    public int getCurrentMarshallingVersion() {
        return 1;
    }

    public MarshallingConfiguration getMarshallingConfiguration(int version) {
        MarshallingConfiguration configuration = this.configurations.get(version);
        if (configuration == null) {
            throw new IllegalArgumentException(Integer.toString(version));
        }
        return configuration;
    }
}

