/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.GlobalComponentRegistryService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.server.group.ChannelGroup;
import org.wildfly.clustering.server.group.ChannelGroupConfiguration;
import org.wildfly.clustering.server.group.ChannelNodeFactory;
import org.wildfly.clustering.spi.ChannelServiceNames;

public class ChannelGroupService
implements Service<Group>,
ChannelGroupConfiguration {
    private final InjectedValue<EmbeddedCacheManager> manager = new InjectedValue();
    private final InjectedValue<ChannelNodeFactory> factory = new InjectedValue();
    private volatile ChannelGroup group;

    public static ServiceBuilder<Group> build(ServiceTarget target, ServiceName name, String cluster) {
        ChannelGroupService service = new ChannelGroupService();
        return target.addService(name, (Service)service).addDependency(GlobalComponentRegistryService.getServiceName((String)cluster)).addDependency(EmbeddedCacheManagerService.getServiceName((String)cluster), EmbeddedCacheManager.class, service.manager).addDependency(ChannelServiceNames.NODE_FACTORY.getServiceName(cluster), ChannelNodeFactory.class, service.factory);
    }

    public Group getValue() {
        return this.group;
    }

    public void start(StartContext context) {
        this.group = new ChannelGroup(this);
    }

    public void stop(StopContext context) {
        this.group.close();
        this.group = null;
    }

    @Override
    public EmbeddedCacheManager getCacheContainer() {
        return (EmbeddedCacheManager)this.manager.getValue();
    }

    @Override
    public ChannelNodeFactory getNodeFactory() {
        return (ChannelNodeFactory)this.factory.getValue();
    }
}

