/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.group.ChannelNodeFactory;
import org.wildfly.clustering.server.group.LocalGroup;
import org.wildfly.clustering.spi.ChannelServiceNames;

public class LocalGroupService
implements Service<Group> {
    private final String name;
    private final InjectedValue<ChannelNodeFactory> factory = new InjectedValue();
    private volatile Group group;

    public static ServiceBuilder<Group> build(ServiceTarget target, ServiceName name, String cluster) {
        LocalGroupService service = new LocalGroupService(cluster);
        return target.addService(name, (Service)service).addDependency(ChannelServiceNames.NODE_FACTORY.getServiceName(cluster), ChannelNodeFactory.class, service.factory);
    }

    private LocalGroupService(String name) {
        this.name = name;
    }

    public Group getValue() {
        return this.group;
    }

    public void start(StartContext context) throws StartException {
        ChannelNodeFactory factory = (ChannelNodeFactory)this.factory.getValue();
        Node node = factory.createNode(null);
        this.group = new LocalGroup(this.name, node);
    }

    public void stop(StopContext context) {
        this.group = null;
    }
}

