/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.server.group.ChannelNodeFactory;
import org.wildfly.clustering.server.group.LocalNodeFactory;

public class LocalNodeFactoryService
implements Service<ChannelNodeFactory> {
    private final InjectedValue<ServerEnvironment> environment = new InjectedValue();
    private final String cluster;
    private volatile ChannelNodeFactory factory;

    public static ServiceBuilder<ChannelNodeFactory> build(ServiceTarget target, ServiceName name, String cluster) {
        LocalNodeFactoryService service = new LocalNodeFactoryService(cluster);
        return target.addService(name, (Service)service).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.environment);
    }

    private LocalNodeFactoryService(String cluster) {
        this.cluster = cluster;
    }

    public ChannelNodeFactory getValue() {
        return this.factory;
    }

    public void start(StartContext context) throws StartException {
        this.factory = new LocalNodeFactory(this.cluster, (ServerEnvironment)this.environment.getValue());
    }

    public void stop(StopContext context) {
        this.factory = null;
    }
}

