/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.provider;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.provider.ServiceProviderRegistration;
import org.wildfly.clustering.provider.ServiceProviderRegistrationFactory;
import org.wildfly.clustering.server.provider.AbstractServiceProviderRegistration;
import org.wildfly.clustering.server.provider.CacheServiceProviderRegistrationFactoryConfiguration;
import org.wildfly.clustering.server.provider.ServiceRegistry;
import org.wildfly.clustering.server.provider.ServiceRegistryCommand;

@Listener
public class CacheServiceProviderRegistrationFactory
implements ServiceProviderRegistrationFactory,
ServiceRegistry,
Group.Listener,
AutoCloseable {
    final ConcurrentMap<Object, ServiceProviderRegistration.Listener> listeners = new ConcurrentHashMap<Object, ServiceProviderRegistration.Listener>();
    final Batcher<? extends Batch> batcher;
    final Cache<Object, Set<Node>> cache;
    private final Group group;
    private final CommandDispatcher<ServiceRegistry> dispatcher;

    public CacheServiceProviderRegistrationFactory(CacheServiceProviderRegistrationFactoryConfiguration config) {
        this.group = config.getGroup();
        this.cache = config.getCache();
        this.batcher = config.getBatcher();
        this.dispatcher = config.getCommandDispatcherFactory().createCommandDispatcher(config.getId(), (Object)this);
        this.cache.addListener((Object)this);
        this.group.addListener((Group.Listener)this);
    }

    @Override
    public void close() {
        this.group.removeListener((Group.Listener)this);
        this.cache.removeListener((Object)this);
        this.dispatcher.close();
    }

    public Group getGroup() {
        return this.group;
    }

    public ServiceProviderRegistration createRegistration(final Object service, ServiceProviderRegistration.Listener listener) {
        if (this.listeners.putIfAbsent(service, listener) != null) {
            throw new IllegalArgumentException(service.toString());
        }
        Node node = this.group.getLocalNode();
        HashSet<Node> nodes = new HashSet<Node>(Collections.singleton(node));
        try (Batch batch = this.batcher.createBatch();){
            Set existing = (Set)this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent(service, nodes);
            if (existing != null && existing.add(node)) {
                this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).replace(service, (Object)existing);
            }
        }
        return new AbstractServiceProviderRegistration(service, this){

            public void close() {
                if (CacheServiceProviderRegistrationFactory.this.listeners.remove(service) != null) {
                    Node node = CacheServiceProviderRegistrationFactory.this.getGroup().getLocalNode();
                    try (Batch batch = CacheServiceProviderRegistrationFactory.this.batcher.createBatch();){
                        Set nodes = (Set)CacheServiceProviderRegistrationFactory.this.cache.get(service);
                        if (nodes != null && nodes.remove(node)) {
                            AdvancedCache cache = CacheServiceProviderRegistrationFactory.this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES});
                            if (nodes.isEmpty()) {
                                cache.remove(service);
                            } else {
                                cache.replace(service, (Object)nodes);
                            }
                        }
                    }
                }
            }
        };
    }

    public Set<Node> getProviders(Object service) {
        Set nodes = (Set)this.cache.get(service);
        return nodes != null ? Collections.unmodifiableSet(nodes) : Collections.emptySet();
    }

    @Override
    public Set<Object> getServices() {
        return this.listeners.keySet();
    }

    public void membershipChanged(List<Node> previousMembers, List<Node> members, boolean merged) {
        if (this.getGroup().isCoordinator()) {
            HashSet<Node> deadNodes = new HashSet<Node>(previousMembers);
            deadNodes.removeAll(members);
            HashSet<Node> newNodes = new HashSet<Node>(members);
            newNodes.removeAll(previousMembers);
            try (Batch batch = this.batcher.createBatch();){
                if (!deadNodes.isEmpty()) {
                    for (Object service : this.cache.keySet()) {
                        Set nodes = (Set)this.cache.get(service);
                        if (nodes == null || !nodes.removeAll(deadNodes)) continue;
                        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).replace(service, (Object)nodes);
                    }
                }
                if (merged) {
                    for (Node node : newNodes) {
                        List<Object> services = this.getServices(node);
                        for (Object service : services) {
                            HashSet<Node> nodes = new HashSet<Node>(Collections.singleton(node));
                            Set existing = (Set)this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent(service, nodes);
                            if (existing == null || !existing.add(node)) continue;
                            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).replace(service, (Object)existing);
                        }
                    }
                }
            }
        }
    }

    @CacheEntryModified
    public void modified(CacheEntryModifiedEvent<ServiceName, Set<Node>> event) {
        if (event.isPre()) {
            return;
        }
        ServiceProviderRegistration.Listener listener = (ServiceProviderRegistration.Listener)this.listeners.get(event.getKey());
        if (listener != null) {
            listener.providersChanged((Set)event.getValue());
        }
    }

    List<Object> getServices(Node node) {
        try {
            return (List)this.dispatcher.executeOnNode((Command)new ServiceRegistryCommand(), node).get();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }
}

