/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.provider;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.provider.ServiceProviderRegistration;
import org.wildfly.clustering.provider.ServiceProviderRegistrationFactory;
import org.wildfly.clustering.server.provider.AbstractServiceProviderRegistration;
import org.wildfly.clustering.spi.CacheServiceNames;

public class LocalServiceProviderRegistrationFactoryService
extends AbstractService<ServiceProviderRegistrationFactory>
implements ServiceProviderRegistrationFactory {
    final Set<Object> services = Collections.synchronizedSet(new HashSet());
    private final InjectedValue<Group> group = new InjectedValue();

    public static ServiceBuilder<ServiceProviderRegistrationFactory> build(ServiceTarget target, ServiceName name, String containerName, String cacheName) {
        LocalServiceProviderRegistrationFactoryService service = new LocalServiceProviderRegistrationFactoryService();
        return target.addService(name, (Service)service).addDependency(CacheServiceNames.GROUP.getServiceName(containerName, cacheName), Group.class, service.group);
    }

    private LocalServiceProviderRegistrationFactoryService() {
    }

    public ServiceProviderRegistrationFactory getValue() {
        return this;
    }

    public Group getGroup() {
        return (Group)this.group.getValue();
    }

    public ServiceProviderRegistration createRegistration(final Object service, ServiceProviderRegistration.Listener listener) {
        this.services.add(service);
        return new AbstractServiceProviderRegistration(service, this){

            public void close() {
                LocalServiceProviderRegistrationFactoryService.this.services.remove(service);
            }
        };
    }

    public Set<Node> getProviders(Object service) {
        return this.services.contains(service) ? Collections.singleton(this.getGroup().getLocalNode()) : Collections.emptySet();
    }
}

