/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.clustering.naming.JndiNameFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.registry.RegistryFactory;
import org.wildfly.clustering.server.registry.RegistryService;
import org.wildfly.clustering.spi.CacheServiceNames;
import org.wildfly.clustering.spi.ServiceInstaller;

public abstract class AbstractRegistryFactoryServiceInstaller
implements ServiceInstaller {
    private final Logger logger = Logger.getLogger(this.getClass());

    private static ContextNames.BindInfo createBinding(String group) {
        return ContextNames.bindInfoFor((String)JndiNameFactory.createJndiName((String)"java:jboss", (String[])new String[]{"clustering", "registry", group, "default"}).getAbsoluteName());
    }

    public Collection<ServiceName> getServiceNames(String group) {
        return Arrays.asList(CacheServiceNames.REGISTRY.getServiceName(group), CacheServiceNames.REGISTRY_FACTORY.getServiceName(group), AbstractRegistryFactoryServiceInstaller.createBinding(group).getBinderServiceName());
    }

    public Collection<ServiceController<?>> install(ServiceTarget target, String group, ModuleIdentifier moduleId) {
        ServiceName name = CacheServiceNames.REGISTRY_FACTORY.getServiceName(group);
        ContextNames.BindInfo bindInfo = AbstractRegistryFactoryServiceInstaller.createBinding(group);
        this.logger.debugf("Installing %s service, bound to ", (Object)name.getCanonicalName(), (Object)bindInfo.getAbsoluteJndiName());
        ServiceBuilder<RegistryFactory<Object, Object>> factoryBuilder = this.build(target, name, group, "default");
        ServiceController factoryController = factoryBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        ServiceBuilder builder = RegistryService.build(target, group, "default");
        ServiceController controller = builder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        ServiceBuilder binderBuilder = new BinderServiceBuilder(target).build(bindInfo, name, RegistryFactory.class);
        return Arrays.asList(factoryController, controller, binderBuilder.install());
    }

    protected abstract ServiceBuilder<RegistryFactory<Object, Object>> build(ServiceTarget var1, ServiceName var2, String var3, String var4);
}

