/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.registry.RegistryEntryProvider;
import org.wildfly.clustering.server.registry.CacheRegistryFactoryConfiguration;

@Listener
public class CacheRegistry<K, V>
implements Registry<K, V> {
    private final List<Registry.Listener<K, V>> listeners = new CopyOnWriteArrayList<Registry.Listener<K, V>>();
    private final RegistryEntryProvider<K, V> provider;
    private final Cache<Node, Map.Entry<K, V>> cache;
    private final Batcher<? extends Batch> batcher;
    private final Group group;
    private final NodeFactory<Address> factory;

    public CacheRegistry(CacheRegistryFactoryConfiguration<K, V> config, RegistryEntryProvider<K, V> provider) {
        this.cache = config.getCache();
        this.batcher = config.getBatcher();
        this.group = config.getGroup();
        this.factory = config.getNodeFactory();
        this.provider = provider;
        this.getLocalEntry();
        this.cache.addListener((Object)this);
    }

    public void close() {
        this.cache.removeListener((Object)this);
        this.listeners.clear();
        Node node = this.getGroup().getLocalNode();
        try (Batch batch = this.batcher.createBatch();){
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)node);
        }
    }

    public void addListener(Registry.Listener<K, V> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Registry.Listener<K, V> listener) {
        this.listeners.remove(listener);
    }

    public Group getGroup() {
        return this.group;
    }

    public Map<K, V> getEntries() {
        HashMap map = new HashMap();
        for (Node node : this.cache.keySet()) {
            Map.Entry entry = (Map.Entry)this.cache.get((Object)node);
            if (entry == null) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    public Map.Entry<K, V> getEntry(Node node) {
        return (Map.Entry)this.cache.get((Object)node);
    }

    public Map.Entry<K, V> getLocalEntry() {
        Object key = this.provider.getKey();
        if (key == null) {
            return null;
        }
        AbstractMap.SimpleImmutableEntry<Object, Object> entry = new AbstractMap.SimpleImmutableEntry<Object, Object>(key, this.provider.getValue());
        Node node = this.getGroup().getLocalNode();
        try (Batch batch = this.batcher.createBatch();){
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)node, entry);
        }
        return entry;
    }

    @TopologyChanged
    public void topologyChanged(TopologyChangedEvent<Address, Node> event) {
        if (event.isPre()) {
            return;
        }
        List newAddresses = event.getConsistentHashAtEnd().getMembers();
        if (!((Address)newAddresses.get(0)).equals(event.getCache().getCacheManager().getAddress())) {
            return;
        }
        HashSet addresses = new HashSet(event.getConsistentHashAtStart().getMembers());
        addresses.removeAll(newAddresses);
        ArrayList<Node> nodes = new ArrayList<Node>(addresses.size());
        for (Address address : addresses) {
            nodes.add(this.factory.createNode((Object)address));
        }
        AdvancedCache cache = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS});
        HashMap removed = new HashMap();
        try (Batch batch = this.batcher.createBatch();){
            for (Node node : nodes) {
                Map.Entry old = (Map.Entry)cache.remove((Object)node);
                if (old == null) continue;
                removed.put(old.getKey(), old.getValue());
            }
        }
        if (!removed.isEmpty()) {
            for (Registry.Listener<K, V> listener : this.listeners) {
                listener.removedEntries(removed);
            }
        }
    }

    @CacheEntryModified
    public void modified(CacheEntryModifiedEvent<Node, Map.Entry<K, V>> event) {
        Map.Entry entry;
        if (event.isOriginLocal() || event.isPre()) {
            return;
        }
        if (!this.listeners.isEmpty() && (entry = (Map.Entry)event.getValue()) != null) {
            Map entries = Collections.singletonMap(entry.getKey(), entry.getValue());
            for (Registry.Listener<K, V> listener : this.listeners) {
                if (event.isCreated()) {
                    listener.addedEntries(entries);
                    continue;
                }
                listener.updatedEntries(entries);
            }
        }
    }

    @CacheEntryRemoved
    public void removed(CacheEntryRemovedEvent<Node, Map.Entry<K, V>> event) {
        if (event.isOriginLocal() || event.isPre()) {
            return;
        }
        Map.Entry entry = (Map.Entry)event.getOldValue();
        if (entry != null) {
            Map entries = Collections.singletonMap(entry.getKey(), entry.getValue());
            for (Registry.Listener<K, V> listener : this.listeners) {
                listener.removedEntries(entries);
            }
        }
    }
}

