/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.registry.RegistryFactory;
import org.wildfly.clustering.server.registry.LocalRegistryFactory;
import org.wildfly.clustering.spi.CacheServiceNames;

public class LocalRegistryFactoryService<K, V>
implements Service<RegistryFactory<K, V>> {
    private final InjectedValue<Group> group = new InjectedValue();
    private volatile RegistryFactory<K, V> factory;

    public static <K, V> ServiceBuilder<RegistryFactory<K, V>> build(ServiceTarget target, ServiceName name, String containerName, String cacheName) {
        LocalRegistryFactoryService<K, V> service = new LocalRegistryFactoryService<K, V>();
        return target.addService(name, service).addDependency(CacheServiceNames.GROUP.getServiceName(containerName, cacheName), Group.class, service.group);
    }

    private LocalRegistryFactoryService() {
    }

    public RegistryFactory<K, V> getValue() {
        return this.factory;
    }

    public void start(StartContext arg0) throws StartException {
        this.factory = new LocalRegistryFactory((Group)this.group.getValue());
    }

    public void stop(StopContext arg0) {
        this.factory = null;
    }
}

