/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.registry.RegistryEntryProvider;
import org.wildfly.clustering.registry.RegistryFactory;
import org.wildfly.clustering.spi.CacheServiceNames;

public class RegistryService<K, V>
implements Service<Registry<K, V>> {
    private final InjectedValue<RegistryFactory<K, V>> factory = new InjectedValue();
    private final InjectedValue<RegistryEntryProvider<K, V>> provider = new InjectedValue();
    private volatile Registry<K, V> registry;

    public static <K, V> ServiceBuilder<Registry<K, V>> build(ServiceTarget target, String containerName, String cacheName) {
        RegistryService<K, V> service = new RegistryService<K, V>();
        return AsynchronousService.addService((ServiceTarget)target, (ServiceName)CacheServiceNames.REGISTRY.getServiceName(containerName, cacheName), service).addDependency(CacheServiceNames.REGISTRY_FACTORY.getServiceName(containerName, cacheName), RegistryFactory.class, service.factory).addDependency(CacheServiceNames.REGISTRY_ENTRY.getServiceName(containerName, cacheName), RegistryEntryProvider.class, service.provider);
    }

    private RegistryService() {
    }

    public Registry<K, V> getValue() {
        return this.registry;
    }

    public void start(StartContext context) {
        this.registry = ((RegistryFactory)this.factory.getValue()).createRegistry((RegistryEntryProvider)this.provider.getValue());
    }

    public void stop(StopContext context) {
        this.registry.close();
    }
}

