/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DefaultAttributeMarshaller;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.KnownModelVersion;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.LoggingOperations;
import org.jboss.as.logging.TransformerResourceDefinition;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logmanager.config.FormatterConfiguration;
import org.jboss.logmanager.config.LogContextConfiguration;

class CustomFormatterResourceDefinition
extends TransformerResourceDefinition {
    public static final ObjectTypeAttributeDefinition CUSTOM_FORMATTER = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"custom-formatter", (AttributeDefinition[])new AttributeDefinition[]{CommonAttributes.CLASS, CommonAttributes.MODULE, CommonAttributes.PROPERTIES}).setAllowExpression(false)).setAllowNull(true).setAttributeMarshaller((AttributeMarshaller)new DefaultAttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (this.isMarshallable(attribute, resourceModel, marshallDefault)) {
                writer.writeStartElement(attribute.getXmlName());
                CommonAttributes.MODULE.marshallAsAttribute(resourceModel, writer);
                CommonAttributes.CLASS.marshallAsAttribute(resourceModel, writer);
                if (resourceModel.hasDefined(CommonAttributes.PROPERTIES.getName())) {
                    CommonAttributes.PROPERTIES.marshallAsElement(resourceModel, writer);
                }
                writer.writeEndElement();
            }
        }

        public boolean isMarshallable(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault) {
            return resourceModel.hasDefined(CommonAttributes.CLASS.getName());
        }
    })).build();
    static final PathElement CUSTOM_FORMATTER_PATH = PathElement.pathElement((String)CUSTOM_FORMATTER.getName());
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.CLASS, CommonAttributes.MODULE, CommonAttributes.PROPERTIES};
    static final OperationStepHandler ADD = new LoggingOperations.LoggingAddOperationStepHandler(){

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : ATTRIBUTES) {
                attribute.validateAndSet(operation, model);
            }
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode model) throws OperationFailedException {
            FormatterConfiguration configuration = logContextConfiguration.getFormatterConfiguration(name);
            if (configuration == null) {
                LoggingLogger.ROOT_LOGGER.tracef("Adding formatter '%s' at '%s'", name, LoggingOperations.getAddress(operation));
                String className = CommonAttributes.CLASS.resolveModelAttribute(context, model).asString();
                ModelNode moduleNameNode = CommonAttributes.MODULE.resolveModelAttribute(context, model);
                String moduleName = moduleNameNode.isDefined() ? moduleNameNode.asString() : null;
                configuration = logContextConfiguration.addFormatterConfiguration(moduleName, className, name, new String[0]);
                ModelNode properties = CommonAttributes.PROPERTIES.resolveModelAttribute(context, operation);
                if (properties.isDefined()) {
                    for (Property property : properties.asPropertyList()) {
                        configuration.setPropertyValueString(property.getName(), property.getValue().asString());
                    }
                }
            }
        }
    };
    static final OperationStepHandler WRITE = new LoggingOperations.LoggingWriteAttributeHandler(ATTRIBUTES){

        @Override
        protected boolean applyUpdate(OperationContext context, String attributeName, String addressName, ModelNode value, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            block4: {
                FormatterConfiguration configuration = logContextConfiguration.getFormatterConfiguration(addressName);
                if (!CommonAttributes.PROPERTIES.getName().equals(attributeName)) break block4;
                if (value.isDefined()) {
                    for (Property property : value.asPropertyList()) {
                        configuration.setPropertyValueString(property.getName(), property.getValue().asString());
                    }
                } else {
                    List names = configuration.getPropertyNames();
                    for (String name : names) {
                        configuration.removeProperty(name);
                    }
                }
            }
            return CommonAttributes.CLASS.getName().equals(attributeName) || CommonAttributes.MODULE.getName().equals(attributeName);
        }
    };
    static final OperationStepHandler REMOVE = new LoggingOperations.LoggingRemoveOperationStepHandler(){

        @Override
        protected void performRemove(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode model) throws OperationFailedException {
            context.removeResource(PathAddress.EMPTY_ADDRESS);
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode model) throws OperationFailedException {
            FormatterConfiguration configuration = logContextConfiguration.getFormatterConfiguration(name);
            if (configuration == null) {
                throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.formatterNotFound(name));
            }
            logContextConfiguration.removeFormatterConfiguration(name);
        }
    };
    static final CustomFormatterResourceDefinition INSTANCE = new CustomFormatterResourceDefinition();

    public CustomFormatterResourceDefinition() {
        super(CUSTOM_FORMATTER_PATH, (ResourceDescriptionResolver)LoggingExtension.getResourceDescriptionResolver(CUSTOM_FORMATTER.getName()), ADD, REMOVE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition def : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(def, null, WRITE);
        }
    }

    @Override
    public void registerTransformers(KnownModelVersion modelVersion, ResourceTransformationDescriptionBuilder rootResourceBuilder, ResourceTransformationDescriptionBuilder loggingProfileBuilder) {
        switch (modelVersion) {
            case VERSION_1_3_0: {
                rootResourceBuilder.rejectChildResource(CUSTOM_FORMATTER_PATH);
                loggingProfileBuilder.rejectChildResource(CUSTOM_FORMATTER_PATH);
            }
        }
    }
}

