/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.repository;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jberet._private.BatchMessages;
import org.jberet.repository.AbstractRepository;
import org.jberet.repository.ApplicationAndJobName;
import org.jberet.repository.TableColumns;
import org.jberet.runtime.AbstractStepExecution;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.runtime.PartitionExecutionImpl;
import org.jberet.runtime.StepExecutionImpl;
import org.jberet.util.BatchUtil;

public final class MongoRepository
extends AbstractRepository {
    private String dataSourceName;
    private String dbUrl;
    private MongoClient mongoClient;
    private DB db;
    private DBCollection seqCollection;

    public static MongoRepository create(Properties configProperties) {
        return new MongoRepository(configProperties);
    }

    /*
     * Unable to fully structure code
     */
    public MongoRepository(Properties configProperties) {
        super();
        this.dataSourceName = configProperties.getProperty("datasource-jndi");
        this.dbUrl = configProperties.getProperty("db-url");
        if (this.dataSourceName != null) {
            this.dataSourceName = this.dataSourceName.trim();
        }
        if (this.dataSourceName != null && !this.dataSourceName.isEmpty()) {
            try {
                this.mongoClient = (MongoClient)InitialContext.doLookup(this.dataSourceName);
                var2_2 = this.mongoClient.getUsedDatabases().iterator();
                if (!var2_2.hasNext()) ** GOTO lbl24
                this.db = d = (DB)var2_2.next();
            }
            catch (NamingException e) {
                throw BatchMessages.MESSAGES.failToLookupDataSource(e, this.dataSourceName);
            }
        } else if (this.dbUrl != null) {
            this.dbUrl = this.dbUrl.trim();
            try {
                uri = new MongoClientURI(this.dbUrl);
                this.mongoClient = (MongoClient)Mongo.Holder.singleton().connect(uri);
                this.db = this.mongoClient.getDB(uri.getDatabase());
            }
            catch (Exception e) {
                throw BatchMessages.MESSAGES.invalidConfigProperty(e, "db-url", this.dbUrl);
            }
        }
lbl24:
        // 5 sources

        if (!this.db.collectionExists("seq")) {
            this.seqCollection = this.db.createCollection("seq", null);
            jobInstanceDbo = new BasicDBObject("_id", (Object)"JOBINSTANCEID");
            jobInstanceDbo.put("seq", (Object)1L);
            jobExecutionDbo = new BasicDBObject("_id", (Object)"JOBEXECUTIONID");
            jobExecutionDbo.put("seq", (Object)1L);
            stepExecutionDbo = new BasicDBObject("_id", (Object)"STEPEXECUTIONID");
            stepExecutionDbo.put("seq", (Object)1L);
            this.seqCollection.insert(new DBObject[]{jobInstanceDbo, jobExecutionDbo, stepExecutionDbo});
        } else {
            this.seqCollection = this.db.getCollection("seq");
        }
    }

    @Override
    public List<StepExecution> getStepExecutions(long jobExecutionId) {
        List<StepExecution> stepExecutions = super.getStepExecutions(jobExecutionId);
        if (stepExecutions.isEmpty()) {
            stepExecutions = this.selectStepExecutions(jobExecutionId);
        }
        return stepExecutions;
    }

    @Override
    void insertJobInstance(JobInstanceImpl jobInstance) {
        Long nextId = this.incrementAndGetSequence("JOBINSTANCEID");
        jobInstance.setId(nextId);
        BasicDBObject dbObject = new BasicDBObject("JOBINSTANCEID", (Object)nextId);
        dbObject.put("JOBNAME", (Object)jobInstance.getJobName());
        dbObject.put("APPLICATIONNAME", (Object)jobInstance.getApplicationName());
        this.db.getCollection("JOB_INSTANCE").insert(new DBObject[]{dbObject});
    }

    @Override
    public List<JobInstance> getJobInstances(String jobName) {
        DBCursor cursor;
        ArrayList<JobInstance> result = new ArrayList<JobInstance>();
        DBCursor dBCursor = cursor = jobName == null ? this.db.getCollection("JOB_INSTANCE").find() : this.db.getCollection("JOB_INSTANCE").find((DBObject)new BasicDBObject("JOBNAME", (Object)jobName));
        while (cursor.hasNext()) {
            DBObject next = cursor.next();
            Long i = (Long)next.get("JOBINSTANCEID");
            JobInstanceImpl jobInstance1 = (JobInstanceImpl)this.jobInstances.get(i);
            if (jobInstance1 == null) {
                String appName = (String)next.get("APPLICATIONNAME");
                if (jobName == null) {
                    String goodJobName = (String)next.get("JOBNAME");
                    jobInstance1 = new JobInstanceImpl(this.getJob(goodJobName), new ApplicationAndJobName(appName, goodJobName));
                } else {
                    jobInstance1 = new JobInstanceImpl(this.getJob(jobName), new ApplicationAndJobName(appName, jobName));
                }
                jobInstance1.setId(i);
                this.jobInstances.put(i, jobInstance1);
            }
            result.add(jobInstance1);
        }
        return result;
    }

    @Override
    public JobInstance getJobInstance(long jobInstanceId) {
        JobInstance result = super.getJobInstance(jobInstanceId);
        if (result != null) {
            return result;
        }
        DBObject one = this.db.getCollection("JOB_INSTANCE").findOne((DBObject)new BasicDBObject("JOBINSTANCEID", (Object)jobInstanceId));
        if (one == null) {
            return null;
        }
        result = (JobInstance)this.jobInstances.get(jobInstanceId);
        if (result == null) {
            String appName = (String)one.get("APPLICATIONNAME");
            String goodJobName = (String)one.get("JOBNAME");
            result = new JobInstanceImpl(this.getJob(goodJobName), new ApplicationAndJobName(appName, goodJobName));
            ((JobInstanceImpl)result).setId(jobInstanceId);
            this.jobInstances.put(jobInstanceId, result);
        }
        return result;
    }

    @Override
    public int getJobInstanceCount(String jobName) {
        return (int)this.db.getCollection("JOB_INSTANCE").count((DBObject)new BasicDBObject("JOBNAME", (Object)jobName));
    }

    @Override
    void insertJobExecution(JobExecutionImpl jobExecution) {
        Long nextId = this.incrementAndGetSequence("JOBEXECUTIONID");
        jobExecution.setId(nextId);
        BasicDBObject dbObject = new BasicDBObject("JOBEXECUTIONID", (Object)nextId);
        dbObject.put("JOBINSTANCEID", (Object)jobExecution.getJobInstance().getInstanceId());
        dbObject.put("CREATETIME", (Object)jobExecution.getCreateTime());
        dbObject.put("STARTTIME", (Object)jobExecution.getStartTime());
        dbObject.put("BATCHSTATUS", (Object)jobExecution.getBatchStatus().name());
        dbObject.put("JOBPARAMETERS", (Object)BatchUtil.propertiesToString(jobExecution.getJobParameters()));
        this.db.getCollection("JOB_EXECUTION").insert(new DBObject[]{dbObject});
    }

    @Override
    public void updateJobExecution(JobExecution jobExecution) {
        super.updateJobExecution(jobExecution);
        BasicDBObject update = new BasicDBObject("ENDTIME", (Object)jobExecution.getEndTime());
        update.put("LASTUPDATEDTIME", (Object)jobExecution.getLastUpdatedTime());
        update.put("BATCHSTATUS", (Object)jobExecution.getBatchStatus().name());
        update.put("EXITSTATUS", (Object)jobExecution.getExitStatus());
        update.put("RESTARTPOSITION", (Object)((JobExecutionImpl)jobExecution).getRestartPosition());
        this.db.getCollection("JOB_EXECUTION").update((DBObject)new BasicDBObject("JOBEXECUTIONID", (Object)jobExecution.getExecutionId()), (DBObject)new BasicDBObject("$set", (Object)update));
    }

    @Override
    public JobExecution getJobExecution(long jobExecutionId) {
        JobExecutionImpl result = (JobExecutionImpl)super.getJobExecution(jobExecutionId);
        if (result != null) {
            return result;
        }
        DBObject one = this.db.getCollection("JOB_EXECUTION").findOne((DBObject)new BasicDBObject("JOBEXECUTIONID", (Object)jobExecutionId));
        if (one == null) {
            return null;
        }
        result = (JobExecutionImpl)this.jobExecutions.get(jobExecutionId);
        if (result == null) {
            Long jobInstanceId = (Long)one.get("JOBINSTANCEID");
            result = new JobExecutionImpl((JobInstanceImpl)this.getJobInstance(jobInstanceId), jobExecutionId, BatchUtil.stringToProperties((String)one.get("JOBPARAMETERS")), (Date)one.get("CREATETIME"), (Date)one.get("STARTTIME"), (Date)one.get("ENDTIME"), (Date)one.get("LASTUPDATEDTIME"), (String)one.get("BATCHSTATUS"), (String)one.get("EXITSTATUS"), (String)one.get("RESTARTPOSITION"));
            this.jobExecutions.put(jobExecutionId, result);
        }
        return result;
    }

    @Override
    public List<JobExecution> getJobExecutions(JobInstance jobInstance) {
        long jobInstanceId = jobInstance == null ? 0L : jobInstance.getInstanceId();
        DBCursor cursor = jobInstance == null ? this.db.getCollection("JOB_EXECUTION").find() : this.db.getCollection("JOB_EXECUTION").find((DBObject)new BasicDBObject("JOBINSTANCEID", (Object)jobInstance.getInstanceId()));
        cursor = cursor.sort((DBObject)new BasicDBObject("JOBEXECUTIONID", (Object)1));
        ArrayList<JobExecution> result = new ArrayList<JobExecution>();
        while (cursor.hasNext()) {
            DBObject next = cursor.next();
            Long i = (Long)next.get("JOBEXECUTIONID");
            JobExecution jobExecution1 = (JobExecution)this.jobExecutions.get(i);
            if (jobExecution1 == null) {
                if (jobInstanceId == 0L) {
                    jobInstanceId = (Long)next.get("JOBINSTANCEID");
                }
                Properties jobParameters1 = BatchUtil.stringToProperties((String)next.get("JOBPARAMETERS"));
                jobExecution1 = new JobExecutionImpl((JobInstanceImpl)this.getJobInstance(jobInstanceId), i, jobParameters1, (Date)next.get("CREATETIME"), (Date)next.get("STARTTIME"), (Date)next.get("ENDTIME"), (Date)next.get("LASTUPDATEDTIME"), (String)next.get("BATCHSTATUS"), (String)next.get("EXITSTATUS"), (String)next.get("RESTARTPOSITION"));
                this.jobExecutions.put(i, jobExecution1);
            }
            result.add(jobExecution1);
        }
        return result;
    }

    @Override
    void insertStepExecution(StepExecutionImpl stepExecution, JobExecutionImpl jobExecution) {
        Long nextId = this.incrementAndGetSequence("STEPEXECUTIONID");
        stepExecution.setId(nextId);
        BasicDBObject dbObject = new BasicDBObject("STEPEXECUTIONID", (Object)nextId);
        dbObject.put("JOBEXECUTIONID", (Object)jobExecution.getExecutionId());
        dbObject.put("STEPNAME", (Object)stepExecution.getStepName());
        dbObject.put("STARTTIME", (Object)stepExecution.getStartTime());
        dbObject.put("BATCHSTATUS", (Object)stepExecution.getBatchStatus().name());
        this.db.getCollection("STEP_EXECUTION").insert(new DBObject[]{dbObject});
    }

    @Override
    public void updateStepExecution(StepExecution stepExecution) {
        StepExecutionImpl stepExecutionImpl = (StepExecutionImpl)stepExecution;
        try {
            BasicDBObject update = new BasicDBObject("ENDTIME", (Object)stepExecution.getEndTime());
            update.put("BATCHSTATUS", (Object)stepExecution.getBatchStatus().name());
            update.put("EXITSTATUS", (Object)stepExecution.getExitStatus());
            update.put("EXECUTIONEXCEPTION", (Object)TableColumns.formatException(stepExecutionImpl.getException()));
            update.put("PERSISTENTUSERDATA", (Object)BatchUtil.objectToBytes(stepExecution.getPersistentUserData()));
            update.put("READCOUNT", (Object)stepExecutionImpl.getStepMetrics().get(Metric.MetricType.READ_COUNT));
            update.put("WRITECOUNT", (Object)stepExecutionImpl.getStepMetrics().get(Metric.MetricType.WRITE_COUNT));
            update.put("COMMITCOUNT", (Object)stepExecutionImpl.getStepMetrics().get(Metric.MetricType.COMMIT_COUNT));
            update.put("ROLLBACKCOUNT", (Object)stepExecutionImpl.getStepMetrics().get(Metric.MetricType.ROLLBACK_COUNT));
            update.put("READSKIPCOUNT", (Object)stepExecutionImpl.getStepMetrics().get(Metric.MetricType.READ_SKIP_COUNT));
            update.put("PROCESSSKIPCOUNT", (Object)stepExecutionImpl.getStepMetrics().get(Metric.MetricType.PROCESS_SKIP_COUNT));
            update.put("FILTERCOUNT", (Object)stepExecutionImpl.getStepMetrics().get(Metric.MetricType.FILTER_COUNT));
            update.put("WRITESKIPCOUNT", (Object)stepExecutionImpl.getStepMetrics().get(Metric.MetricType.WRITE_SKIP_COUNT));
            update.put("READERCHECKPOINTINFO", (Object)BatchUtil.objectToBytes(stepExecutionImpl.getReaderCheckpointInfo()));
            update.put("WRITERCHECKPOINTINFO", (Object)BatchUtil.objectToBytes(stepExecutionImpl.getWriterCheckpointInfo()));
            this.db.getCollection("STEP_EXECUTION").update((DBObject)new BasicDBObject("STEPEXECUTIONID", (Object)stepExecution.getStepExecutionId()), (DBObject)new BasicDBObject("$set", (Object)update));
        }
        catch (Exception e) {
            throw BatchMessages.MESSAGES.failToRunQuery(e, "updateStepExecution");
        }
    }

    @Override
    public void savePersistentData(JobExecution jobExecution, AbstractStepExecution stepOrPartitionExecution) {
        super.savePersistentData(jobExecution, stepOrPartitionExecution);
        if (stepOrPartitionExecution instanceof StepExecutionImpl) {
            this.updateStepExecution(stepOrPartitionExecution);
        } else {
            PartitionExecutionImpl partitionExecution = (PartitionExecutionImpl)stepOrPartitionExecution;
            try {
                BasicDBObject query = new BasicDBObject("STEPEXECUTIONID", (Object)partitionExecution.getStepExecutionId());
                query.put("PARTITIONEXECUTIONID", (Object)partitionExecution.getPartitionId());
                BasicDBObject update = new BasicDBObject("BATCHSTATUS", (Object)partitionExecution.getBatchStatus().name());
                update.put("EXITSTATUS", (Object)partitionExecution.getExitStatus());
                update.put("EXECUTIONEXCEPTION", (Object)TableColumns.formatException(partitionExecution.getException()));
                update.put("PERSISTENTUSERDATA", (Object)BatchUtil.objectToBytes(partitionExecution.getPersistentUserData()));
                update.put("READERCHECKPOINTINFO", (Object)BatchUtil.objectToBytes(partitionExecution.getReaderCheckpointInfo()));
                update.put("WRITERCHECKPOINTINFO", (Object)BatchUtil.objectToBytes(partitionExecution.getWriterCheckpointInfo()));
                this.db.getCollection("PARTITION_EXECUTION").update((DBObject)query, (DBObject)new BasicDBObject("$set", (Object)update));
            }
            catch (Exception e) {
                throw BatchMessages.MESSAGES.failToRunQuery(e, "savePersistentData");
            }
        }
    }

    StepExecution selectStepExecution(long stepExecutionId) {
        DBCollection collection = this.db.getCollection("STEP_EXECUTION");
        DBObject dbObject = collection.findOne((DBObject)new BasicDBObject("STEPEXECUTIONID", (Object)stepExecutionId));
        return this.createStepExecutionFromDBObject(dbObject);
    }

    List<StepExecution> selectStepExecutions(Long jobExecutionId) {
        DBCollection collection = this.db.getCollection("STEP_EXECUTION");
        DBCursor cursor = jobExecutionId == null ? collection.find() : collection.find((DBObject)new BasicDBObject("JOBEXECUTIONID", (Object)jobExecutionId));
        cursor = cursor.sort((DBObject)new BasicDBObject("STEPEXECUTIONID", (Object)1));
        ArrayList<StepExecution> result = new ArrayList<StepExecution>();
        this.createStepExecutionsFromDBCursor(cursor, result);
        return result;
    }

    @Override
    public void addPartitionExecution(StepExecutionImpl enclosingStepExecution, PartitionExecutionImpl partitionExecution) {
        super.addPartitionExecution(enclosingStepExecution, partitionExecution);
        BasicDBObject dbObject = new BasicDBObject("PARTITIONEXECUTIONID", (Object)partitionExecution.getPartitionId());
        dbObject.put("STEPEXECUTIONID", (Object)partitionExecution.getStepExecutionId());
        dbObject.put("BATCHSTATUS", (Object)partitionExecution.getBatchStatus().name());
        this.db.getCollection("PARTITION_EXECUTION").insert(new DBObject[]{dbObject});
    }

    @Override
    public StepExecutionImpl findOriginalStepExecutionForRestart(String stepName, JobExecutionImpl jobExecutionToRestart) {
        StepExecutionImpl result = super.findOriginalStepExecutionForRestart(stepName, jobExecutionToRestart);
        if (result != null) {
            return result;
        }
        BasicDBObject keys = new BasicDBObject("JOBEXECUTIONID", (Object)1);
        keys.put("_id", (Object)0);
        DBCursor cursor = this.db.getCollection("JOB_EXECUTION").find((DBObject)new BasicDBObject("JOBINSTANCEID", (Object)jobExecutionToRestart.getJobInstance().getInstanceId()), (DBObject)keys);
        BasicDBList basicDBList = new BasicDBList();
        while (cursor.hasNext()) {
            DBObject next = cursor.next();
            basicDBList.add(next.get("JOBEXECUTIONID"));
        }
        BasicDBObject inClause = new BasicDBObject("$in", (Object)basicDBList);
        BasicDBObject query = new BasicDBObject("JOBEXECUTIONID", (Object)inClause);
        query.put("STEPNAME", (Object)stepName);
        DBCursor cursor1 = this.db.getCollection("STEP_EXECUTION").find((DBObject)query).sort((DBObject)new BasicDBObject("STEPEXECUTIONID", (Object)-1));
        return this.createStepExecutionFromDBObject(cursor1.one());
    }

    @Override
    public List<PartitionExecutionImpl> getPartitionExecutions(long stepExecutionId, StepExecutionImpl stepExecution, boolean notCompletedOnly) {
        List<PartitionExecutionImpl> result = super.getPartitionExecutions(stepExecutionId, stepExecution, notCompletedOnly);
        if (result != null && !result.isEmpty()) {
            return result;
        }
        result = new ArrayList<PartitionExecutionImpl>();
        DBCursor cursor = this.db.getCollection("PARTITION_EXECUTION").find((DBObject)new BasicDBObject("STEPEXECUTIONID", (Object)stepExecutionId)).sort((DBObject)new BasicDBObject("PARTITIONEXECUTIONID", (Object)1));
        try {
            while (cursor.hasNext()) {
                DBObject next = cursor.next();
                String batchStatusValue = (String)next.get("BATCHSTATUS");
                if (notCompletedOnly && BatchStatus.COMPLETED.name().equals(batchStatusValue)) continue;
                result.add(new PartitionExecutionImpl((Integer)next.get("PARTITIONEXECUTIONID"), (Long)next.get("STEPEXECUTIONID"), stepExecution.getStepName(), BatchStatus.valueOf((String)batchStatusValue), (String)next.get("EXITSTATUS"), BatchUtil.bytesToSerializableObject((byte[])next.get("PERSISTENTUSERDATA")), BatchUtil.bytesToSerializableObject((byte[])next.get("READERCHECKPOINTINFO")), BatchUtil.bytesToSerializableObject((byte[])next.get("WRITERCHECKPOINTINFO"))));
            }
        }
        catch (Exception e) {
            throw BatchMessages.MESSAGES.failToRunQuery(e, "getPartitionExecutions");
        }
        return result;
    }

    private void createStepExecutionsFromDBCursor(DBCursor cursor, List<StepExecution> result) {
        while (cursor.hasNext()) {
            result.add(this.createStepExecutionFromDBObject(cursor.next()));
        }
    }

    private StepExecutionImpl createStepExecutionFromDBObject(DBObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        try {
            return new StepExecutionImpl(((Number)dbObject.get("STEPEXECUTIONID")).longValue(), (String)dbObject.get("STEPNAME"), (Date)dbObject.get("STARTTIME"), (Date)dbObject.get("ENDTIME"), (String)dbObject.get("BATCHSTATUS"), (String)dbObject.get("EXITSTATUS"), BatchUtil.bytesToSerializableObject((byte[])dbObject.get("PERSISTENTUSERDATA")), ((Number)dbObject.get("READCOUNT")).longValue(), ((Number)dbObject.get("WRITECOUNT")).longValue(), ((Number)dbObject.get("COMMITCOUNT")).longValue(), ((Number)dbObject.get("ROLLBACKCOUNT")).longValue(), ((Number)dbObject.get("READSKIPCOUNT")).longValue(), ((Number)dbObject.get("PROCESSSKIPCOUNT")).longValue(), ((Number)dbObject.get("FILTERCOUNT")).longValue(), ((Number)dbObject.get("WRITESKIPCOUNT")).longValue(), BatchUtil.bytesToSerializableObject((byte[])dbObject.get("READERCHECKPOINTINFO")), BatchUtil.bytesToSerializableObject((byte[])dbObject.get("WRITERCHECKPOINTINFO")));
        }
        catch (Exception e) {
            throw BatchMessages.MESSAGES.failToRunQuery(e, "createStepExecutionFromDBObject");
        }
    }

    @Override
    public int countStepStartTimes(String stepName, long jobInstanceId) {
        BasicDBObject keys = new BasicDBObject("JOBEXECUTIONID", (Object)1);
        keys.put("_id", (Object)0);
        DBCursor cursor = this.db.getCollection("JOB_EXECUTION").find((DBObject)new BasicDBObject("JOBINSTANCEID", (Object)jobInstanceId), (DBObject)keys);
        BasicDBList basicDBList = new BasicDBList();
        while (cursor.hasNext()) {
            DBObject next = cursor.next();
            basicDBList.add(next.get("JOBEXECUTIONID"));
        }
        BasicDBObject inClause = new BasicDBObject("$in", (Object)basicDBList);
        BasicDBObject query = new BasicDBObject("JOBEXECUTIONID", (Object)inClause);
        query.put("STEPNAME", (Object)stepName);
        return this.db.getCollection("STEP_EXECUTION").find((DBObject)query).count();
    }

    private Long incrementAndGetSequence(String whichId) {
        BasicDBObject query = new BasicDBObject("_id", (Object)whichId);
        BasicDBObject update = new BasicDBObject("$inc", (Object)new BasicDBObject("seq", (Object)1));
        DBObject result = this.seqCollection.findAndModify((DBObject)query, (DBObject)update);
        return (Long)result.get("seq");
    }
}

