/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.common.util.SpringClasspathScanner;
import org.apache.cxf.common.util.StringUtils;

public class ClasspathScanner {
    public static final String ALL_FILES = "**/*";
    public static final String ALL_CLASS_FILES = "**/*.class";
    public static final String ALL_PACKAGES = "*";
    public static final String CLASSPATH_URL_SCHEME = "classpath:";
    static final ClasspathScanner HELPER;
    static final String[] PACKAGES_TO_SKIP;

    protected ClasspathScanner() {
    }

    public static Map<Class<? extends Annotation>, Collection<Class<?>>> findClasses(String basePackage, Class<? extends Annotation> ... annotations) throws IOException, ClassNotFoundException {
        return ClasspathScanner.findClasses(Collections.singletonList(basePackage), Arrays.asList(annotations));
    }

    public static Map<Class<? extends Annotation>, Collection<Class<?>>> findClasses(Collection<String> basePackages, Class<? extends Annotation> ... annotations) throws IOException, ClassNotFoundException {
        return ClasspathScanner.findClasses(basePackages, Arrays.asList(annotations));
    }

    public static Map<Class<? extends Annotation>, Collection<Class<?>>> findClasses(Collection<String> basePackages, List<Class<? extends Annotation>> annotations) throws IOException, ClassNotFoundException {
        return ClasspathScanner.findClasses(basePackages, annotations, null);
    }

    public static Map<Class<? extends Annotation>, Collection<Class<?>>> findClasses(Collection<String> basePackages, List<Class<? extends Annotation>> annotations, ClassLoader loader) throws IOException, ClassNotFoundException {
        return HELPER.findClassesInternal(basePackages, annotations, loader);
    }

    protected Map<Class<? extends Annotation>, Collection<Class<?>>> findClassesInternal(Collection<String> basePackages, List<Class<? extends Annotation>> annotations, ClassLoader loader) throws IOException, ClassNotFoundException {
        return Collections.emptyMap();
    }

    public static List<URL> findResources(String basePackage, String extension) throws IOException {
        return ClasspathScanner.findResources(Collections.singletonList(basePackage), extension);
    }

    public static List<URL> findResources(Collection<String> basePackages, String extension) throws IOException {
        return ClasspathScanner.findResources(basePackages, extension, null);
    }

    public static List<URL> findResources(Collection<String> basePackages, String extension, ClassLoader loader) throws IOException {
        return HELPER.findResourcesInternal(basePackages, extension, loader);
    }

    public static Set<String> parsePackages(String packagesAsCsv) {
        String[] values = StringUtils.split(packagesAsCsv, ",");
        HashSet<String> basePackages = new HashSet<String>(values.length);
        for (String value : values) {
            String trimmed = value.trim();
            if (trimmed.equals(ALL_PACKAGES)) {
                basePackages.clear();
                basePackages.add(trimmed);
                break;
            }
            if (trimmed.length() <= 0) continue;
            basePackages.add(trimmed);
        }
        return basePackages;
    }

    protected List<URL> findResourcesInternal(Collection<String> basePackages, String extension, ClassLoader loader) throws IOException {
        return Collections.emptyList();
    }

    static {
        ClasspathScanner theHelper = null;
        try {
            theHelper = new SpringClasspathScanner();
        }
        catch (Throwable ex) {
            theHelper = new ClasspathScanner();
        }
        HELPER = theHelper;
        PACKAGES_TO_SKIP = new String[]{"org.apache.cxf"};
    }
}

