/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.csiv2;

import org.jboss.as.jacorb.csiv2.SASClientIdentityInterceptor;
import org.jboss.as.jacorb.csiv2.SASCurrentImpl;
import org.jboss.as.jacorb.csiv2.SASTargetInterceptor;
import org.jboss.as.jacorb.logging.JacORBLogger;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.IOP.Encoding;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class SASInitializer
extends LocalObject
implements ORBInitializer {
    public void pre_init(ORBInitInfo info) {
        try {
            SASCurrentImpl sasCurrent = new SASCurrentImpl();
            info.register_initial_reference("SASCurrent", (Object)sasCurrent);
        }
        catch (InvalidName e) {
            throw JacORBLogger.ROOT_LOGGER.errorRegisteringSASCurrentInitRef(e);
        }
    }

    public void post_init(ORBInitInfo info) {
        try {
            Encoding encoding = new Encoding(0, 1, 0);
            Codec codec = info.codec_factory().create_codec(encoding);
            SASClientIdentityInterceptor clientInterceptor = new SASClientIdentityInterceptor(codec);
            info.add_client_request_interceptor((ClientRequestInterceptor)clientInterceptor);
            SASTargetInterceptor serverInterceptor = new SASTargetInterceptor(codec);
            info.add_server_request_interceptor((ServerRequestInterceptor)serverInterceptor);
            Object obj = info.resolve_initial_references("SASCurrent");
            SASCurrentImpl sasCurrentImpl = (SASCurrentImpl)obj;
            sasCurrentImpl.init(serverInterceptor);
        }
        catch (Exception e) {
            throw JacORBLogger.ROOT_LOGGER.unexpectedException(e);
        }
    }
}

