/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.rmi;

import org.jboss.as.jacorb.logging.JacORBLogger;
import org.jboss.as.jacorb.rmi.AbstractAnalysis;
import org.jboss.as.jacorb.rmi.Util;
import org.omg.CORBA.Any;

public class ConstantAnalysis
extends AbstractAnalysis {
    private Class type;
    private Object value;

    ConstantAnalysis(String javaName, Class type, Object value) {
        super(javaName);
        if (type == Void.TYPE || !type.isPrimitive() && type != String.class) {
            throw JacORBLogger.ROOT_LOGGER.badConstantType(type.getName());
        }
        this.type = type;
        this.value = value;
    }

    public Class getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public void insertValue(Any any) {
        if (this.type == String.class) {
            any.insert_wstring((String)this.value);
        } else {
            Util.insertAnyPrimitive(any, this.value);
        }
    }
}

