/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.rmi;

import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.jboss.as.jacorb.logging.JacORBLogger;
import org.jboss.as.jacorb.rmi.AbstractAnalysis;
import org.jboss.as.jacorb.rmi.ExceptionAnalysis;
import org.jboss.as.jacorb.rmi.ParameterAnalysis;
import org.jboss.as.jacorb.rmi.RMIIIOPViolationException;
import org.jboss.as.jacorb.rmi.Util;

public class OperationAnalysis
extends AbstractAnalysis {
    private final Method method;
    private final ExceptionAnalysis[] mappedExceptions;
    private final ParameterAnalysis[] parameters;

    OperationAnalysis(Method method) throws RMIIIOPViolationException {
        super(method.getName());
        this.method = method;
        Class<?> retCls = method.getReturnType();
        if (retCls.isInterface() && Remote.class.isAssignableFrom(retCls)) {
            Util.isValidRMIIIOP(retCls);
        }
        Class<?>[] ex = method.getExceptionTypes();
        boolean gotRemoteException = false;
        ArrayList<ExceptionAnalysis> a = new ArrayList<ExceptionAnalysis>();
        for (int i = 0; i < ex.length; ++i) {
            if (ex[i].isAssignableFrom(RemoteException.class)) {
                gotRemoteException = true;
            }
            if (!Exception.class.isAssignableFrom(ex[i]) || RuntimeException.class.isAssignableFrom(ex[i]) || RemoteException.class.isAssignableFrom(ex[i])) continue;
            a.add(ExceptionAnalysis.getExceptionAnalysis(ex[i]));
        }
        if (!gotRemoteException && Remote.class.isAssignableFrom(method.getDeclaringClass())) {
            throw JacORBLogger.ROOT_LOGGER.badRMIIIOPMethodSignature(this.getJavaName(), method.getDeclaringClass().getName(), "1.2.3");
        }
        ExceptionAnalysis[] exceptions = new ExceptionAnalysis[a.size()];
        this.mappedExceptions = a.toArray(exceptions);
        Class<?>[] params = method.getParameterTypes();
        this.parameters = new ParameterAnalysis[params.length];
        for (int i = 0; i < params.length; ++i) {
            this.parameters[i] = new ParameterAnalysis("param" + (i + 1), params[i]);
        }
    }

    public Class getReturnType() {
        return this.method.getReturnType();
    }

    public Method getMethod() {
        return this.method;
    }

    public ExceptionAnalysis[] getMappedExceptions() {
        return (ExceptionAnalysis[])this.mappedExceptions.clone();
    }

    public ParameterAnalysis[] getParameters() {
        return (ParameterAnalysis[])this.parameters.clone();
    }
}

