/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.metadata;

import java.util.List;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.Identity;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchElement;
import org.jboss.as.patching.metadata.RollbackPatch;

public class PatchImpl
implements Patch {
    private final String patchID;
    private final String description;
    private final Identity identity;
    private final List<PatchElement> elements;
    private final List<ContentModification> modifications;

    public PatchImpl(String patchID, String description, Identity identity, List<PatchElement> elements, List<ContentModification> modifications) {
        if (!Patch.PATCH_NAME_PATTERN.matcher(patchID).matches()) {
            throw PatchLogger.ROOT_LOGGER.illegalPatchName(patchID);
        }
        this.patchID = patchID;
        this.description = description;
        this.identity = identity;
        this.elements = elements;
        this.modifications = modifications;
    }

    @Override
    public String getPatchId() {
        return this.patchID;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Identity getIdentity() {
        return this.identity;
    }

    @Override
    public List<PatchElement> getElements() {
        return this.elements;
    }

    @Override
    public List<ContentModification> getModifications() {
        return this.modifications;
    }

    public static class RollbackPatchImpl
    implements RollbackPatch {
        private final Patch patch;
        private final InstalledIdentity installedIdentity;

        public RollbackPatchImpl(Patch patch, InstalledIdentity installedIdentity) {
            this.patch = patch;
            this.installedIdentity = installedIdentity;
        }

        @Override
        public String getPatchId() {
            return this.patch.getPatchId();
        }

        @Override
        public String getDescription() {
            return this.patch.getDescription();
        }

        @Override
        public Identity getIdentity() {
            return this.patch.getIdentity();
        }

        @Override
        public List<PatchElement> getElements() {
            return this.patch.getElements();
        }

        @Override
        public List<ContentModification> getModifications() {
            return this.patch.getModifications();
        }

        @Override
        public InstalledIdentity getIdentityState() {
            return this.installedIdentity;
        }
    }
}

