/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.jca.core.api.connectionmanager.pool.PoolStatistics;
import org.jboss.jca.core.connectionmanager.pool.SecurityActions;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;

public class PoolStatisticsImpl
implements PoolStatistics {
    private static final long serialVersionUID = 7L;
    private static final String ACTIVE_COUNT = "ActiveCount";
    private static final String AVAILABLE_COUNT = "AvailableCount";
    private static final String AVERAGE_BLOCKING_TIME = "AverageBlockingTime";
    private static final String AVERAGE_CREATION_TIME = "AverageCreationTime";
    private static final String AVERAGE_GET_TIME = "AverageGetTime";
    private static final String AVERAGE_POOL_TIME = "AveragePoolTime";
    private static final String AVERAGE_USAGE_TIME = "AverageUsageTime";
    private static final String BLOCKING_FAILURE_COUNT = "BlockingFailureCount";
    private static final String CREATED_COUNT = "CreatedCount";
    private static final String DESTROYED_COUNT = "DestroyedCount";
    private static final String IDLE_COUNT = "IdleCount";
    private static final String IN_USE_COUNT = "InUseCount";
    private static final String MAX_CREATION_TIME = "MaxCreationTime";
    private static final String MAX_GET_TIME = "MaxGetTime";
    private static final String MAX_POOL_TIME = "MaxPoolTime";
    private static final String MAX_USAGE_TIME = "MaxUsageTime";
    private static final String MAX_USED_COUNT = "MaxUsedCount";
    private static final String MAX_WAIT_COUNT = "MaxWaitCount";
    private static final String MAX_WAIT_TIME = "MaxWaitTime";
    private static final String TIMED_OUT = "TimedOut";
    private static final String TOTAL_BLOCKING_TIME = "TotalBlockingTime";
    private static final String TOTAL_CREATION_TIME = "TotalCreationTime";
    private static final String TOTAL_GET_TIME = "TotalGetTime";
    private static final String TOTAL_POOL_TIME = "TotalPoolTime";
    private static final String TOTAL_USAGE_TIME = "TotalUsageTime";
    private static final String WAIT_COUNT = "WaitCount";
    private int maxPoolSize;
    private transient ConcurrentMap<Object, ManagedConnectionPool> mcpPools;
    private transient SortedSet<String> names;
    private transient Map<String, Class> types;
    private transient AtomicBoolean enabled;
    private transient Map<Locale, ResourceBundle> rbs;

    public PoolStatisticsImpl(int maxPoolSize, ConcurrentMap<Object, ManagedConnectionPool> mcpPools) {
        this.init(maxPoolSize, mcpPools);
    }

    private void init(int maxPoolSize, ConcurrentMap<Object, ManagedConnectionPool> mcpPools) {
        this.maxPoolSize = maxPoolSize;
        this.mcpPools = mcpPools;
        TreeSet<String> n = new TreeSet<String>();
        HashMap<String, Class<Number>> t = new HashMap<String, Class<Number>>();
        n.add(ACTIVE_COUNT);
        t.put(ACTIVE_COUNT, Integer.TYPE);
        n.add(AVAILABLE_COUNT);
        t.put(AVAILABLE_COUNT, Integer.TYPE);
        n.add(AVERAGE_BLOCKING_TIME);
        t.put(AVERAGE_BLOCKING_TIME, Long.TYPE);
        n.add(AVERAGE_CREATION_TIME);
        t.put(AVERAGE_CREATION_TIME, Long.TYPE);
        n.add(AVERAGE_GET_TIME);
        t.put(AVERAGE_GET_TIME, Long.TYPE);
        n.add(AVERAGE_USAGE_TIME);
        t.put(AVERAGE_USAGE_TIME, Long.TYPE);
        n.add(AVERAGE_POOL_TIME);
        t.put(AVERAGE_POOL_TIME, Long.TYPE);
        n.add(BLOCKING_FAILURE_COUNT);
        t.put(BLOCKING_FAILURE_COUNT, Integer.TYPE);
        n.add(CREATED_COUNT);
        t.put(CREATED_COUNT, Integer.TYPE);
        n.add(DESTROYED_COUNT);
        t.put(DESTROYED_COUNT, Integer.TYPE);
        n.add(IDLE_COUNT);
        t.put(IDLE_COUNT, Integer.TYPE);
        n.add(IN_USE_COUNT);
        t.put(IN_USE_COUNT, Integer.TYPE);
        n.add(MAX_CREATION_TIME);
        t.put(MAX_CREATION_TIME, Long.TYPE);
        n.add(MAX_GET_TIME);
        t.put(MAX_GET_TIME, Long.TYPE);
        n.add(MAX_POOL_TIME);
        t.put(MAX_POOL_TIME, Long.TYPE);
        n.add(MAX_USAGE_TIME);
        t.put(MAX_USAGE_TIME, Long.TYPE);
        n.add(MAX_USED_COUNT);
        t.put(MAX_USED_COUNT, Integer.TYPE);
        n.add(MAX_WAIT_COUNT);
        t.put(MAX_WAIT_COUNT, Integer.TYPE);
        n.add(MAX_WAIT_TIME);
        t.put(MAX_WAIT_TIME, Long.TYPE);
        n.add(TIMED_OUT);
        t.put(TIMED_OUT, Integer.TYPE);
        n.add(TOTAL_BLOCKING_TIME);
        t.put(TOTAL_BLOCKING_TIME, Long.TYPE);
        n.add(TOTAL_CREATION_TIME);
        t.put(TOTAL_CREATION_TIME, Long.TYPE);
        n.add(TOTAL_GET_TIME);
        t.put(TOTAL_GET_TIME, Long.TYPE);
        n.add(TOTAL_POOL_TIME);
        t.put(TOTAL_POOL_TIME, Long.TYPE);
        n.add(TOTAL_USAGE_TIME);
        t.put(TOTAL_USAGE_TIME, Long.TYPE);
        n.add(WAIT_COUNT);
        t.put(WAIT_COUNT, Integer.TYPE);
        this.names = Collections.unmodifiableSortedSet(n);
        this.types = Collections.unmodifiableMap(t);
        this.enabled = new AtomicBoolean(true);
        ResourceBundle defaultResourceBundle = ResourceBundle.getBundle("poolstatistics", Locale.US, SecurityActions.getClassLoader(PoolStatisticsImpl.class));
        this.rbs = new HashMap<Locale, ResourceBundle>(1);
        this.rbs.put(Locale.US, defaultResourceBundle);
        this.clear();
    }

    public Set<String> getNames() {
        return this.names;
    }

    public Class getType(String name) {
        return this.types.get(name);
    }

    public String getDescription(String name) {
        return this.getDescription(name, Locale.US);
    }

    public String getDescription(String name, Locale locale) {
        ResourceBundle newResourceBundle;
        ResourceBundle rb = this.rbs.get(locale);
        if (rb == null && (newResourceBundle = ResourceBundle.getBundle("poolstatistics", locale, SecurityActions.getClassLoader(PoolStatisticsImpl.class))) != null) {
            this.rbs.put(locale, newResourceBundle);
        }
        if (rb == null) {
            rb = this.rbs.get(Locale.US);
        }
        if (rb != null) {
            return rb.getString(name);
        }
        return "";
    }

    public Object getValue(String name) {
        if (ACTIVE_COUNT.equals(name)) {
            return this.getActiveCount();
        }
        if (AVAILABLE_COUNT.equals(name)) {
            return this.getAvailableCount();
        }
        if (AVERAGE_BLOCKING_TIME.equals(name)) {
            return this.getAverageBlockingTime();
        }
        if (AVERAGE_CREATION_TIME.equals(name)) {
            return this.getAverageCreationTime();
        }
        if (AVERAGE_GET_TIME.equals(name)) {
            return this.getAverageGetTime();
        }
        if (AVERAGE_USAGE_TIME.equals(name)) {
            return this.getAverageUsageTime();
        }
        if (AVERAGE_POOL_TIME.equals(name)) {
            return this.getAveragePoolTime();
        }
        if (BLOCKING_FAILURE_COUNT.equals(name)) {
            return this.getBlockingFailureCount();
        }
        if (CREATED_COUNT.equals(name)) {
            return this.getCreatedCount();
        }
        if (DESTROYED_COUNT.equals(name)) {
            return this.getDestroyedCount();
        }
        if (IDLE_COUNT.equals(name)) {
            return this.getIdleCount();
        }
        if (IN_USE_COUNT.equals(name)) {
            return this.getInUseCount();
        }
        if (MAX_CREATION_TIME.equals(name)) {
            return this.getMaxCreationTime();
        }
        if (MAX_GET_TIME.equals(name)) {
            return this.getMaxGetTime();
        }
        if (MAX_POOL_TIME.equals(name)) {
            return this.getMaxPoolTime();
        }
        if (MAX_USAGE_TIME.equals(name)) {
            return this.getMaxUsageTime();
        }
        if (MAX_USED_COUNT.equals(name)) {
            return this.getMaxUsedCount();
        }
        if (MAX_WAIT_COUNT.equals(name)) {
            return this.getMaxWaitCount();
        }
        if (MAX_WAIT_TIME.equals(name)) {
            return this.getMaxWaitTime();
        }
        if (TIMED_OUT.equals(name)) {
            return this.getTimedOut();
        }
        if (TOTAL_BLOCKING_TIME.equals(name)) {
            return this.getTotalBlockingTime();
        }
        if (TOTAL_CREATION_TIME.equals(name)) {
            return this.getTotalCreationTime();
        }
        if (TOTAL_GET_TIME.equals(name)) {
            return this.getTotalGetTime();
        }
        if (TOTAL_POOL_TIME.equals(name)) {
            return this.getTotalPoolTime();
        }
        if (TOTAL_USAGE_TIME.equals(name)) {
            return this.getTotalUsageTime();
        }
        if (WAIT_COUNT.equals(name)) {
            return this.getWaitCount();
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public void setEnabled(boolean v) {
        this.enabled.set(v);
        for (ManagedConnectionPool mcp : this.mcpPools.values()) {
            mcp.getStatistics().setEnabled(v);
        }
    }

    public int getActiveCount() {
        if (this.isEnabled()) {
            int result = 0;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                result += mcp.getStatistics().getActiveCount();
            }
            return result;
        }
        return 0;
    }

    public int getAvailableCount() {
        int result = -1;
        if (this.mcpPools.size() > 0) {
            result = 0;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                result += mcp.getStatistics().getAvailableCount();
            }
        }
        if (result != -1) {
            return result;
        }
        return this.maxPoolSize;
    }

    public long getAverageBlockingTime() {
        if (this.isEnabled()) {
            long invocations = 0L;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                invocations += mcp.getStatistics().getTotalBlockingInvocations();
            }
            return invocations != 0L ? this.getTotalBlockingTime() / invocations : 0L;
        }
        return 0L;
    }

    public long getAverageCreationTime() {
        if (this.isEnabled()) {
            int createdCount = this.getCreatedCount();
            return createdCount != 0 ? this.getTotalCreationTime() / (long)createdCount : 0L;
        }
        return 0L;
    }

    public long getAverageGetTime() {
        if (this.isEnabled()) {
            long invocations = 0L;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                invocations += mcp.getStatistics().getTotalGetInvocations();
            }
            return invocations != 0L ? this.getTotalGetTime() / invocations : 0L;
        }
        return 0L;
    }

    public long getAverageUsageTime() {
        if (this.isEnabled()) {
            long invocations = 0L;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                invocations += mcp.getStatistics().getTotalUsageInvocations();
            }
            return invocations != 0L ? this.getTotalUsageTime() / invocations : 0L;
        }
        return 0L;
    }

    public long getAveragePoolTime() {
        if (this.isEnabled()) {
            long invocations = 0L;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                invocations += mcp.getStatistics().getTotalPoolInvocations();
            }
            return invocations != 0L ? this.getTotalPoolTime() / invocations : 0L;
        }
        return 0L;
    }

    public int getBlockingFailureCount() {
        if (this.isEnabled()) {
            int result = 0;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                result += mcp.getStatistics().getBlockingFailureCount();
            }
            return result;
        }
        return 0;
    }

    public int getCreatedCount() {
        if (this.isEnabled()) {
            int result = 0;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                result += mcp.getStatistics().getCreatedCount();
            }
            return result;
        }
        return 0;
    }

    public int getDestroyedCount() {
        if (this.isEnabled()) {
            int result = 0;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                result += mcp.getStatistics().getDestroyedCount();
            }
            return result;
        }
        return 0;
    }

    public int getIdleCount() {
        if (this.isEnabled()) {
            int result = 0;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                result += mcp.getStatistics().getIdleCount();
            }
            return result;
        }
        return 0;
    }

    public int getInUseCount() {
        if (this.isEnabled()) {
            int result = 0;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                result += mcp.getStatistics().getInUseCount();
            }
            return result;
        }
        return 0;
    }

    public long getMaxCreationTime() {
        if (this.isEnabled()) {
            long result = Long.MIN_VALUE;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                long v = mcp.getStatistics().getMaxCreationTime();
                if (v <= result) continue;
                result = v;
            }
            return result != Long.MIN_VALUE ? result : 0L;
        }
        return 0L;
    }

    public long getMaxGetTime() {
        if (this.isEnabled()) {
            long result = Long.MIN_VALUE;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                long v = mcp.getStatistics().getMaxGetTime();
                if (v <= result) continue;
                result = v;
            }
            return result != Long.MIN_VALUE ? result : 0L;
        }
        return 0L;
    }

    public long getMaxPoolTime() {
        if (this.isEnabled()) {
            long result = Long.MIN_VALUE;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                long v = mcp.getStatistics().getMaxPoolTime();
                if (v <= result) continue;
                result = v;
            }
            return result != Long.MIN_VALUE ? result : 0L;
        }
        return 0L;
    }

    public long getMaxUsageTime() {
        if (this.isEnabled()) {
            long result = Long.MIN_VALUE;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                long v = mcp.getStatistics().getMaxUsageTime();
                if (v <= result) continue;
                result = v;
            }
            return result != Long.MIN_VALUE ? result : 0L;
        }
        return 0L;
    }

    public int getMaxUsedCount() {
        if (this.isEnabled()) {
            int result = Integer.MIN_VALUE;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                int v = mcp.getStatistics().getMaxUsedCount();
                if (v <= result) continue;
                result = v;
            }
            return result != Integer.MIN_VALUE ? result : 0;
        }
        return 0;
    }

    public int getMaxWaitCount() {
        if (this.isEnabled()) {
            int result = Integer.MIN_VALUE;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                int v = mcp.getStatistics().getMaxWaitCount();
                if (v <= result) continue;
                result = v;
            }
            return result != Integer.MIN_VALUE ? result : 0;
        }
        return 0;
    }

    public long getMaxWaitTime() {
        if (this.isEnabled()) {
            long result = Long.MIN_VALUE;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                long v = mcp.getStatistics().getMaxWaitTime();
                if (v <= result) continue;
                result = v;
            }
            return result != Long.MIN_VALUE ? result : 0L;
        }
        return 0L;
    }

    public int getTimedOut() {
        if (this.isEnabled()) {
            int result = 0;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                result += mcp.getStatistics().getTimedOut();
            }
            return result;
        }
        return 0;
    }

    public long getTotalBlockingTime() {
        if (this.isEnabled()) {
            long result = 0L;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                result += mcp.getStatistics().getTotalBlockingTime();
            }
            return result;
        }
        return 0L;
    }

    public long getTotalCreationTime() {
        if (this.isEnabled()) {
            long result = 0L;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                result += mcp.getStatistics().getTotalCreationTime();
            }
            return result;
        }
        return 0L;
    }

    public long getTotalGetTime() {
        if (this.isEnabled()) {
            long result = 0L;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                result += mcp.getStatistics().getTotalGetTime();
            }
            return result;
        }
        return 0L;
    }

    public long getTotalPoolTime() {
        if (this.isEnabled()) {
            long result = 0L;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                result += mcp.getStatistics().getTotalPoolTime();
            }
            return result;
        }
        return 0L;
    }

    public long getTotalUsageTime() {
        if (this.isEnabled()) {
            long result = 0L;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                result += mcp.getStatistics().getTotalUsageTime();
            }
            return result;
        }
        return 0L;
    }

    public int getWaitCount() {
        if (this.isEnabled()) {
            int result = 0;
            for (ManagedConnectionPool mcp : this.mcpPools.values()) {
                result += mcp.getStatistics().getWaitCount();
            }
            return result;
        }
        return 0;
    }

    public void clear() {
        for (ManagedConnectionPool mcp : this.mcpPools.values()) {
            mcp.getStatistics().clear();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.maxPoolSize);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init(in.readInt(), new ConcurrentHashMap<Object, ManagedConnectionPool>());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PoolStatistics@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[");
        sb.append("Enabled=").append(this.isEnabled());
        sb.append(",");
        sb.append(ACTIVE_COUNT).append("=").append(this.getActiveCount());
        sb.append(",");
        sb.append(AVAILABLE_COUNT).append("=").append(this.getAvailableCount());
        sb.append(",");
        sb.append(AVERAGE_BLOCKING_TIME).append("=").append(this.getAverageBlockingTime());
        sb.append(",");
        sb.append(AVERAGE_CREATION_TIME).append("=").append(this.getAverageCreationTime());
        sb.append(",");
        sb.append(AVERAGE_GET_TIME).append("=").append(this.getAverageGetTime());
        sb.append(",");
        sb.append(AVERAGE_POOL_TIME).append("=").append(this.getAveragePoolTime());
        sb.append(",");
        sb.append(AVERAGE_USAGE_TIME).append("=").append(this.getAverageUsageTime());
        sb.append(",");
        sb.append(BLOCKING_FAILURE_COUNT).append("=").append(this.getBlockingFailureCount());
        sb.append(",");
        sb.append(CREATED_COUNT).append("=").append(this.getCreatedCount());
        sb.append(",");
        sb.append(DESTROYED_COUNT).append("=").append(this.getDestroyedCount());
        sb.append(",");
        sb.append(IDLE_COUNT).append("=").append(this.getIdleCount());
        sb.append(",");
        sb.append(IN_USE_COUNT).append("=").append(this.getInUseCount());
        sb.append(",");
        sb.append(MAX_CREATION_TIME).append("=").append(this.getMaxCreationTime());
        sb.append(",");
        sb.append(MAX_GET_TIME).append("=").append(this.getMaxGetTime());
        sb.append(",");
        sb.append(MAX_POOL_TIME).append("=").append(this.getMaxPoolTime());
        sb.append(",");
        sb.append(MAX_USAGE_TIME).append("=").append(this.getMaxUsageTime());
        sb.append(",");
        sb.append(MAX_USED_COUNT).append("=").append(this.getMaxUsedCount());
        sb.append(",");
        sb.append(MAX_WAIT_COUNT).append("=").append(this.getMaxWaitCount());
        sb.append(",");
        sb.append(MAX_WAIT_TIME).append("=").append(this.getMaxWaitTime());
        sb.append(",");
        sb.append(TIMED_OUT).append("=").append(this.getTimedOut());
        sb.append(",");
        sb.append(TOTAL_BLOCKING_TIME).append("=").append(this.getTotalBlockingTime());
        sb.append(",");
        sb.append(TOTAL_CREATION_TIME).append("=").append(this.getTotalCreationTime());
        sb.append(",");
        sb.append(TOTAL_GET_TIME).append("=").append(this.getTotalGetTime());
        sb.append(",");
        sb.append(TOTAL_POOL_TIME).append("=").append(this.getTotalPoolTime());
        sb.append(",");
        sb.append(TOTAL_USAGE_TIME).append("=").append(this.getTotalUsageTime());
        sb.append(",");
        sb.append(WAIT_COUNT).append("=").append(this.getWaitCount());
        sb.append("]");
        return sb.toString();
    }
}

