/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.mcp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.RetryableException;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.pool.FlushMode;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.ConnectionState;
import org.jboss.jca.core.connectionmanager.pool.api.CapacityDecrementer;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PrefillPool;
import org.jboss.jca.core.connectionmanager.pool.capacity.DefaultCapacity;
import org.jboss.jca.core.connectionmanager.pool.idle.IdleRemover;
import org.jboss.jca.core.connectionmanager.pool.mcp.CapacityFiller;
import org.jboss.jca.core.connectionmanager.pool.mcp.CapacityRequest;
import org.jboss.jca.core.connectionmanager.pool.mcp.FillRequest;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolStatistics;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolStatisticsImpl;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolUtility;
import org.jboss.jca.core.connectionmanager.pool.mcp.PoolFiller;
import org.jboss.jca.core.connectionmanager.pool.mcp.SecurityActions;
import org.jboss.jca.core.connectionmanager.pool.mcp.Semaphore;
import org.jboss.jca.core.connectionmanager.pool.validator.ConnectionValidator;
import org.jboss.jca.core.tracer.Tracer;
import org.jboss.logging.Messages;

public class SemaphoreArrayListManagedConnectionPool
implements ManagedConnectionPool {
    private static String newLine = SecurityActions.getSystemProperty("line.separator");
    private CoreLogger log;
    private boolean debug;
    private boolean trace;
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private ManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private Subject defaultSubject;
    private ConnectionRequestInfo defaultCri;
    private PoolConfiguration poolConfiguration;
    private Pool pool;
    private int maxSize;
    private ArrayList<ConnectionListener> cls;
    private Semaphore permits;
    private final ConcurrentMap<ConnectionListener, ConnectionListener> clPermits = new ConcurrentHashMap<ConnectionListener, ConnectionListener>();
    private final ArrayList<ConnectionListener> checkedOut = new ArrayList();
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private ManagedConnectionPoolStatisticsImpl statistics;
    private Boolean supportsLazyAssociation;
    private long lastIdleCheck;
    private long lastUsed;

    @Override
    public void initialize(ManagedConnectionFactory mcf, ConnectionManager cm, Subject subject, ConnectionRequestInfo cri, PoolConfiguration pc, Pool p) {
        if (mcf == null) {
            throw new IllegalArgumentException("ManagedConnectionFactory is null");
        }
        if (cm == null) {
            throw new IllegalArgumentException("ConnectionManager is null");
        }
        if (pc == null) {
            throw new IllegalArgumentException("PoolConfiguration is null");
        }
        if (p == null) {
            throw new IllegalArgumentException("Pool is null");
        }
        this.mcf = mcf;
        this.cm = cm;
        this.defaultSubject = subject;
        this.defaultCri = cri;
        this.poolConfiguration = pc;
        this.maxSize = pc.getMaxSize();
        this.pool = p;
        this.log = this.pool.getLogger();
        this.debug = this.log.isDebugEnabled();
        this.trace = this.log.isTraceEnabled();
        this.cls = new ArrayList(this.maxSize);
        this.statistics = new ManagedConnectionPoolStatisticsImpl(this.maxSize);
        this.statistics.setEnabled(p.getStatistics().isEnabled());
        this.permits = new Semaphore(this.maxSize, true, this.statistics);
        this.supportsLazyAssociation = null;
        this.lastIdleCheck = Long.MIN_VALUE;
        this.lastUsed = Long.MAX_VALUE;
        if ((pc.isPrefill() || pc.isStrictMin()) && p instanceof PrefillPool && pc.getInitialSize() > 0) {
            PoolFiller.fillPool(new FillRequest(this, pc.getInitialSize()));
        }
        if (this.poolConfiguration.getIdleTimeoutMinutes() > 0) {
            IdleRemover.getInstance().registerPool(this, (long)this.poolConfiguration.getIdleTimeoutMinutes() * 1000L * 60L);
        }
        if (this.poolConfiguration.isBackgroundValidation() && this.poolConfiguration.getBackgroundValidationMillis() > 0L) {
            if (this.debug) {
                this.log.debug("Registering for background validation at interval " + this.poolConfiguration.getBackgroundValidationMillis());
            }
            ConnectionValidator.getInstance().registerPool(this, this.poolConfiguration.getBackgroundValidationMillis());
        }
        this.shutdown.set(false);
    }

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public boolean isRunning() {
        return !this.shutdown.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            return this.cls.size() == 0 && this.checkedOut.size() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFull() {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            return this.checkedOut.size() == this.maxSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIdle() {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            return this.checkedOut.size() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActive() {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            return this.cls.size() + this.checkedOut.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSize(int size) {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            return this.cls.size() + this.checkedOut.size() >= size;
        }
    }

    @Override
    public void prefill() {
        if (!this.shutdown.get() && (this.poolConfiguration.isPrefill() || this.poolConfiguration.isStrictMin()) && this.pool instanceof PrefillPool && this.poolConfiguration.getMinSize() > 0) {
            PoolFiller.fillPool(new FillRequest(this, this.poolConfiguration.getMinSize()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionListener getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (this.trace) {
            ArrayList<ConnectionListener> arrayList = this.cls;
            synchronized (arrayList) {
                String method = "getConnection(" + subject + ", " + cri + ")";
                this.log.trace(ManagedConnectionPoolUtility.fullDetails(System.identityHashCode(this), method, this.mcf, this.cm, this.pool, this.poolConfiguration, this.cls, this.checkedOut, this.statistics));
            }
        } else if (this.debug) {
            String method = "getConnection(" + subject + ", " + cri + ")";
            this.log.debug(ManagedConnectionPoolUtility.details(method, this.pool.getName(), this.statistics.getInUseCount(), this.maxSize));
        }
        subject = subject == null ? this.defaultSubject : subject;
        ConnectionRequestInfo connectionRequestInfo = cri = cri == null ? this.defaultCri : cri;
        if (this.isFull()) {
            this.statistics.deltaWaitCount();
            if (this.pool.isSharable() && (this.supportsLazyAssociation == null || this.supportsLazyAssociation.booleanValue())) {
                if (this.supportsLazyAssociation == null) {
                    this.checkLazyAssociation();
                }
                if (this.supportsLazyAssociation != null && this.supportsLazyAssociation.booleanValue()) {
                    if (this.trace) {
                        this.log.tracef("Trying to detach - Pool: %s MCP: %s", this.pool.getName(), Integer.toHexString(System.identityHashCode(this)));
                    }
                    if (!this.detachConnectionListener() && this.trace) {
                        this.log.tracef("Detaching didn't succeed - Pool: %s MCP: %s", this.pool.getName(), Integer.toHexString(System.identityHashCode(this)));
                    }
                }
            }
        }
        long startWait = this.statistics.isEnabled() ? System.currentTimeMillis() : 0L;
        try {
            if (this.permits.tryAcquire(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS)) {
                if (this.statistics.isEnabled()) {
                    this.statistics.deltaTotalBlockingTime(System.currentTimeMillis() - startWait);
                }
                ConnectionListener cl = null;
                do {
                    if (this.shutdown.get()) {
                        this.permits.release();
                        throw new ResourceException(bundle.thePoolHasBeenShutdown(this.pool.getName(), Integer.toHexString(System.identityHashCode(this))));
                    }
                    ArrayList<ConnectionListener> arrayList = this.cls;
                    synchronized (arrayList) {
                        if (this.cls.size() > 0) {
                            cl = this.cls.remove(0);
                            this.checkedOut.add(cl);
                        }
                    }
                    if (this.statistics.isEnabled()) {
                        this.statistics.setInUsedCount(this.checkedOut.size());
                    }
                    if (cl == null) continue;
                    try {
                        ManagedConnection matchedMC = this.mcf.matchManagedConnections(Collections.singleton(cl.getManagedConnection()), subject, cri);
                        boolean valid = true;
                        if (matchedMC != null) {
                            block63: {
                                if (this.poolConfiguration.isValidateOnMatch()) {
                                    if (this.mcf instanceof ValidatingManagedConnectionFactory) {
                                        try {
                                            ValidatingManagedConnectionFactory vcf = (ValidatingManagedConnectionFactory)this.mcf;
                                            Set candidateSet = Collections.singleton(cl.getManagedConnection());
                                            candidateSet = vcf.getInvalidConnections(candidateSet);
                                            if (candidateSet != null && candidateSet.size() > 0) {
                                                valid = false;
                                            }
                                            break block63;
                                        }
                                        catch (Throwable t) {
                                            valid = false;
                                            if (this.trace) {
                                                this.log.tracef("Exception while ValidateOnMatch: " + t.getMessage(), t);
                                            }
                                            break block63;
                                        }
                                    }
                                    this.log.validateOnMatchNonCompliantManagedConnectionFactory(this.mcf.getClass().getName());
                                }
                            }
                            if (valid) {
                                if (this.trace) {
                                    this.log.trace("supplying ManagedConnection from pool: " + cl);
                                }
                                this.clPermits.put(cl, cl);
                                this.lastUsed = System.currentTimeMillis();
                                if (this.statistics.isEnabled()) {
                                    this.statistics.deltaTotalGetTime(this.lastUsed - startWait);
                                    this.statistics.deltaTotalPoolTime(this.lastUsed - cl.getLastUsedTime());
                                }
                                if (Tracer.isEnabled()) {
                                    Tracer.getConnectionListener(this.pool.getName(), cl, true, this.pool.isInterleaving());
                                }
                                return cl;
                            }
                        }
                        if (valid) {
                            this.log.destroyingConnectionNotSuccessfullyMatched(cl);
                        } else {
                            this.log.destroyingConnectionNotValidated(cl);
                        }
                        ArrayList<ConnectionListener> arrayList2 = this.cls;
                        synchronized (arrayList2) {
                            this.checkedOut.remove(cl);
                        }
                        if (this.statistics.isEnabled()) {
                            this.statistics.setInUsedCount(this.checkedOut.size());
                        }
                        this.doDestroy(cl);
                        cl = null;
                    }
                    catch (Throwable t) {
                        this.log.throwableWhileTryingMatchManagedConnectionThenDestroyingConnection(cl, t);
                        ArrayList<ConnectionListener> arrayList3 = this.cls;
                        synchronized (arrayList3) {
                            this.checkedOut.remove(cl);
                        }
                        if (this.statistics.isEnabled()) {
                            this.statistics.setInUsedCount(this.checkedOut.size());
                        }
                        this.doDestroy(cl);
                        cl = null;
                    }
                    if (!this.poolConfiguration.isUseFastFail()) continue;
                    if (!this.trace) break;
                    this.log.trace("Fast failing for connection attempt. No more attempts will be made to acquire connection from pool and a new connection will be created immeadiately");
                    break;
                } while (this.cls.size() > 0);
                try {
                    cl = this.createConnectionEventListener(subject, cri);
                    ArrayList<ConnectionListener> t = this.cls;
                    synchronized (t) {
                        this.checkedOut.add(cl);
                    }
                    if (this.statistics.isEnabled()) {
                        this.statistics.setInUsedCount(this.checkedOut.size());
                    }
                    if (this.trace) {
                        this.log.trace("supplying new ManagedConnection: " + cl);
                    }
                    this.clPermits.put(cl, cl);
                    this.lastUsed = System.currentTimeMillis();
                    if (this.statistics.isEnabled()) {
                        this.statistics.deltaTotalGetTime(this.lastUsed - startWait);
                    }
                    this.prefill();
                    if (this.pool.getCapacity().getIncrementer() != null) {
                        CapacityFiller.schedule(new CapacityRequest(this, subject, cri));
                    }
                    if (Tracer.isEnabled()) {
                        Tracer.getConnectionListener(this.pool.getName(), cl, false, this.pool.isInterleaving());
                    }
                    return cl;
                }
                catch (Throwable t) {
                    if (cl != null || !(t instanceof RetryableException)) {
                        this.log.throwableWhileAttemptingGetNewGonnection(cl, t);
                    }
                    if (cl != null) {
                        ArrayList<ConnectionListener> arrayList = this.cls;
                        synchronized (arrayList) {
                            this.checkedOut.remove(cl);
                        }
                        this.doDestroy(cl);
                    }
                    if (this.statistics.isEnabled()) {
                        this.statistics.setInUsedCount(this.checkedOut.size());
                    }
                    this.permits.release();
                    if (t instanceof ResourceException) {
                        throw (ResourceException)t;
                    }
                    throw new ResourceException(bundle.unexpectedThrowableWhileTryingCreateConnection(cl), t);
                }
            }
            this.statistics.deltaBlockingFailureCount();
            throw new ResourceException(bundle.noMManagedConnectionsAvailableWithinConfiguredBlockingTimeout(this.poolConfiguration.getBlockingTimeout()));
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
            long end = this.statistics.isEnabled() ? System.currentTimeMillis() - startWait : 0L;
            this.statistics.deltaTotalBlockingTime(end);
            throw new ResourceException(bundle.interruptedWhileRequestingPermit(end));
        }
    }

    @Override
    public ConnectionListener findConnectionListener(ManagedConnection mc) {
        return this.findConnectionListener(mc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionListener findConnectionListener(ManagedConnection mc, Object connection) {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            for (ConnectionListener cl : this.checkedOut) {
                if (!cl.controls(mc, connection)) continue;
                return cl;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionListener(ConnectionListener cl) {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            this.cls.add(cl);
        }
        if (this.statistics.isEnabled()) {
            this.statistics.deltaCreatedCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionListener removeConnectionListener() {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            if (this.cls.size() > 0) {
                if (this.statistics.isEnabled()) {
                    this.statistics.deltaDestroyedCount();
                }
                return this.cls.remove(0);
            }
        }
        return null;
    }

    @Override
    public void returnConnection(ConnectionListener cl, boolean kill) {
        this.returnConnection(cl, kill, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConnection(ConnectionListener cl, boolean kill, boolean cleanup) {
        ArrayList<ConnectionListener> arrayList;
        if (this.statistics.isEnabled() && cl.getState() != ConnectionState.DESTROYED) {
            this.statistics.deltaTotalUsageTime(System.currentTimeMillis() - cl.getLastUsedTime());
        }
        if (this.trace) {
            arrayList = this.cls;
            synchronized (arrayList) {
                String method = "returnConnection(" + Integer.toHexString(System.identityHashCode(cl)) + ", " + kill + ")";
                this.log.trace(ManagedConnectionPoolUtility.fullDetails(System.identityHashCode(this), method, this.mcf, this.cm, this.pool, this.poolConfiguration, this.cls, this.checkedOut, this.statistics));
            }
        } else if (this.debug) {
            String method = "returnConnection(" + Integer.toHexString(System.identityHashCode(cl)) + ", " + kill + ")";
            this.log.debug(ManagedConnectionPoolUtility.details(method, this.pool.getName(), this.statistics.getInUseCount(), this.maxSize));
        }
        if (cl.getState() == ConnectionState.DESTROYED) {
            ConnectionListener present;
            if (this.trace) {
                this.log.trace("ManagedConnection is being returned after it was destroyed: " + cl);
            }
            if ((present = (ConnectionListener)this.clPermits.remove(cl)) != null) {
                this.permits.release();
            }
            return;
        }
        if (cleanup) {
            try {
                cl.getManagedConnection().cleanup();
            }
            catch (ResourceException re) {
                this.log.resourceExceptionCleaningUpManagedConnection(cl, re);
                kill = true;
            }
        }
        if (cl.getState() == ConnectionState.DESTROY || cl.getState() == ConnectionState.DESTROYED) {
            kill = true;
        }
        if (!kill && this.isSize(this.poolConfiguration.getMaxSize() + 1)) {
            this.log.destroyingReturnedConnectionMaximumPoolSizeExceeded(cl);
            kill = true;
        }
        if (kill) {
            arrayList = this.cls;
            synchronized (arrayList) {
                this.checkedOut.remove(cl);
                this.cls.remove(cl);
                if (this.clPermits.remove(cl) != null) {
                    this.permits.release();
                }
            }
        }
        cl.used();
        arrayList = this.cls;
        synchronized (arrayList) {
            this.checkedOut.remove(cl);
            if (!this.cls.contains(cl)) {
                this.cls.add(cl);
            } else {
                this.log.attemptReturnConnectionTwice(cl, new Throwable("STACKTRACE"));
            }
            if (this.clPermits.remove(cl) != null) {
                this.permits.release();
            }
        }
        if (this.statistics.isEnabled()) {
            this.statistics.setInUsedCount(this.checkedOut.size());
        }
        if (kill) {
            if (this.trace) {
                this.log.trace("Destroying returned connection " + cl);
            }
            this.doDestroy(cl);
            cl = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(FlushMode mode) {
        ArrayList<ConnectionListener> keep = null;
        ArrayList<ConnectionListener> destroy = null;
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            ConnectionListener cl;
            if (FlushMode.ALL == mode) {
                if (this.trace) {
                    this.log.trace("Flushing pool checkedOut=" + this.checkedOut + " inPool=" + this.cls);
                }
                while (this.checkedOut.size() > 0) {
                    cl = this.checkedOut.remove(0);
                    if (this.trace) {
                        this.log.trace("Flush marking checked out connection for destruction " + cl);
                    }
                    cl.setState(ConnectionState.DESTROY);
                    if (destroy == null) {
                        destroy = new ArrayList<ConnectionListener>(1);
                    }
                    destroy.add(cl);
                    ConnectionListener present = (ConnectionListener)this.clPermits.remove(cl);
                    if (present == null) continue;
                    this.permits.release();
                }
                if (this.statistics.isEnabled()) {
                    this.statistics.setInUsedCount(this.checkedOut.size());
                }
            } else if (FlushMode.GRACEFULLY == mode) {
                if (this.trace) {
                    this.log.trace("Gracefully flushing pool checkedOut=" + this.checkedOut + " inPool=" + this.cls);
                }
                for (ConnectionListener cl2 : this.checkedOut) {
                    if (this.trace) {
                        this.log.trace("Graceful flush marking checked out connection for destruction " + cl2);
                    }
                    cl2.setState(ConnectionState.DESTROY);
                }
            }
            while (this.cls.size() > 0) {
                cl = this.cls.remove(0);
                boolean kill = true;
                if (FlushMode.INVALID == mode && this.mcf instanceof ValidatingManagedConnectionFactory) {
                    try {
                        ValidatingManagedConnectionFactory vcf = (ValidatingManagedConnectionFactory)this.mcf;
                        Set candidateSet = Collections.singleton(cl.getManagedConnection());
                        candidateSet = vcf.getInvalidConnections(candidateSet);
                        if (candidateSet == null || candidateSet.size() == 0) {
                            kill = false;
                        }
                    }
                    catch (Throwable t) {
                        this.log.trace("Exception during invalid flush", t);
                    }
                }
                if (kill) {
                    if (destroy == null) {
                        destroy = new ArrayList(1);
                    }
                    cl.setState(ConnectionState.DESTROY);
                    destroy.add(cl);
                    continue;
                }
                if (keep == null) {
                    keep = new ArrayList<ConnectionListener>(1);
                }
                keep.add(cl);
            }
            if (keep != null) {
                this.cls.addAll(keep);
            }
        }
        if (destroy != null) {
            for (ConnectionListener cl : destroy) {
                if (this.trace) {
                    this.log.trace("Destroying flushed connection " + cl);
                }
                this.doDestroy(cl);
                cl = null;
            }
        }
        this.prefill();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIdleConnections() {
        Object method;
        long timeoutSetting;
        long now = System.currentTimeMillis();
        if (now < this.lastIdleCheck + (timeoutSetting = (long)this.poolConfiguration.getIdleTimeoutMinutes() * 1000L * 60L)) {
            return;
        }
        if (this.trace) {
            this.log.tracef("Idle check - Pool: %s MCP: %s", this.pool.getName(), Integer.toHexString(System.identityHashCode(this)));
        }
        this.lastIdleCheck = now;
        ArrayList<ConnectionListener> destroyConnections = null;
        long timeout = now - timeoutSetting;
        CapacityDecrementer decrementer = this.pool.getCapacity().getDecrementer();
        boolean destroy = true;
        int destroyed = 0;
        if (decrementer == null) {
            decrementer = DefaultCapacity.DEFAULT_DECREMENTER;
        }
        if (this.trace) {
            ArrayList<ConnectionListener> arrayList = this.cls;
            synchronized (arrayList) {
                String method2 = "removeIdleConnections(" + timeout + ")";
                this.log.trace(ManagedConnectionPoolUtility.fullDetails(System.identityHashCode(this), method2, this.mcf, this.cm, this.pool, this.poolConfiguration, this.cls, this.checkedOut, this.statistics));
            }
        } else if (this.debug) {
            method = "removeIdleConnections(" + timeout + ")";
            this.log.debug(ManagedConnectionPoolUtility.details((String)method, this.pool.getName(), this.statistics.getInUseCount(), this.maxSize));
        }
        while (destroy) {
            method = this.cls;
            synchronized (method) {
                if (this.cls.size() == 0) {
                    break;
                }
                ConnectionListener cl = this.cls.get(0);
                destroy = decrementer.shouldDestroy(cl, timeout, this.cls.size() + this.checkedOut.size(), this.poolConfiguration.getMinSize(), destroyed);
                if (destroy) {
                    if (this.shouldRemove()) {
                        if (this.statistics.isEnabled()) {
                            this.statistics.deltaTimedOut();
                        }
                        if (this.trace) {
                            this.log.trace("Idle connection cl=" + cl);
                        }
                        this.cls.remove(0);
                        if (destroyConnections == null) {
                            destroyConnections = new ArrayList<ConnectionListener>(1);
                        }
                        destroyConnections.add(cl);
                        ++destroyed;
                    } else {
                        destroy = false;
                    }
                }
            }
        }
        if (destroyConnections != null) {
            for (ConnectionListener cl : destroyConnections) {
                if (this.trace) {
                    this.log.trace("Destroying connection " + cl);
                }
                this.doDestroy(cl);
                cl = null;
            }
            if (!this.shutdown.get()) {
                boolean emptyManagedConnectionPool = false;
                if ((this.poolConfiguration.isPrefill() || this.poolConfiguration.isStrictMin()) && this.pool instanceof PrefillPool) {
                    if (this.poolConfiguration.getMinSize() > 0) {
                        this.prefill();
                    } else {
                        emptyManagedConnectionPool = true;
                    }
                } else {
                    emptyManagedConnectionPool = true;
                }
                if (emptyManagedConnectionPool && this.isEmpty()) {
                    this.pool.emptyManagedConnectionPool(this);
                }
            }
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.trace) {
            this.log.tracef("Shutdown - Pool: %s MCP: %s", this.pool.getName(), Integer.toHexString(System.identityHashCode(this)));
        }
        this.shutdown.set(true);
        IdleRemover.getInstance().unregisterPool(this);
        ConnectionValidator.getInstance().unregisterPool(this);
        if (this.checkedOut.size() > 0) {
            for (ConnectionListener cl : this.checkedOut) {
                this.log.destroyingActiveConnection(this.pool.getName(), cl.getManagedConnection());
                if (!Tracer.isEnabled()) continue;
                Tracer.clearConnectionListener(this.pool.getName(), cl);
            }
        }
        this.flush(FlushMode.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillTo(int size) {
        if (size <= 0) {
            return;
        }
        if (!this.poolConfiguration.isPrefill() && !this.poolConfiguration.isStrictMin()) {
            return;
        }
        if (!(this.pool instanceof PrefillPool)) {
            return;
        }
        if (this.trace) {
            ArrayList<ConnectionListener> arrayList = this.cls;
            synchronized (arrayList) {
                String method = "fillTo(" + size + ")";
                this.log.trace(ManagedConnectionPoolUtility.fullDetails(System.identityHashCode(this), method, this.mcf, this.cm, this.pool, this.poolConfiguration, this.cls, this.checkedOut, this.statistics));
            }
        } else if (this.debug) {
            String method = "fillTo(" + size + ")";
            this.log.debug(ManagedConnectionPoolUtility.details(method, this.pool.getName(), this.statistics.getInUseCount(), this.maxSize));
        }
        while (true) {
            try {
                while (true) {
                    long startWait;
                    long l = startWait = this.statistics.isEnabled() ? System.currentTimeMillis() : 0L;
                    if (!this.permits.tryAcquire(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS)) continue;
                    if (this.statistics.isEnabled()) {
                        this.statistics.deltaTotalBlockingTime(System.currentTimeMillis() - startWait);
                    }
                    try {
                        if (this.shutdown.get()) {
                            if (this.statistics.isEnabled()) {
                                this.statistics.setInUsedCount(this.checkedOut.size());
                            }
                            return;
                        }
                        if (this.isSize(size)) {
                            if (this.statistics.isEnabled()) {
                                this.statistics.setInUsedCount(this.checkedOut.size());
                            }
                            return;
                        }
                        try {
                            ConnectionListener cl = this.createConnectionEventListener(this.defaultSubject, this.defaultCri);
                            ArrayList<ConnectionListener> arrayList = this.cls;
                            synchronized (arrayList) {
                                if (this.trace) {
                                    this.log.trace("Filling pool cl=" + cl);
                                }
                                this.cls.add(cl);
                                if (this.statistics.isEnabled()) {
                                    this.statistics.setInUsedCount(this.checkedOut.size() + 1);
                                }
                                continue;
                            }
                        }
                        catch (ResourceException re) {
                            if (this.statistics.isEnabled()) {
                                this.statistics.setInUsedCount(this.checkedOut.size());
                            }
                            this.log.unableFillPool(re);
                            this.permits.release();
                            return;
                        }
                    }
                    finally {
                        this.permits.release();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ignored) {
                Thread.interrupted();
                if (!this.trace) continue;
                this.log.trace("Interrupted while requesting permit in fillTo");
                continue;
            }
            break;
        }
    }

    @Override
    public ManagedConnectionPoolStatistics getStatistics() {
        return this.statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increaseCapacity(Subject subject, ConnectionRequestInfo cri) {
        int created = 1;
        boolean create = true;
        while (create && !this.isFull()) {
            try {
                long startWait;
                long l = startWait = this.statistics.isEnabled() ? System.currentTimeMillis() : 0L;
                if (!this.permits.tryAcquire(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS)) continue;
                if (this.statistics.isEnabled()) {
                    this.statistics.deltaTotalBlockingTime(System.currentTimeMillis() - startWait);
                }
                try {
                    if (this.shutdown.get()) {
                        this.statistics.setInUsedCount(this.checkedOut.size());
                        return;
                    }
                    int currentSize = 0;
                    ArrayList<ConnectionListener> arrayList = this.cls;
                    synchronized (arrayList) {
                        currentSize = this.cls.size() + this.checkedOut.size();
                    }
                    create = this.pool.getCapacity().getIncrementer().shouldCreate(currentSize, this.poolConfiguration.getMaxSize(), created);
                    if (!create) continue;
                    try {
                        ConnectionListener cl = this.createConnectionEventListener(subject, cri);
                        ArrayList<ConnectionListener> arrayList2 = this.cls;
                        synchronized (arrayList2) {
                            if (this.trace) {
                                this.log.trace("Capacity fill: cl=" + cl);
                            }
                            this.cls.add(cl);
                            ++created;
                            this.statistics.setInUsedCount(this.checkedOut.size() + 1);
                        }
                    }
                    catch (ResourceException re) {
                        this.statistics.setInUsedCount(this.checkedOut.size());
                        this.log.unableFillPool(re);
                        this.permits.release();
                        return;
                    }
                }
                finally {
                    this.permits.release();
                }
            }
            catch (InterruptedException ignored) {
                Thread.interrupted();
                if (!this.trace) continue;
                this.log.trace("Interrupted while requesting permit in increaseCapacity");
            }
        }
        this.statistics.setInUsedCount(this.checkedOut.size());
    }

    private ConnectionListener createConnectionEventListener(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        long start = this.statistics.isEnabled() ? System.currentTimeMillis() : 0L;
        ManagedConnection mc = this.mcf.createManagedConnection(subject, cri);
        if (this.statistics.isEnabled()) {
            this.statistics.deltaTotalCreationTime(System.currentTimeMillis() - start);
            this.statistics.deltaCreatedCount();
        }
        try {
            return this.cm.createConnectionListener(mc, this);
        }
        catch (ResourceException re) {
            if (this.statistics.isEnabled()) {
                this.statistics.deltaDestroyedCount();
            }
            mc.destroy();
            throw re;
        }
    }

    void doDestroy(ConnectionListener cl) {
        ManagedConnection mc;
        block5: {
            if (cl.getState() == ConnectionState.DESTROYED) {
                if (this.trace) {
                    this.log.trace("ManagedConnection is already destroyed " + cl);
                }
                return;
            }
            if (this.statistics.isEnabled()) {
                this.statistics.deltaDestroyedCount();
            }
            cl.setState(ConnectionState.DESTROYED);
            mc = cl.getManagedConnection();
            try {
                mc.destroy();
            }
            catch (Throwable t) {
                if (!this.debug) break block5;
                this.log.debug("Exception destroying ManagedConnection " + cl, t);
            }
        }
        mc.removeConnectionEventListener((ConnectionEventListener)cl);
    }

    private boolean shouldRemove() {
        boolean remove = true;
        if (this.poolConfiguration.isStrictMin()) {
            remove = this.isSize(this.poolConfiguration.getMinSize() + 1);
            if (this.trace) {
                this.log.trace("StrictMin is active. Current connection will be removed is " + remove);
            }
        }
        return remove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void validateConnections() throws Exception {
        block36: {
            if (this.trace) {
                this.log.trace("Attempting to  validate connections for pool " + this);
            }
            if (this.trace) {
                var1_1 = this.cls;
                synchronized (var1_1) {
                    method = "validateConnections()";
                    this.log.trace(ManagedConnectionPoolUtility.fullDetails(System.identityHashCode(this), method, this.mcf, this.cm, this.pool, this.poolConfiguration, this.cls, this.checkedOut, this.statistics));
                }
            } else if (this.debug) {
                method = "validateConnections()";
                this.log.debug(ManagedConnectionPoolUtility.details(method, this.pool.getName(), this.statistics.getInUseCount(), this.maxSize));
            }
            if (!this.permits.tryAcquire(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS)) break block36;
            anyDestroyed = false;
            block23: while (true) {
                while (true) lbl-1000:
                // 3 sources

                {
                    cl = null;
                    destroyed = false;
                    var4_6 = this.cls;
                    synchronized (var4_6) {
                        if (this.cls.size() == 0) {
                            break block36;
                        }
                        cl = this.removeForFrequencyCheck();
                    }
                    if (cl == null) {
                        break block36;
                    }
                    try {
                        candidateSet = Collections.singleton(cl.getManagedConnection());
                        if (this.mcf instanceof ValidatingManagedConnectionFactory) {
                            vcf = (ValidatingManagedConnectionFactory)this.mcf;
                            if ((candidateSet = vcf.getInvalidConnections(candidateSet)) != null && candidateSet.size() > 0 && cl.getState() != ConnectionState.DESTROY) {
                                this.doDestroy(cl);
                                cl = null;
                                destroyed = true;
                                anyDestroyed = true;
                            }
                        } else {
                            this.log.backgroundValidationNonCompliantManagedConnectionFactory();
                        }
                        if (destroyed) ** GOTO lbl-1000
                        candidateSet = this.cls;
                    }
                    catch (ResourceException re) {
                        if (cl != null) {
                            this.doDestroy(cl);
                            cl = null;
                            destroyed = true;
                            anyDestroyed = true;
                        }
                        this.log.connectionValidatorIgnoredUnexpectedError(re);
                        continue block23;
                    }
                    finally {
                        if (destroyed) continue;
                        var4_6 = this.cls;
                        synchronized (var4_6) {
                            this.returnForFrequencyCheck(cl);
                        }
                        continue block23;
                    }
                    synchronized (candidateSet) {
                        this.returnForFrequencyCheck(cl);
                        continue block23;
                    }
                    break;
                }
                break;
            }
            finally {
                this.permits.release();
                if (anyDestroyed) {
                    this.prefill();
                }
            }
        }
    }

    String getPoolName() {
        if (this.pool == null) {
            return "";
        }
        return this.pool.getName();
    }

    private ConnectionListener removeForFrequencyCheck() {
        ConnectionListener cl2 = null;
        for (ConnectionListener cl2 : this.cls) {
            long lastCheck = cl2.getLastValidatedTime();
            if (System.currentTimeMillis() - lastCheck >= this.poolConfiguration.getBackgroundValidationMillis()) {
                this.cls.remove(cl2);
                break;
            }
            cl2 = null;
        }
        if (this.debug) {
            this.log.debugf("Checking for connection within frequency: %s", cl2);
        }
        return cl2;
    }

    private void returnForFrequencyCheck(ConnectionListener cl) {
        if (this.debug) {
            this.log.debugf("Returning for connection within frequency: %s", cl);
        }
        cl.setLastValidatedTime(System.currentTimeMillis());
        this.cls.add(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLazyAssociation() {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            ConnectionListener cl = null;
            if (this.checkedOut.size() > 0) {
                cl = this.checkedOut.get(0);
            }
            if (cl == null && this.cls.size() > 0) {
                cl = this.cls.get(0);
            }
            if (cl != null) {
                if (cl.supportsLazyAssociation()) {
                    if (this.debug) {
                        this.log.debug("Enable lazy association support for: " + this.pool.getName());
                    }
                    this.supportsLazyAssociation = Boolean.TRUE;
                } else {
                    if (this.debug) {
                        this.log.debug("Disable lazy association support for: " + this.pool.getName());
                    }
                    this.supportsLazyAssociation = Boolean.FALSE;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean detachConnectionListener() {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            block10: {
                ConnectionListener cl2 = null;
                try {
                    for (ConnectionListener cl2 : this.checkedOut) {
                        if (cl2.isEnlisted()) continue;
                        if (this.trace) {
                            this.log.tracef("Detach: %s", cl2);
                        }
                        DissociatableManagedConnection dmc = (DissociatableManagedConnection)cl2.getManagedConnection();
                        dmc.dissociateConnections();
                        cl2.unregisterConnections();
                        if (Tracer.isEnabled()) {
                            Tracer.returnConnectionListener(this.pool.getName(), cl2, false, this.pool.isInterleaving());
                        }
                        this.returnConnection(cl2, false, false);
                        return true;
                    }
                }
                catch (Throwable t) {
                    if (this.debug) {
                        this.log.debug("Exception during detach for: " + this.pool.getName(), t);
                    }
                    this.supportsLazyAssociation = Boolean.FALSE;
                    if (cl2 == null) break block10;
                    if (Tracer.isEnabled()) {
                        Tracer.returnConnectionListener(this.pool.getName(), cl2, true, this.pool.isInterleaving());
                    }
                    this.returnConnection(cl2, true, true);
                }
            }
        }
        return false;
    }

    @Override
    public String[] dumpQueuedThreads() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.permits.hasQueuedThreads()) {
            ArrayList<Thread> queuedThreads = new ArrayList<Thread>(this.permits.getQueuedThreads());
            for (Thread t : queuedThreads) {
                result.add(this.dumpQueuedThread(t));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private String dumpQueuedThread(Thread t) {
        StringBuilder sb = new StringBuilder();
        sb = sb.append("Queued thread: ");
        sb = sb.append(t.getName());
        sb = sb.append(newLine);
        StackTraceElement[] stes = SecurityActions.getStackTrace(t);
        if (stes != null) {
            for (StackTraceElement ste : stes) {
                sb = sb.append("  ");
                sb = sb.append(ste.getClassName());
                sb = sb.append(":");
                sb = sb.append(ste.getMethodName());
                sb = sb.append(":");
                sb = sb.append(ste.getLineNumber());
                sb = sb.append(newLine);
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SemaphoreArrayListManagedConnectionPool@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[pool=").append(this.pool.getName());
        sb.append("]");
        return sb.toString();
    }
}

