/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.collections;

import java.util.Arrays;
import org.apache.lucene.util.collections.IntIterator;

public class IntToIntMap {
    public static final int GROUD = -1;
    private static int defaultCapacity = 16;
    int[] baseHash;
    private int capacity = 16;
    private int firstEmpty;
    private int hashFactor;
    int[] keys;
    int[] next;
    private int prev;
    private int size;
    int[] values;

    public IntToIntMap() {
        this(defaultCapacity);
    }

    public IntToIntMap(int capacity) {
        while (this.capacity < capacity) {
            this.capacity <<= 1;
        }
        int arrayLength = this.capacity + 1;
        this.values = new int[arrayLength];
        this.keys = new int[arrayLength];
        this.next = new int[arrayLength];
        this.values[0] = -1;
        int baseHashSize = this.capacity << 1;
        this.baseHash = new int[baseHashSize];
        this.hashFactor = baseHashSize - 1;
        this.size = 0;
        this.clear();
    }

    private void prvt_put(int key, int e) {
        int hashIndex = this.calcBaseHashIndex(key);
        int objectIndex = this.firstEmpty;
        this.firstEmpty = this.next[this.firstEmpty];
        this.values[objectIndex] = e;
        this.keys[objectIndex] = key;
        this.next[objectIndex] = this.baseHash[hashIndex];
        this.baseHash[hashIndex] = objectIndex;
        ++this.size;
    }

    protected int calcBaseHashIndex(int key) {
        return key & this.hashFactor;
    }

    public void clear() {
        Arrays.fill(this.baseHash, 0);
        this.size = 0;
        this.firstEmpty = 1;
        int i = 1;
        while (i < this.capacity) {
            this.next[i++] = i;
        }
        this.next[this.capacity] = 0;
    }

    public boolean containsKey(int key) {
        return this.find(key) != 0;
    }

    public boolean containsValue(int v) {
        IntIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (v != iterator.next()) continue;
            return true;
        }
        return false;
    }

    protected int find(int key) {
        int baseHashIndex = this.calcBaseHashIndex(key);
        int localIndex = this.baseHash[baseHashIndex];
        while (localIndex != 0) {
            if (this.keys[localIndex] == key) {
                return localIndex;
            }
            localIndex = this.next[localIndex];
        }
        return 0;
    }

    private int findForRemove(int key, int baseHashIndex) {
        this.prev = 0;
        int index = this.baseHash[baseHashIndex];
        while (index != 0) {
            if (this.keys[index] == key) {
                return index;
            }
            this.prev = index;
            index = this.next[index];
        }
        this.prev = 0;
        return 0;
    }

    public int get(int key) {
        return this.values[this.find(key)];
    }

    protected void grow() {
        IntToIntMap that = new IntToIntMap(this.capacity * 2);
        IndexIterator iterator = new IndexIterator();
        while (iterator.hasNext()) {
            int index = iterator.next();
            that.prvt_put(this.keys[index], this.values[index]);
        }
        this.capacity = that.capacity;
        this.size = that.size;
        this.firstEmpty = that.firstEmpty;
        this.values = that.values;
        this.keys = that.keys;
        this.next = that.next;
        this.baseHash = that.baseHash;
        this.hashFactor = that.hashFactor;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public IntIterator iterator() {
        return new ValueIterator();
    }

    public IntIterator keyIterator() {
        return new KeyIterator();
    }

    private void printBaseHash() {
        for (int i = 0; i < this.baseHash.length; ++i) {
            System.out.println(i + ".\t" + this.baseHash[i]);
        }
    }

    public int put(int key, int e) {
        int index = this.find(key);
        if (index != 0) {
            int old = this.values[index];
            this.values[index] = e;
            return old;
        }
        if (this.size == this.capacity) {
            this.grow();
        }
        this.prvt_put(key, e);
        return 0;
    }

    public int remove(int key) {
        int baseHashIndex = this.calcBaseHashIndex(key);
        int index = this.findForRemove(key, baseHashIndex);
        if (index != 0) {
            if (this.prev == 0) {
                this.baseHash[baseHashIndex] = this.next[index];
            }
            this.next[this.prev] = this.next[index];
            this.next[index] = this.firstEmpty;
            this.firstEmpty = index;
            --this.size;
            return this.values[index];
        }
        return 0;
    }

    public int size() {
        return this.size;
    }

    public int[] toArray() {
        int j = -1;
        int[] array = new int[this.size];
        IntIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            array[++j] = iterator.next();
        }
        return array;
    }

    public int[] toArray(int[] a) {
        int j = 0;
        if (a.length < this.size) {
            a = new int[this.size];
        }
        IntIterator iterator = this.iterator();
        while (j < a.length && iterator.hasNext()) {
            a[j] = iterator.next();
            ++j;
        }
        return a;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        IntIterator keyIterator = this.keyIterator();
        while (keyIterator.hasNext()) {
            int key = keyIterator.next();
            sb.append(key);
            sb.append('=');
            sb.append(this.get(key));
            if (!keyIterator.hasNext()) continue;
            sb.append(',');
            sb.append(' ');
        }
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.size();
    }

    public boolean equals(Object o) {
        IntToIntMap that = (IntToIntMap)o;
        if (that.size() != this.size()) {
            return false;
        }
        IntIterator it = this.keyIterator();
        while (it.hasNext()) {
            int v2;
            int key = it.next();
            if (!that.containsKey(key)) {
                return false;
            }
            int v1 = this.get(key);
            if (v1 == (v2 = that.get(key))) continue;
            return false;
        }
        return true;
    }

    private final class ValueIterator
    implements IntIterator {
        private IntIterator iterator;

        ValueIterator() {
            this.iterator = new IndexIterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public int next() {
            return IntToIntMap.this.values[this.iterator.next()];
        }

        public void remove() {
            this.iterator.remove();
        }
    }

    private final class KeyIterator
    implements IntIterator {
        private IntIterator iterator;

        KeyIterator() {
            this.iterator = new IndexIterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public int next() {
            return IntToIntMap.this.keys[this.iterator.next()];
        }

        public void remove() {
            this.iterator.remove();
        }
    }

    private final class IndexIterator
    implements IntIterator {
        private int baseHashIndex = 0;
        private int index = 0;
        private int lastIndex = 0;

        public IndexIterator() {
            while (this.baseHashIndex < IntToIntMap.this.baseHash.length) {
                this.index = IntToIntMap.this.baseHash[this.baseHashIndex];
                if (this.index != 0) break;
                ++this.baseHashIndex;
            }
        }

        public boolean hasNext() {
            return this.index != 0;
        }

        public int next() {
            this.lastIndex = this.index;
            this.index = IntToIntMap.this.next[this.index];
            while (this.index == 0 && ++this.baseHashIndex < IntToIntMap.this.baseHash.length) {
                this.index = IntToIntMap.this.baseHash[this.baseHashIndex];
            }
            return this.lastIndex;
        }

        public void remove() {
            IntToIntMap.this.remove(IntToIntMap.this.keys[this.lastIndex]);
        }
    }
}

