/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.processor;

import java.util.Collections;
import java.util.List;
import org.apache.wss4j.common.crypto.AlgorithmSuite;
import org.apache.wss4j.common.crypto.AlgorithmSuiteValidator;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.DerivedKeyToken;
import org.apache.wss4j.dom.processor.Processor;
import org.apache.wss4j.dom.str.DerivedKeyTokenSTRParser;
import org.w3c.dom.Element;

public class DerivedKeyTokenProcessor
implements Processor {
    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        DerivedKeyToken dkt = new DerivedKeyToken(elem, data.getBSPEnforcer());
        AlgorithmSuite algorithmSuite = data.getAlgorithmSuite();
        if (algorithmSuite != null) {
            AlgorithmSuiteValidator algorithmSuiteValidator = new AlgorithmSuiteValidator(algorithmSuite);
            algorithmSuiteValidator.checkDerivedKeyAlgorithm(dkt.getAlgorithm());
        }
        byte[] secret = null;
        Element secRefElement = dkt.getSecurityTokenReferenceElement();
        if (secRefElement == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, "noReference", new Object[0]);
        }
        DerivedKeyTokenSTRParser strParser = new DerivedKeyTokenSTRParser();
        strParser.parseSecurityTokenReference(secRefElement, data, wsDocInfo, null);
        secret = strParser.getSecretKey();
        String tempNonce = dkt.getNonce();
        if (tempNonce == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", new Object[]{"Missing wsc:Nonce value"});
        }
        int length = dkt.getLength();
        byte[] keyBytes = dkt.deriveKey(length, secret);
        WSSecurityEngineResult result = new WSSecurityEngineResult(2048, null, keyBytes, null);
        wsDocInfo.addTokenElement(elem);
        result.put("id", dkt.getID());
        result.put("derived-key-token", dkt);
        result.put("secret", secret);
        result.put("token-element", dkt.getElement());
        wsDocInfo.addResult(result);
        return Collections.singletonList(result);
    }
}

