/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlSchemaDateFormat
extends DateFormat {
    private static final long serialVersionUID = 5152684993503882396L;
    private static final Logger LOG = LoggerFactory.getLogger(XmlSchemaDateFormat.class);
    private static final DateFormat DATEFORMAT_XSD_ZULU = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    @Override
    public void setLenient(boolean lenient) {
        DATEFORMAT_XSD_ZULU.setLenient(lenient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date parse(String src, ParsePosition parsePos) {
        Date date;
        int index = 0;
        try {
            if (src != null) {
                if (src.charAt(0) == '+' || src.charAt(0) == '-') {
                    src = src.substring(1);
                }
                if (src.length() < 19) {
                    parsePos.setIndex(src.length() - 1);
                    this.handleParseError(parsePos, "TOO_FEW_CHARS");
                }
                index = 4;
                this.validateChar(src, parsePos, 4, '-', "EXPECTED_DASH");
                index = 7;
                this.validateChar(src, parsePos, 7, '-', "EXPECTED_DASH");
                index = 10;
                this.validateChar(src, parsePos, 10, 'T', "EXPECTED_CAPITAL_T");
                index = 13;
                this.validateChar(src, parsePos, 13, ':', "EXPECTED_COLON_IN_TIME");
                index = 16;
                this.validateChar(src, parsePos, 16, ':', "EXPECTED_COLON_IN_TIME");
            }
            DateFormat dateFormat = DATEFORMAT_XSD_ZULU;
            synchronized (dateFormat) {
                date = DATEFORMAT_XSD_ZULU.parse(src == null ? null : src.substring(0, 19) + ".000Z");
            }
            index = 19;
            if (src != null) {
                if (index < src.length() && src.charAt(index) == '.') {
                    int milliseconds = 0;
                    int start = ++index;
                    while (index < src.length() && Character.isDigit(src.charAt(index))) {
                        ++index;
                    }
                    String decimal = src.substring(start, index);
                    if (decimal.length() == 3) {
                        milliseconds = Integer.parseInt(decimal);
                    } else if (decimal.length() < 3) {
                        String substring = decimal + "000";
                        milliseconds = Integer.parseInt(substring.substring(0, 3));
                    } else {
                        milliseconds = Integer.parseInt(decimal.substring(0, 3));
                        if (decimal.charAt(3) >= '5') {
                            ++milliseconds;
                        }
                    }
                    date.setTime(date.getTime() + (long)milliseconds);
                }
                if (index + 5 < src.length() && (src.charAt(index) == '+' || src.charAt(index) == '-')) {
                    this.validateCharIsDigit(src, parsePos, index + 1, "EXPECTED_NUMERAL");
                    this.validateCharIsDigit(src, parsePos, index + 2, "EXPECTED_NUMERAL");
                    this.validateChar(src, parsePos, index + 3, ':', "EXPECTED_COLON_IN_TIMEZONE");
                    this.validateCharIsDigit(src, parsePos, index + 4, "EXPECTED_NUMERAL");
                    this.validateCharIsDigit(src, parsePos, index + 5, "EXPECTED_NUMERAL");
                    int hours = (src.charAt(index + 1) - 48) * 10 + src.charAt(index + 2) - 48;
                    int mins = (src.charAt(index + 4) - 48) * 10 + src.charAt(index + 5) - 48;
                    int millisecs = (hours * 60 + mins) * 60 * 1000;
                    if (src.charAt(index) == '+') {
                        millisecs = -millisecs;
                    }
                    date.setTime(date.getTime() + (long)millisecs);
                    index += 6;
                }
                if (index < src.length() && src.charAt(index) == 'Z') {
                    ++index;
                }
                if (index < src.length()) {
                    this.handleParseError(parsePos, "TOO_MANY_CHARS");
                }
            }
        }
        catch (ParseException pe) {
            LOG.error(pe.toString(), (Throwable)pe);
            index = 0;
            parsePos.setErrorIndex(index);
            date = null;
        }
        parsePos.setIndex(index);
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuffer format(Date date, StringBuffer appendBuf, FieldPosition fieldPos) {
        String str;
        DateFormat dateFormat = DATEFORMAT_XSD_ZULU;
        synchronized (dateFormat) {
            str = DATEFORMAT_XSD_ZULU.format(date);
        }
        if (appendBuf == null) {
            appendBuf = new StringBuffer();
        }
        appendBuf.append(str);
        return appendBuf;
    }

    private void validateChar(String str, ParsePosition parsePos, int index, char expected, String errorReason) throws ParseException {
        if (str.charAt(index) != expected) {
            this.handleParseError(parsePos, errorReason);
        }
    }

    private void validateCharIsDigit(String str, ParsePosition parsePos, int index, String errorReason) throws ParseException {
        if (!Character.isDigit(str.charAt(index))) {
            this.handleParseError(parsePos, errorReason);
        }
    }

    private void handleParseError(ParsePosition parsePos, String errorReason) throws ParseException {
        throw new ParseException("INVALID_XSD_DATETIME: " + errorReason, parsePos.getErrorIndex());
    }

    static {
        DATEFORMAT_XSD_ZULU.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

