/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.tomcat;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.ee.structure.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.tomcat.SecurityMetaDataAccessorEJB;
import org.jboss.as.webservices.tomcat.SecurityMetaDataAccessorEJB3;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WebMetaDataHelper;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.merge.javaee.spec.SecurityRolesMetaDataMerger;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.jboss.metadata.web.spec.SecurityConstraintMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionsMetaData;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.HttpEndpoint;

final class WebMetaDataCreator {
    private static final String EJB_WEBSERVICE_REALM = "EJBWebServiceEndpointServlet Realm";
    private final SecurityMetaDataAccessorEJB ejb3SecurityAccessor = new SecurityMetaDataAccessorEJB3();

    WebMetaDataCreator() {
    }

    void create(Deployment dep) {
        JBossWebMetaData jbossWebMD;
        DeploymentUnit unit = (DeploymentUnit)WSHelper.getRequiredAttachment((Deployment)dep, DeploymentUnit.class);
        WarMetaData warMD = (WarMetaData)ASHelper.getOptionalAttachment(unit, WarMetaData.ATTACHMENT_KEY);
        JBossWebMetaData jBossWebMetaData = jbossWebMD = warMD != null ? warMD.getMergedJBossWebMetaData() : null;
        if (warMD == null) {
            warMD = new WarMetaData();
        }
        if (jbossWebMD == null) {
            jbossWebMD = new JBossWebMetaData();
            warMD.setMergedJBossWebMetaData(jbossWebMD);
            unit.putAttachment(WarMetaData.ATTACHMENT_KEY, (Object)warMD);
        }
        this.createWebAppDescriptor(dep, jbossWebMD);
        this.createJBossWebAppDescriptor(dep, jbossWebMD);
        dep.addAttachment(JBossWebMetaData.class, (Object)jbossWebMD);
    }

    private void createWebAppDescriptor(Deployment dep, JBossWebMetaData jbossWebMD) {
        WSLogger.ROOT_LOGGER.trace("Creating web.xml descriptor");
        this.createServlets(dep, jbossWebMD);
        this.createServletMappings(dep, jbossWebMD);
        this.createSecurityConstraints(dep, jbossWebMD);
        this.createLoginConfig(dep, jbossWebMD);
        this.createSecurityRoles(dep, jbossWebMD);
    }

    private void createJBossWebAppDescriptor(Deployment dep, JBossWebMetaData jbossWebMD) {
        String virtualHost;
        boolean hasSecurityDomain;
        WSLogger.ROOT_LOGGER.trace("Creating jboss-web.xml descriptor");
        String securityDomain = this.ejb3SecurityAccessor.getSecurityDomain(dep);
        boolean bl = hasSecurityDomain = securityDomain != null;
        if (hasSecurityDomain) {
            WSLogger.ROOT_LOGGER.tracef("Setting security domain: %s", securityDomain);
            jbossWebMD.setSecurityDomain(securityDomain);
        }
        if ((virtualHost = dep.getService().getVirtualHost()) != null) {
            WSLogger.ROOT_LOGGER.tracef("Setting virtual host: %s", virtualHost);
            jbossWebMD.setVirtualHosts(Arrays.asList(virtualHost));
        }
    }

    private void createServlets(Deployment dep, JBossWebMetaData jbossWebMD) {
        WSLogger.ROOT_LOGGER.trace("Creating servlets");
        JBossServletsMetaData servlets = WebMetaDataHelper.getServlets(jbossWebMD);
        for (Endpoint endpoint : dep.getService().getEndpoints()) {
            String endpointName = endpoint.getShortName();
            String endpointClassName = endpoint.getTargetBeanName();
            WSLogger.ROOT_LOGGER.tracef("Servlet name: %s, class: %s", endpointName, endpointClassName);
            WebMetaDataHelper.newServlet(endpointName, endpointClassName, servlets);
        }
    }

    private void createServletMappings(Deployment dep, JBossWebMetaData jbossWebMD) {
        WSLogger.ROOT_LOGGER.trace("Creating servlet mappings");
        List<ServletMappingMetaData> servletMappings = WebMetaDataHelper.getServletMappings(jbossWebMD);
        for (Endpoint ep : dep.getService().getEndpoints()) {
            if (!(ep instanceof HttpEndpoint)) continue;
            String endpointName = ep.getShortName();
            List<String> urlPatterns = WebMetaDataHelper.getUrlPatterns(((HttpEndpoint)ep).getURLPattern());
            WSLogger.ROOT_LOGGER.tracef("Servlet name: %s, URL patterns: %s", endpointName, urlPatterns);
            WebMetaDataHelper.newServletMapping(endpointName, urlPatterns, servletMappings);
        }
    }

    private void createSecurityConstraints(Deployment dep, JBossWebMetaData jbossWebMD) {
        WSLogger.ROOT_LOGGER.trace("Creating security constraints");
        for (Endpoint ejbEndpoint : dep.getService().getEndpoints()) {
            boolean hasAuthMethod;
            boolean secureWsdlAccess = this.ejb3SecurityAccessor.isSecureWsdlAccess(ejbEndpoint);
            String transportGuarantee = this.ejb3SecurityAccessor.getTransportGuarantee(ejbEndpoint);
            boolean hasTransportGuarantee = transportGuarantee != null;
            String authMethod = this.ejb3SecurityAccessor.getAuthMethod(ejbEndpoint);
            boolean bl = hasAuthMethod = authMethod != null;
            if (!(ejbEndpoint instanceof HttpEndpoint) || !hasAuthMethod && !hasTransportGuarantee) continue;
            List<SecurityConstraintMetaData> securityConstraints = WebMetaDataHelper.getSecurityConstraints(jbossWebMD);
            SecurityConstraintMetaData securityConstraint = WebMetaDataHelper.newSecurityConstraint(securityConstraints);
            WebResourceCollectionsMetaData webResourceCollections = WebMetaDataHelper.getWebResourceCollections(securityConstraint);
            String endpointName = ejbEndpoint.getShortName();
            String urlPattern = ((HttpEndpoint)ejbEndpoint).getURLPattern();
            WSLogger.ROOT_LOGGER.tracef("Creating web resource collection for endpoint: %s, URL pattern: %s", endpointName, urlPattern);
            WebMetaDataHelper.newWebResourceCollection(endpointName, urlPattern, secureWsdlAccess, webResourceCollections);
            if (hasAuthMethod) {
                WSLogger.ROOT_LOGGER.tracef("Creating auth constraint for endpoint: %s", endpointName);
                WebMetaDataHelper.newAuthConstraint(WebMetaDataHelper.getAllRoles(), securityConstraint);
            }
            if (!hasTransportGuarantee) continue;
            WSLogger.ROOT_LOGGER.tracef("Creating new user data constraint for endpoint: %s, transport guarantee: %s", endpointName, transportGuarantee);
            WebMetaDataHelper.newUserDataConstraint(transportGuarantee, securityConstraint);
        }
    }

    private void createLoginConfig(Deployment dep, JBossWebMetaData jbossWebMD) {
        boolean hasAuthMethod;
        String authMethod = this.getAuthMethod(dep);
        boolean bl = hasAuthMethod = authMethod != null;
        if (hasAuthMethod) {
            WSLogger.ROOT_LOGGER.tracef("Creating new login config: %s, auth method: %s", EJB_WEBSERVICE_REALM, authMethod);
            LoginConfigMetaData loginConfig = WebMetaDataHelper.getLoginConfig(jbossWebMD);
            loginConfig.setRealmName(EJB_WEBSERVICE_REALM);
            loginConfig.setAuthMethod(authMethod);
        }
    }

    private void createSecurityRoles(Deployment dep, JBossWebMetaData jbossWebMD) {
        EarMetaData earMetaData;
        DeploymentUnit unit;
        DeploymentUnit parent;
        boolean hasAuthMethod;
        String authMethod = this.getAuthMethod(dep);
        boolean bl = hasAuthMethod = authMethod != null;
        if (hasAuthMethod) {
            boolean hasSecurityRolesMD;
            SecurityRolesMetaData securityRolesMD = this.ejb3SecurityAccessor.getSecurityRoles(dep);
            boolean bl2 = hasSecurityRolesMD = securityRolesMD != null && !securityRolesMD.isEmpty();
            if (hasSecurityRolesMD) {
                WSLogger.ROOT_LOGGER.trace("Setting security roles");
                jbossWebMD.setSecurityRoles(securityRolesMD);
            }
        }
        if ((parent = (unit = (DeploymentUnit)dep.getAttachment(DeploymentUnit.class)).getParent()) != null && (earMetaData = (EarMetaData)parent.getAttachment(Attachments.EAR_METADATA)) != null) {
            SecurityRolesMetaData earSecurityRolesMetaData;
            if (jbossWebMD.getSecurityRoles() == null) {
                jbossWebMD.setSecurityRoles(new SecurityRolesMetaData());
            }
            if ((earSecurityRolesMetaData = earMetaData.getSecurityRoles()) != null) {
                SecurityRolesMetaDataMerger.merge((SecurityRolesMetaData)jbossWebMD.getSecurityRoles(), (SecurityRolesMetaData)jbossWebMD.getSecurityRoles(), (SecurityRolesMetaData)earSecurityRolesMetaData);
            }
        }
    }

    private String getAuthMethod(Deployment dep) {
        for (Endpoint ejbEndpoint : dep.getService().getEndpoints()) {
            String beanAuthMethod = this.ejb3SecurityAccessor.getAuthMethod(ejbEndpoint);
            boolean hasBeanAuthMethod = beanAuthMethod != null;
            if (!hasBeanAuthMethod) continue;
            return beanAuthMethod;
        }
        return null;
    }
}

