/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.extension.mod_cluster.CustomLoadMetricDefinition;
import org.wildfly.extension.mod_cluster.DynamicLoadProviderDefinition;
import org.wildfly.extension.mod_cluster.LoadMetricDefinition;
import org.wildfly.extension.mod_cluster.ModClusterConfigResourceDefinition;
import org.wildfly.extension.mod_cluster.ModClusterLogger;
import org.wildfly.extension.mod_cluster.ModClusterModel;
import org.wildfly.extension.mod_cluster.ModClusterSSLResourceDefinition;
import org.wildfly.extension.mod_cluster.ModClusterSubsystemResourceDefinition;
import org.wildfly.extension.mod_cluster.ModClusterSubsystemXMLWriter;
import org.wildfly.extension.mod_cluster.Namespace;

public class ModClusterExtension
implements XMLStreamConstants,
Extension {
    public static final String SUBSYSTEM_NAME = "modcluster";
    private static final String RESOURCE_NAME = ModClusterExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final SensitivityClassification MOD_CLUSTER_SECURITY = new SensitivityClassification("modcluster", "mod_cluster-security", false, true, true);
    static final SensitiveTargetAccessConstraintDefinition MOD_CLUSTER_SECURITY_DEF = new SensitiveTargetAccessConstraintDefinition(MOD_CLUSTER_SECURITY);
    static final SensitivityClassification MOD_CLUSTER_PROXIES = new SensitivityClassification("modcluster", "mod_cluster-proxies", false, false, false);
    static final SensitiveTargetAccessConstraintDefinition MOD_CLUSTER_PROXIES_DEF = new SensitiveTargetAccessConstraintDefinition(MOD_CLUSTER_PROXIES);

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, ModClusterExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        ModClusterLogger.ROOT_LOGGER.debugf("Activating mod_cluster extension", new Object[0]);
        ModelVersion current = ModClusterModel.CURRENT.getVersion();
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, current.getMajor(), current.getMinor(), current.getMicro());
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)new ModClusterSubsystemResourceDefinition(context.isRuntimeOnlyRegistrationValid()));
        ManagementResourceRegistration configuration = registration.registerSubModel((ResourceDefinition)new ModClusterConfigResourceDefinition());
        configuration.registerSubModel((ResourceDefinition)new ModClusterSSLResourceDefinition());
        ManagementResourceRegistration dynamicLoadProvider = configuration.registerSubModel((ResourceDefinition)DynamicLoadProviderDefinition.INSTANCE);
        dynamicLoadProvider.registerSubModel((ResourceDefinition)LoadMetricDefinition.INSTANCE);
        dynamicLoadProvider.registerSubModel((ResourceDefinition)CustomLoadMetricDefinition.INSTANCE);
        subsystem.registerXMLElementWriter((XMLElementWriter)new ModClusterSubsystemXMLWriter());
        if (context.isRegisterTransformers()) {
            for (ModClusterModel model : EnumSet.complementOf(EnumSet.of(ModClusterModel.CURRENT))) {
                ModelVersion version = model.getVersion();
                TransformationDescription.Tools.register((TransformationDescription)ModClusterSubsystemResourceDefinition.buildTransformation(version), (SubsystemRegistration)subsystem, (ModelVersionRange)version);
            }
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (Namespace namespace : Namespace.values()) {
            XMLElementReader<List<ModelNode>> reader = namespace.getXMLReader();
            if (reader == null) continue;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, namespace.getUri(), namespace.getXMLReader());
        }
    }
}

