/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.mod_cluster.ModClusterLogger;

public class ProxyListValidator
implements ParameterValidator {
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        if (value.isDefined()) {
            String[] results;
            String str = value.asString();
            for (String result : results = str.split(",")) {
                int i = result.lastIndexOf(":");
                int port = 0;
                String host = null;
                if (i > 0) {
                    host = result.substring(0, i);
                    port = Integer.valueOf(result.substring(i + 1));
                }
                try {
                    InetAddress.getByName(host);
                }
                catch (UnknownHostException e) {
                    host = null;
                }
                if (host != null && port != 0) continue;
                throw new OperationFailedException(new ModelNode().set(ModClusterLogger.ROOT_LOGGER.needHostAndPort()));
            }
        }
    }

    public void validateResolvedParameter(String parameterName, ModelNode value) throws OperationFailedException {
        this.validateParameter(parameterName, value.resolve());
    }
}

