/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.transport.jms.util.AbstractMessageListenerContainer;
import org.apache.cxf.transport.jms.util.ResourceCloser;

public class PollingMessageListenerContainer
extends AbstractMessageListenerContainer {
    private static final Logger LOG = LogUtils.getL7dLogger(PollingMessageListenerContainer.class);
    private ExecutorService pollers;
    private int numListenerThreads = 1;

    public PollingMessageListenerContainer(Connection connection, Destination destination, MessageListener listenerHandler) {
        this.connection = connection;
        this.destination = destination;
        this.listenerHandler = listenerHandler;
    }

    private void safeRollBack(Session session, Exception e) {
        LOG.log(Level.WARNING, "Exception while processing jms message in cxf. Rolling back", e);
        try {
            if (this.transactionManager != null) {
                this.transactionManager.rollback();
            } else {
                session.rollback();
            }
        }
        catch (Exception e1) {
            LOG.log(Level.WARNING, "Rollback of Local transaction failed", e1);
        }
    }

    @Override
    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.pollers = Executors.newFixedThreadPool(this.numListenerThreads);
        for (int c = 0; c < this.numListenerThreads; ++c) {
            this.pollers.execute(new Poller());
        }
    }

    @Override
    public void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.pollers.shutdown();
        try {
            this.pollers.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.pollers = null;
    }

    @Override
    public void shutdown() {
        this.stop();
        ResourceCloser.close(this.connection);
    }

    class Poller
    implements Runnable {
        Poller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ResourceCloser closer = new ResourceCloser();
            while (PollingMessageListenerContainer.this.running) {
                try {
                    if (PollingMessageListenerContainer.this.transactionManager != null) {
                        PollingMessageListenerContainer.this.transactionManager.begin();
                    }
                    Session session = closer.register(PollingMessageListenerContainer.this.connection.createSession(PollingMessageListenerContainer.this.transacted, PollingMessageListenerContainer.this.acknowledgeMode));
                    MessageConsumer consumer = closer.register(session.createConsumer(PollingMessageListenerContainer.this.destination, PollingMessageListenerContainer.this.messageSelector));
                    Message message = consumer.receive(1000L);
                    try {
                        if (message != null) {
                            PollingMessageListenerContainer.this.listenerHandler.onMessage(message);
                        }
                        if (PollingMessageListenerContainer.this.transactionManager != null) {
                            PollingMessageListenerContainer.this.transactionManager.commit();
                            continue;
                        }
                        session.commit();
                    }
                    catch (Exception e) {
                        PollingMessageListenerContainer.this.safeRollBack(session, e);
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Unexpected exception", e);
                }
                finally {
                    closer.close();
                }
            }
        }
    }
}

