/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.hornetq.api.core.management.HornetQServerControl;
import org.hornetq.core.config.DivertConfiguration;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.messaging.DivertAdd;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class DivertRemove
extends AbstractRemoveStepHandler {
    public static final DivertRemove INSTANCE = new DivertRemove();

    private DivertRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName hqServiceName;
        String name = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController hqService = registry.getService(hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (hqService != null && hqService.getState() == ServiceController.State.UP) {
            HornetQServer server = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
            try {
                server.getHornetQServerControl().destroyDivert(name);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName hqServiceName;
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController hqService = registry.getService(hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (hqService != null && hqService.getState() == ServiceController.State.UP) {
            String name = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            DivertConfiguration divertConfiguration = DivertAdd.createDivertConfiguration(context, name, model);
            HornetQServer server = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
            DivertAdd.createDivert(name, divertConfiguration, (HornetQServerControl)server.getHornetQServerControl());
        }
    }
}

